/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awtjs2d;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javajs.J2SRequireImport;
import javajs.api.EventManager;
import javajs.api.GenericMouseInterface;
import javajs.awt.event.Event;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

@J2SRequireImport(value={Event.class})
public class Mouse
implements GenericMouseInterface {
    private Viewer vwr;
    private EventManager manager;
    private String keyBuffer = "";
    private boolean isMouseDown;
    private boolean wheeling;
    private int xWhenPressed;
    private int yWhenPressed;
    private int modifiersWhenPressed10;

    public Mouse(double d, Viewer viewer, Object object) {
        this.vwr = viewer;
        this.manager = this.vwr.acm;
    }

    @Override
    public void clear() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean processEvent(int n, int n2, int n3, int n4, long l) {
        if (n != -1) {
            n4 = Mouse.applyLeftMouse(n4);
        }
        switch (n) {
            case -1: {
                this.wheeled(l, n2, n4);
                break;
            }
            case 501: {
                this.xWhenPressed = n2;
                this.yWhenPressed = n3;
                this.modifiersWhenPressed10 = n4;
                this.pressed(l, n2, n3, n4, false);
                break;
            }
            case 506: {
                this.dragged(l, n2, n3, n4);
                break;
            }
            case 504: {
                this.entry(l, n2, n3, false);
                break;
            }
            case 505: {
                this.entry(l, n2, n3, true);
                break;
            }
            case 503: {
                this.moved(l, n2, n3, n4);
                break;
            }
            case 502: {
                this.released(l, n2, n3, n4);
                if (n2 != this.xWhenPressed || n3 != this.yWhenPressed || n4 != this.modifiersWhenPressed10) break;
                this.clicked(l, n2, n3, n4, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void processTwoPointGesture(float[][][] fArray) {
        if (fArray[0].length < 2) {
            return;
        }
        float[][] fArray2 = fArray[0];
        float[][] fArray3 = fArray[1];
        float[] fArray4 = fArray2[0];
        float[] fArray5 = fArray2[fArray3.length - 1];
        float f = fArray4[0];
        float f2 = fArray5[0];
        float f3 = f2 - f;
        float f4 = fArray4[1];
        float f5 = fArray5[1];
        float f6 = f5 - f4;
        V3 v3 = V3.new3(f3, f6, 0.0f);
        float f7 = v3.length();
        float[] fArray6 = fArray3[0];
        float[] fArray7 = fArray3[fArray3.length - 1];
        float f8 = fArray6[0];
        float f9 = fArray7[0];
        float f10 = f9 - f8;
        float f11 = fArray6[1];
        float f12 = fArray7[1];
        float f13 = f12 - f11;
        V3 v32 = V3.new3(f10, f13, 0.0f);
        float f14 = v32.length();
        if (f7 < 1.0f || f14 < 1.0f) {
            return;
        }
        v3.normalize();
        v32.normalize();
        float f15 = v3.dot(v32);
        if ((double)f15 > 0.8) {
            int n = (int)(f2 - fArray2[fArray2.length - 2][0]);
            int n2 = (int)(f5 - fArray2[fArray2.length - 2][1]);
            this.vwr.translateXYBy(n, n2);
        } else if ((double)f15 < -0.8) {
            v3 = V3.new3(f8 - f, f11 - f4, 0.0f);
            v32 = V3.new3(f9 - f2, f12 - f5, 0.0f);
            float f16 = v32.length() - v3.length();
            this.wheeled(System.currentTimeMillis(), f16 < 0.0f ? -1 : 1, 32);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.clicked(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.getClickCount());
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.entry(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), false);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.entry(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), true);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers(), mouseEvent.isPopupTrigger());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.released(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if ((n & 0x1C) == 0) {
            n |= 0x10;
        }
        this.dragged(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), n);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moved(mouseEvent.getWhen(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        mouseWheelEvent.consume();
        this.wheeled(mouseWheelEvent.getWhen(), mouseWheelEvent.getWheelRotation(), mouseWheelEvent.getModifiers());
    }

    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
        if (!this.vwr.menuEnabled()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getModifiers();
        if (Logger.debuggingHigh) {
            Logger.debug("MouseManager keyTyped: " + c + " " + ('\u0000' + c) + " " + n);
        }
        if (n != 0 && n != 1) {
            switch (c) {
                case '\u000b': 
                case 'k': {
                    boolean bl = !this.vwr.getBooleanProperty("allowKeyStrokes");
                    switch (n) {
                        case 2: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", bl);
                            this.vwr.setBooleanProperty("showKeyStrokes", true);
                            break;
                        }
                        case 1: 
                        case 10: {
                            this.vwr.setBooleanProperty("allowKeyStrokes", bl);
                            this.vwr.setBooleanProperty("showKeyStrokes", false);
                        }
                    }
                    this.clearKeyBuffer();
                    this.vwr.refresh(3, "showkey");
                    break;
                }
                case '\u0016': 
                case 'v': {
                    switch (n) {
                        default: 
                    }
                    break;
                }
                case '\u001a': 
                case 'z': {
                    switch (n) {
                        case 2: {
                            this.vwr.undoMoveAction(4165, 1);
                            break;
                        }
                        case 3: {
                            this.vwr.undoMoveAction(4139, 1);
                        }
                    }
                    break;
                }
                case '\u0019': 
                case 'y': {
                    switch (n) {
                        case 2: {
                            this.vwr.undoMoveAction(4139, 1);
                        }
                    }
                }
            }
            return;
        }
        if (!this.vwr.getBooleanProperty("allowKeyStrokes")) {
            return;
        }
        this.addKeyBuffer(keyEvent.getModifiers() == 1 ? Character.toUpperCase(c) : c);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.vwr.isApplet) {
            keyEvent.consume();
        }
        this.manager.keyPressed(keyEvent.getKeyCode(), keyEvent.getModifiers());
    }

    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
        this.manager.keyReleased(keyEvent.getKeyCode());
    }

    private void clearKeyBuffer() {
        if (this.keyBuffer.length() == 0) {
            return;
        }
        this.keyBuffer = "";
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo \"\"", true, true);
        }
    }

    private void addKeyBuffer(char c) {
        if (c == '\n') {
            this.sendKeyBuffer();
            return;
        }
        if (c == '\b') {
            if (this.keyBuffer.length() > 0) {
                this.keyBuffer = this.keyBuffer.substring(0, this.keyBuffer.length() - 1);
            }
        } else {
            this.keyBuffer = this.keyBuffer + c;
        }
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc("\u0001" + this.keyBuffer), true, true);
        }
    }

    private void sendKeyBuffer() {
        String string = this.keyBuffer;
        if (this.vwr.getBooleanProperty("showKeyStrokes")) {
            this.vwr.evalStringQuietSync("!set echo _KEYSTROKES; set echo bottom left;echo " + PT.esc(this.keyBuffer), true, true);
        }
        this.clearKeyBuffer();
        this.vwr.evalStringQuietSync(string, false, true);
    }

    private void entry(long l, int n, int n2, boolean bl) {
        this.wheeling = false;
        this.manager.mouseEnterExit(l, n, n2, bl);
    }

    private void clicked(long l, int n, int n2, int n3, int n4) {
        this.clearKeyBuffer();
        this.manager.mouseAction(2, l, n, n2, 1, n3);
    }

    private void moved(long l, int n, int n2, int n3) {
        this.clearKeyBuffer();
        if (this.isMouseDown) {
            this.manager.mouseAction(1, l, n, n2, 0, Mouse.applyLeftMouse(n3));
        } else {
            this.manager.mouseAction(0, l, n, n2, 0, n3);
        }
    }

    private void wheeled(long l, int n, int n2) {
        this.clearKeyBuffer();
        this.wheeling = true;
        this.manager.mouseAction(3, l, 0, n, 0, n2 & 0xFFFFFFE3 | 0x20);
    }

    private void pressed(long l, int n, int n2, int n3, boolean bl) {
        this.clearKeyBuffer();
        this.isMouseDown = true;
        this.wheeling = false;
        this.manager.mouseAction(4, l, n, n2, 0, n3);
    }

    private void released(long l, int n, int n2, int n3) {
        this.isMouseDown = false;
        this.wheeling = false;
        this.manager.mouseAction(5, l, n, n2, 0, n3);
    }

    private void dragged(long l, int n, int n2, int n3) {
        if (this.wheeling) {
            return;
        }
        if ((n3 & 0x14) == 20) {
            n3 = n3 & 0xFFFFFFFB | 2;
        }
        this.manager.mouseAction(1, l, n, n2, 0, n3);
    }

    private static int applyLeftMouse(int n) {
        return (n & 0x1C) == 0 ? n | 0x10 : n;
    }
}

