/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.AtomSetObject;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.adapter.smarter.XtalSymmetry;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.util.Logger;

public class AtomSetCollection {
    AtomSetCollectionReader reader;
    public BS bsAtoms;
    public String fileTypeName;
    String collectionName;
    public Map<String, Object> atomSetInfo = new Hashtable<String, Object>();
    private static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "someModelsHaveCONECT", "isPDB", "someModelsHaveDomains", "someModelsHaveValidations"};
    public static final int GLOBAL_FRACTCOORD = 0;
    public static final int GLOBAL_SYMMETRY = 1;
    public static final int GLOBAL_UNITCELLS = 2;
    public static final int GLOBAL_CONECT = 3;
    public static final int GLOBAL_ISPDB = 4;
    public static final int GLOBAL_DOMAINS = 5;
    public static final int GLOBAL_VALIDATIONS = 6;
    public Atom[] atoms = new Atom[256];
    public int ac;
    public Bond[] bonds = new Bond[256];
    public int bondCount;
    public Structure[] structures = new Structure[16];
    public int structureCount;
    public int atomSetCount;
    public int iSet = -1;
    public int[] atomSetNumbers = new int[16];
    public int[] atomSetAtomIndexes = new int[16];
    public int[] atomSetAtomCounts = new int[16];
    public int[] atomSetBondCounts = new int[16];
    public Map<String, Object>[] atomSetAuxiliaryInfo = new Hashtable[16];
    public String errorMessage;
    public boolean coordinatesAreFractional;
    boolean isTrajectory;
    private int trajectoryStepCount = 0;
    private Lst<P3[]> trajectorySteps;
    private Lst<V3[]> vibrationSteps;
    private Lst<String> trajectoryNames;
    public boolean doFixPeriodic;
    public boolean allowMultiple;
    private Lst<AtomSetCollectionReader> readerList;
    public BS bsStructuredModels;
    public boolean haveAnisou;
    public int baseSymmetryAtomCount;
    public boolean checkLatticeOnly;
    public XtalSymmetry xtalSymmetry;
    int bondIndex0;
    public boolean checkSpecial = true;
    public Map<String, Atom> atomSymbolicMap = new Hashtable<String, Atom>();
    public boolean haveUnitCell;
    public int vibScale;

    public void setCollectionName(String string) {
        if (string == null || (string = string.trim()).length() == 0) {
            return;
        }
        this.collectionName = string;
    }

    public void clearGlobalBoolean(int n) {
        this.atomSetInfo.remove(globalBooleans[n]);
    }

    public void setGlobalBoolean(int n) {
        this.setInfo(globalBooleans[n], Boolean.TRUE);
    }

    boolean getGlobalBoolean(int n) {
        return this.atomSetInfo.get(globalBooleans[n]) == Boolean.TRUE;
    }

    public AtomSetCollection(String string, AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection[] atomSetCollectionArray, Lst<?> lst) {
        this.fileTypeName = string;
        this.reader = atomSetCollectionReader;
        this.allowMultiple = atomSetCollectionReader == null || atomSetCollectionReader.desiredVibrationNumber < 0;
        Properties properties = new Properties();
        properties.put("PATH_KEY", ".PATH");
        properties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
        this.setInfo("properties", properties);
        if (atomSetCollectionArray != null) {
            int n = 0;
            this.readerList = new Lst();
            for (int i = 0; i < atomSetCollectionArray.length; ++i) {
                if (atomSetCollectionArray[i].ac <= 0 && (atomSetCollectionArray[i].reader == null || !atomSetCollectionArray[i].reader.mustFinalizeModelSet)) continue;
                this.appendAtomSetCollection(n++, atomSetCollectionArray[i]);
            }
            if (n > 1) {
                this.setInfo("isMultiFile", Boolean.TRUE);
            }
        } else if (lst != null) {
            this.setInfo("isMultiFile", Boolean.TRUE);
            this.appendAtomSetCollectionList(lst);
        }
    }

    private void appendAtomSetCollectionList(Lst<?> lst) {
        int n = lst.size();
        if (n == 0) {
            this.errorMessage = "No file found!";
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object e = lst.get(i);
            if (e instanceof Lst) {
                this.appendAtomSetCollectionList((Lst)e);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)e);
        }
    }

    public void setTrajectory() {
        int n;
        int n2;
        if (!this.isTrajectory) {
            this.trajectorySteps = new Lst();
        }
        this.isTrajectory = true;
        int n3 = n2 = this.bsAtoms == null ? this.ac : this.bsAtoms.cardinality();
        if (n2 == 0) {
            return;
        }
        P3[] p3Array = new P3[n2];
        boolean bl = n2 > 0 && this.atoms[0].vib != null && !Float.isNaN(this.atoms[0].vib.z);
        V3[] v3Array = bl ? new V3[n2] : null;
        P3[] p3Array2 = this.trajectoryStepCount == 0 ? null : (P3[])this.trajectorySteps.get(this.trajectoryStepCount - 1);
        int n4 = 0;
        for (n = 0; n < this.ac; ++n) {
            if (this.bsAtoms != null && !this.bsAtoms.get(n)) continue;
            P3 p3 = P3.newP(this.atoms[n]);
            if (this.doFixPeriodic && p3Array2 != null) {
                p3 = AtomSetCollection.fixPeriodic(p3, p3Array2[n]);
            }
            p3Array[n4] = p3;
            if (bl) {
                v3Array[n4] = this.atoms[n].vib;
            }
            ++n4;
        }
        if (bl) {
            if (this.vibrationSteps == null) {
                this.vibrationSteps = new Lst();
                for (n = 0; n < this.trajectoryStepCount; ++n) {
                    this.vibrationSteps.addLast(null);
                }
            }
            this.vibrationSteps.addLast(v3Array);
        }
        this.trajectorySteps.addLast(p3Array);
        ++this.trajectoryStepCount;
    }

    public void appendAtomSetCollection(int n, AtomSetCollection atomSetCollection) {
        Object object;
        int n2;
        int n3;
        if (atomSetCollection.reader != null && atomSetCollection.reader.mustFinalizeModelSet) {
            this.readerList.addLast(atomSetCollection.reader);
        }
        int n4 = this.ac;
        this.setInfo("loadState", atomSetCollection.atomSetInfo.get("loadState"));
        if (atomSetCollection.bsAtoms != null) {
            if (this.bsAtoms == null) {
                this.bsAtoms = new BS();
            }
            n3 = atomSetCollection.bsAtoms.nextSetBit(0);
            while (n3 >= 0) {
                this.bsAtoms.set(n4 + n3);
                n3 = atomSetCollection.bsAtoms.nextSetBit(n3 + 1);
            }
        }
        n3 = 0;
        int n5 = this.atomSetCount;
        for (n2 = 0; n2 < atomSetCollection.atomSetCount; ++n2) {
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.iSet] = atomSetCollection.atomSetAuxiliaryInfo[n2];
            object = this.atomSetAuxiliaryInfo[this.iSet];
            int[] nArray = (int[])object.get("PDB_CONECT_firstAtom_count_max");
            if (nArray != null) {
                nArray[0] = nArray[0] + n4;
            }
            this.setCurrentModelInfo("title", atomSetCollection.collectionName);
            this.setAtomSetName(atomSetCollection.getAtomSetName(n2));
            for (int i = 0; i < atomSetCollection.atomSetAtomCounts[n2]; ++i) {
                try {
                    if (this.bsAtoms != null) {
                        this.bsAtoms.set(this.ac);
                    }
                    this.newCloneAtom(atomSetCollection.atoms[n3]);
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
                ++n3;
            }
            this.atomSetNumbers[this.iSet] = n < 0 ? this.iSet + 1 : (n + 1) * 1000000 + atomSetCollection.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < atomSetCollection.bondCount; ++n2) {
            object = atomSetCollection.bonds[n2];
            this.addNewBondWithOrder(((Bond)object).atomIndex1 + n4, ((Bond)object).atomIndex2 + n4, ((Bond)object).order);
        }
        n2 = globalBooleans.length;
        while (--n2 >= 0) {
            if (!atomSetCollection.getGlobalBoolean(n2)) continue;
            this.setGlobalBoolean(n2);
        }
        for (n2 = 0; n2 < atomSetCollection.structureCount; ++n2) {
            object = atomSetCollection.structures[n2];
            this.addStructure((Structure)object);
            ((Structure)object).modelStartEnd[0] = ((Structure)object).modelStartEnd[0] + n5;
            ((Structure)object).modelStartEnd[1] = ((Structure)object).modelStartEnd[1] + n5;
        }
    }

    public void setNoAutoBond() {
        this.setInfo("noAutoBond", Boolean.TRUE);
    }

    void freeze(boolean bl) {
        if (this.atomSetCount == 1 && this.collectionName == null) {
            this.collectionName = (String)this.getAtomSetAuxiliaryInfoValue(0, "name");
        }
        if (bl) {
            this.reverseAtomSets();
        }
        if (this.trajectoryStepCount > 1) {
            this.finalizeTrajectory();
        }
        this.getList(true);
        this.getList(false);
        for (int i = 0; i < this.atomSetCount; ++i) {
            this.setModelInfoForSet("initialAtomCount", this.atomSetAtomCounts[i], i);
            this.setModelInfoForSet("initialBondCount", this.atomSetBondCounts[i], i);
        }
    }

    private void reverseAtomSets() {
        int n;
        int n2;
        this.reverseArray(this.atomSetAtomIndexes);
        this.reverseArray(this.atomSetNumbers);
        this.reverseArray(this.atomSetAtomCounts);
        this.reverseArray(this.atomSetBondCounts);
        AtomSetCollection.reverseList(this.trajectorySteps);
        AtomSetCollection.reverseList(this.trajectoryNames);
        AtomSetCollection.reverseList(this.vibrationSteps);
        this.reverseObject(this.atomSetAuxiliaryInfo);
        for (n2 = 0; n2 < this.ac; ++n2) {
            this.atoms[n2].atomSetIndex = this.atomSetCount - 1 - this.atoms[n2].atomSetIndex;
        }
        for (n2 = 0; n2 < this.structureCount; ++n2) {
            n = this.structures[n2].modelStartEnd[0];
            if (n < 0) continue;
            this.structures[n2].modelStartEnd[0] = this.atomSetCount - 1 - this.structures[n2].modelStartEnd[1];
            this.structures[n2].modelStartEnd[1] = this.atomSetCount - 1 - n;
        }
        for (n2 = 0; n2 < this.bondCount; ++n2) {
            this.bonds[n2].atomSetIndex = this.atomSetCount - 1 - this.atoms[this.bonds[n2].atomIndex1].atomSetIndex;
        }
        this.reverseSets(this.bonds, this.bondCount);
        Lst<type>[] lstArray = AU.createArrayOfArrayList(this.atomSetCount);
        for (n = 0; n < this.atomSetCount; ++n) {
            lstArray[n] = new Lst();
        }
        for (n = 0; n < this.ac; ++n) {
            lstArray[this.atoms[n].atomSetIndex].addLast(this.atoms[n]);
        }
        int[] nArray = new int[this.ac];
        int n3 = this.ac;
        int n4 = this.atomSetCount;
        while (--n4 >= 0) {
            int n5 = lstArray[n4].size();
            while (--n5 >= 0) {
                Atom atom = this.atoms[--n3] = (Atom)lstArray[n4].get(n5);
                nArray[atom.index] = n3;
                atom.index = n3;
            }
        }
        for (n4 = 0; n4 < this.bondCount; ++n4) {
            this.bonds[n4].atomIndex1 = nArray[this.bonds[n4].atomIndex1];
            this.bonds[n4].atomIndex2 = nArray[this.bonds[n4].atomIndex2];
        }
        for (n4 = 0; n4 < this.atomSetCount; ++n4) {
            int[] nArray2 = (int[])this.getAtomSetAuxiliaryInfoValue(n4, "PDB_CONECT_firstAtom_count_max");
            if (nArray2 == null) continue;
            nArray2[0] = nArray[nArray2[0]];
            nArray2[1] = this.atomSetAtomCounts[n4];
        }
    }

    private void reverseSets(AtomSetObject[] atomSetObjectArray, int n) {
        int n2;
        int n3;
        Lst<type>[] lstArray = AU.createArrayOfArrayList(this.atomSetCount);
        for (n3 = 0; n3 < this.atomSetCount; ++n3) {
            lstArray[n3] = new Lst();
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = atomSetObjectArray[n3].atomSetIndex;
            if (n2 < 0) {
                return;
            }
            lstArray[atomSetObjectArray[n3].atomSetIndex].addLast(atomSetObjectArray[n3]);
        }
        n3 = this.atomSetCount;
        while (--n3 >= 0) {
            n2 = lstArray[n3].size();
            while (--n2 >= 0) {
                atomSetObjectArray[--n] = (AtomSetObject)lstArray[n3].get(n2);
            }
        }
    }

    private void reverseObject(Object[] objectArray) {
        int n = this.atomSetCount;
        int n2 = n / 2;
        while (--n2 >= 0) {
            AU.swap(objectArray, n2, n - 1 - n2);
        }
    }

    private static void reverseList(Lst<?> lst) {
        if (lst == null) {
            return;
        }
        Collections.reverse(lst);
    }

    private void reverseArray(int[] nArray) {
        int n = this.atomSetCount;
        int n2 = n / 2;
        while (--n2 >= 0) {
            AU.swapInt(nArray, n2, n - 1 - n2);
        }
    }

    private void getList(boolean bl) {
        int n = this.ac;
        while (--n >= 0 && (this.atoms[n] == null || (bl ? this.atoms[n].altLoc : this.atoms[n].insertionCode) == '\u0000')) {
        }
        if (n < 0) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.ac; ++n) {
            int n2;
            char c;
            if (this.atoms[n] == null) continue;
            char c2 = c = bl ? this.atoms[n].altLoc : this.atoms[n].insertionCode;
            if (c == '\u0000' || stringArray[n2 = this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n3 = n2;
            stringArray[n3] = stringArray[n3] + c;
        }
        String string = bl ? "altLocs" : "insertionCodes";
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setModelInfoForSet(string, stringArray[n], n);
        }
    }

    void finish() {
        if (this.reader != null) {
            this.reader.finalizeModelSet();
        } else if (this.readerList != null) {
            for (int i = 0; i < this.readerList.size(); ++i) {
                ((AtomSetCollectionReader)this.readerList.get(i)).finalizeModelSet();
            }
        }
        this.atoms = null;
        this.atomSetAtomCounts = new int[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.atomSetInfo = new Hashtable<String, Object>();
        this.atomSetCount = 0;
        this.atomSetNumbers = new int[16];
        this.atomSymbolicMap = new Hashtable<String, Atom>();
        this.bonds = null;
        this.iSet = -1;
        this.readerList = null;
        this.xtalSymmetry = null;
        this.structures = new Structure[16];
        this.structureCount = 0;
        this.trajectorySteps = null;
        this.vibrationSteps = null;
    }

    public void discardPreviousAtoms() {
        int n = this.ac;
        while (--n >= 0) {
            this.atoms[n] = null;
        }
        this.ac = 0;
        this.atomSymbolicMap.clear();
        this.atomSetCount = 0;
        this.iSet = -1;
        n = this.atomSetAuxiliaryInfo.length;
        while (--n >= 0) {
            this.atomSetAtomCounts[n] = 0;
            this.atomSetBondCounts[n] = 0;
            this.atomSetAuxiliaryInfo[n] = null;
        }
    }

    public void removeCurrentAtomSet() {
        if (this.iSet < 0) {
            return;
        }
        int n = this.atomSetAtomIndexes[this.iSet];
        if (this.bsAtoms != null) {
            this.bsAtoms.clearBits(n, this.ac);
        }
        this.ac = n;
        this.atomSetAtomCounts[this.iSet] = 0;
        --this.iSet;
        --this.atomSetCount;
        this.reader.doCheckUnitCell = false;
    }

    public int getHydrogenAtomCount() {
        int n = 0;
        for (int i = 0; i < this.ac; ++i) {
            if (this.atoms[i].elementNumber != 1 && !this.atoms[i].elementSymbol.equals("H")) continue;
            ++n;
        }
        return n;
    }

    public Atom newCloneAtom(Atom atom) throws Exception {
        Atom atom2 = atom.getClone();
        this.addAtom(atom2);
        return atom2;
    }

    public int cloneFirstAtomSet(int n) throws Exception {
        if (!this.allowMultiple) {
            return 0;
        }
        this.newAtomSet();
        if (n == 0) {
            n = this.atomSetAtomCounts[0];
        }
        for (int i = 0; i < n; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
        return this.ac;
    }

    public void cloneAtomSetWithBonds(boolean bl) throws Exception {
        int n;
        int n2 = this.atomSetBondCounts[bl ? this.iSet : 0];
        int n3 = n = bl ? this.cloneLastAtomSet() : this.cloneFirstAtomSet(0);
        if (n > 0) {
            for (int i = 0; i < n2; ++i) {
                Bond bond = this.bonds[this.bondCount - n2];
                this.addNewBondWithOrder(bond.atomIndex1 + n, bond.atomIndex2 + n, bond.order);
            }
        }
    }

    public int cloneLastAtomSet() throws Exception {
        return this.cloneLastAtomSetFromPoints(0, null);
    }

    public int cloneLastAtomSetFromPoints(int n, P3[] p3Array) throws Exception {
        if (!this.allowMultiple) {
            return 0;
        }
        int n2 = n > 0 ? n : this.getLastAtomSetAtomCount();
        int n3 = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        for (int i = 0; i < n2; ++i) {
            Atom atom = this.newCloneAtom(this.atoms[n3++]);
            if (p3Array == null) continue;
            atom.setT(p3Array[i]);
        }
        return n2;
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.iSet];
    }

    public int getLastAtomSetAtomIndex() {
        return this.ac - this.atomSetAtomCounts[this.iSet];
    }

    public Atom addNewAtom() {
        return this.addAtom(new Atom());
    }

    public Atom addAtom(Atom atom) {
        if (this.ac == this.atoms.length) {
            this.atoms = this.ac > 200000 ? (Atom[])AU.ensureLength(this.atoms, this.ac + 50000) : (Atom[])AU.doubleLength(this.atoms);
        }
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.index = this.ac;
        this.atoms[this.ac++] = atom;
        atom.atomSetIndex = this.iSet;
        int n = this.iSet;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
        return atom;
    }

    public void addAtomWithMappedName(Atom atom) {
        String string = this.addAtom((Atom)atom).atomName;
        if (string != null) {
            this.atomSymbolicMap.put(string, atom);
        }
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        int n = this.addAtom((Atom)atom).atomSerial;
        if (n != Integer.MIN_VALUE) {
            this.atomSymbolicMap.put("" + n, atom);
        }
    }

    public Atom getAtomFromName(String string) {
        return this.atomSymbolicMap.get(string);
    }

    public int getAtomIndex(String string) {
        Atom atom = this.atomSymbolicMap.get(string);
        return atom == null ? -1 : atom.index;
    }

    public Bond addNewBondWithOrder(int n, int n2, int n3) {
        if (n < 0 || n >= this.ac || n2 < 0 || n2 >= this.ac) {
            return null;
        }
        Bond bond = new Bond(n, n2, n3);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBondFromNames(String string, String string2, int n) {
        return this.addNewBondWithOrderA(this.getAtomFromName(string), this.getAtomFromName(string2), n);
    }

    public Bond addNewBondWithOrderA(Atom atom, Atom atom2, int n) {
        return atom == null || atom2 == null ? null : this.addNewBondWithOrder(atom.index, atom2.index, n);
    }

    public void addBond(Bond bond) {
        if (this.trajectoryStepCount > 0) {
            return;
        }
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])AU.arrayCopyObject(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
        int n = this.iSet;
        this.atomSetBondCounts[n] = this.atomSetBondCounts[n] + 1;
    }

    public void finalizeStructures() {
        Structure structure;
        int n;
        if (this.structureCount == 0) {
            return;
        }
        this.bsStructuredModels = new BS();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (n = 0; n < this.structureCount; ++n) {
            structure = this.structures[n];
            if (structure.modelStartEnd[0] == -1) {
                structure.modelStartEnd[0] = 0;
                structure.modelStartEnd[1] = this.atomSetCount - 1;
            }
            this.bsStructuredModels.setBits(structure.modelStartEnd[0], structure.modelStartEnd[1] + 1);
            if (structure.strandCount == 0) continue;
            String string = structure.structureID + " " + structure.modelStartEnd[0];
            Integer n2 = (Integer)hashtable.get(string);
            int n3 = (n2 == null ? 0 : n2) + 1;
            hashtable.put(string, n3);
        }
        for (n = 0; n < this.structureCount; ++n) {
            structure = this.structures[n];
            if (structure.strandCount != 1) continue;
            structure.strandCount = (Integer)hashtable.get(structure.structureID + " " + structure.modelStartEnd[0]);
        }
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])AU.arrayCopyObject(this.structures, this.structureCount + 32);
        }
        this.structures[this.structureCount++] = structure;
    }

    public void addVibrationVectorWithSymmetry(int n, float f, float f2, float f3, boolean bl) {
        if (!bl) {
            this.addVibrationVector(n, f, f2, f3);
            return;
        }
        int n2 = this.atoms[n].atomSite;
        int n3 = this.atoms[n].atomSetIndex;
        for (int i = n; i < this.ac && this.atoms[i].atomSetIndex == n3; ++i) {
            if (this.atoms[i].atomSite != n2) continue;
            this.addVibrationVector(i, f, f2, f3);
        }
    }

    public V3 addVibrationVector(int n, float f, float f2, float f3) {
        if (!this.allowMultiple) {
            n %= this.ac;
        }
        this.atoms[n].vib = V3.new3(f, f2, f3);
        return this.atoms[n].vib;
    }

    public void setCoordinatesAreFractional(boolean bl) {
        this.coordinatesAreFractional = bl;
        this.setCurrentModelInfo("coordinatesAreFractional", bl);
        if (bl) {
            this.setGlobalBoolean(0);
        }
    }

    public void setAnisoBorU(Atom atom, float[] fArray, int n) {
        this.haveAnisou = true;
        atom.anisoBorU = fArray;
        fArray[6] = n;
    }

    public void setU(Atom atom, int n, float f) {
        float[] fArray = atom.anisoBorU;
        if (fArray == null) {
            fArray = new float[8];
            this.setAnisoBorU(atom, fArray, 8);
        }
        fArray[n] = f;
    }

    public XtalSymmetry getXSymmetry() {
        if (this.xtalSymmetry == null) {
            this.xtalSymmetry = ((XtalSymmetry)Interface.getOption("adapter.smarter.XtalSymmetry", this.reader.vwr, "file")).set(this.reader);
        }
        return this.xtalSymmetry;
    }

    public SymmetryInterface getSymmetry() {
        return this.getXSymmetry().getSymmetry();
    }

    public SymmetryInterface setSymmetry(SymmetryInterface symmetryInterface) {
        return symmetryInterface == null ? null : this.getXSymmetry().setSymmetry(symmetryInterface);
    }

    public void setTensors() {
        if (this.haveAnisou) {
            this.getXSymmetry().setTensors();
        }
    }

    public void setInfo(String string, Object object) {
        if (object == null) {
            this.atomSetInfo.remove(string);
        } else {
            this.atomSetInfo.put(string, object);
        }
    }

    public boolean setAtomSetCollectionPartialCharges(String string) {
        if (!this.atomSetInfo.containsKey(string)) {
            return false;
        }
        Lst lst = (Lst)this.atomSetInfo.get(string);
        int n = lst.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)lst.get(n)).floatValue();
        }
        Logger.info("Setting partial charges type " + string);
        return true;
    }

    public void mapPartialCharge(String string, float f) {
        this.getAtomFromName((String)string).partialCharge = f;
    }

    private static P3 fixPeriodic(P3 p3, P3 p32) {
        p3.x = AtomSetCollection.fixPoint(p3.x, p32.x);
        p3.y = AtomSetCollection.fixPoint(p3.y, p32.y);
        p3.z = AtomSetCollection.fixPoint(p3.z, p32.z);
        return p3;
    }

    private static float fixPoint(float f, float f2) {
        while ((double)(f - f2) > 0.9) {
            f -= 1.0f;
        }
        while ((double)(f - f2) < -0.9) {
            f += 1.0f;
        }
        return f;
    }

    public void finalizeTrajectoryAs(Lst<P3[]> lst, Lst<V3[]> lst2) {
        this.trajectorySteps = lst;
        this.vibrationSteps = lst2;
        this.trajectoryStepCount = lst.size();
        this.finalizeTrajectory();
    }

    private void finalizeTrajectory() {
        int n;
        if (this.trajectoryStepCount == 0) {
            return;
        }
        P3[] p3Array = (P3[])this.trajectorySteps.get(0);
        V3[] v3Array = this.vibrationSteps == null ? null : (V3[])this.vibrationSteps.get(0);
        int n2 = n = this.bsAtoms == null ? this.ac : this.bsAtoms.cardinality();
        if (this.vibrationSteps != null && v3Array != null && v3Array.length < n || p3Array.length < n) {
            this.errorMessage = "File cannot be loaded as a trajectory";
            return;
        }
        V3 v3 = new V3();
        int n3 = 0;
        for (int i = 0; i < this.ac; ++i) {
            if (this.bsAtoms != null && !this.bsAtoms.get(i)) continue;
            if (this.vibrationSteps != null) {
                V3 v32 = this.atoms[i].vib = v3Array == null ? v3 : v3Array[n3];
            }
            if (p3Array[n3] != null) {
                this.atoms[i].setT(p3Array[n3]);
            }
            ++n3;
        }
        this.setInfo("trajectorySteps", this.trajectorySteps);
        if (this.vibrationSteps != null) {
            this.setInfo("vibrationSteps", this.vibrationSteps);
        }
    }

    public void newAtomSet() {
        this.newAtomSetClear(true);
    }

    public void newAtomSetClear(boolean bl) {
        if (!this.allowMultiple && this.iSet >= 0) {
            this.discardPreviousAtoms();
        }
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            this.discardPreviousAtoms();
        }
        this.iSet = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetAtomIndexes = AU.doubleLengthI(this.atomSetAtomIndexes);
            this.atomSetAtomCounts = AU.doubleLengthI(this.atomSetAtomCounts);
            this.atomSetBondCounts = AU.doubleLengthI(this.atomSetBondCounts);
            this.atomSetAuxiliaryInfo = (Map[])AU.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetAtomIndexes[this.iSet] = this.ac;
        if (this.atomSetCount + this.trajectoryStepCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = AU.doubleLengthI(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.iSet + this.trajectoryStepCount] = this.atomSetCount + this.trajectoryStepCount;
        } else {
            this.atomSetNumbers[this.iSet] = this.atomSetCount;
        }
        if (bl) {
            this.atomSymbolicMap.clear();
        }
        this.setCurrentModelInfo("title", this.collectionName);
    }

    public int getAtomSetAtomIndex(int n) {
        return this.atomSetAtomIndexes[n];
    }

    public int getAtomSetAtomCount(int n) {
        return this.atomSetAtomCounts[n];
    }

    public int getAtomSetBondCount(int n) {
        return this.atomSetBondCounts[n];
    }

    public void setAtomSetName(String string) {
        if (this.isTrajectory) {
            this.setTrajectoryName(string);
            return;
        }
        this.setModelInfoForSet("name", string, this.iSet);
        if (!this.allowMultiple) {
            this.setCollectionName(string);
        }
    }

    private void setTrajectoryName(String string) {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        if (this.trajectoryNames == null) {
            this.trajectoryNames = new Lst();
        }
        for (int i = this.trajectoryNames.size(); i < this.trajectoryStepCount; ++i) {
            this.trajectoryNames.addLast(null);
        }
        this.trajectoryNames.set(this.trajectoryStepCount - 1, string);
    }

    public void setCurrentAtomSetNumber(int n) {
        this.setAtomSetNumber(this.iSet + (this.isTrajectory ? this.trajectoryStepCount : 0), n);
    }

    public void setAtomSetNumber(int n, int n2) {
        this.atomSetNumbers[n] = n2;
    }

    public void setAtomSetModelProperty(String string, String string2) {
        this.setAtomSetModelPropertyForSet(string, string2, this.iSet);
    }

    public void setAtomSetModelPropertyForSet(String string, String string2, int n) {
        Properties properties = (Properties)this.getAtomSetAuxiliaryInfoValue(n, "modelProperties");
        if (properties == null) {
            properties = new Properties();
            this.setModelInfoForSet("modelProperties", properties, n);
        }
        properties.put(string, string2);
        if (string.startsWith(".")) {
            properties.put(string.substring(1), string2);
        }
    }

    public void setAtomProperties(String string, Object object, int n, boolean bl) {
        Hashtable<String, Object> hashtable;
        if (object instanceof String && !((String)object).endsWith("\n")) {
            object = object + "\n";
        }
        if (n < 0) {
            n = this.iSet;
        }
        if ((hashtable = (Hashtable<String, Object>)this.getAtomSetAuxiliaryInfoValue(n, "atomProperties")) == null) {
            hashtable = new Hashtable<String, Object>();
            this.setModelInfoForSet("atomProperties", hashtable, n);
        }
        hashtable.put(string, object);
    }

    boolean setAtomSetPartialCharges(String string) {
        if (!this.atomSetAuxiliaryInfo[this.iSet].containsKey(string)) {
            return false;
        }
        Lst lst = (Lst)this.getAtomSetAuxiliaryInfoValue(this.iSet, string);
        int n = lst.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)lst.get(n)).floatValue();
        }
        return true;
    }

    public Object getAtomSetAuxiliaryInfoValue(int n, String string) {
        return this.atomSetAuxiliaryInfo[n >= 0 ? n : this.iSet].get(string);
    }

    public void setCurrentModelInfo(String string, Object object) {
        this.setModelInfoForSet(string, object, this.iSet);
    }

    public void setModelInfoForSet(String string, Object object, int n) {
        if (n < 0) {
            return;
        }
        if (this.atomSetAuxiliaryInfo[n] == null) {
            this.atomSetAuxiliaryInfo[n] = new Hashtable<String, Object>();
        }
        if (object == null) {
            this.atomSetAuxiliaryInfo[n].remove(string);
        } else {
            this.atomSetAuxiliaryInfo[n].put(string, object);
        }
    }

    int getAtomSetNumber(int n) {
        return this.atomSetNumbers[n >= this.atomSetCount ? 0 : n];
    }

    String getAtomSetName(int n) {
        if (this.trajectoryNames != null && n < this.trajectoryNames.size()) {
            return (String)this.trajectoryNames.get(n);
        }
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return (String)this.getAtomSetAuxiliaryInfoValue(n, "name");
    }

    public Map<String, Object> getAtomSetAuxiliaryInfo(int n) {
        int n2 = n >= this.atomSetCount ? this.atomSetCount - 1 : n;
        return n2 < 0 ? null : this.atomSetAuxiliaryInfo[n2];
    }

    public void setAtomSetEnergy(String string, float f) {
        if (this.iSet < 0) {
            return;
        }
        Logger.info("Energy for model " + (this.iSet + 1) + " = " + string);
        this.setCurrentModelInfo("EnergyString", string);
        this.setCurrentModelInfo("Energy", Float.valueOf(f));
        this.setAtomSetModelProperty("Energy", "" + f);
    }

    public String setAtomSetFrequency(String string, String string2, String string3, String string4) {
        this.setAtomSetModelProperty("FreqValue", string3);
        string3 = string3 + " " + (string4 == null ? "cm^-1" : string4);
        String string5 = (string2 == null ? "" : string2 + " ") + string3;
        this.setAtomSetName(string5);
        this.setAtomSetModelProperty("Frequency", string3);
        if (string2 != null) {
            this.setAtomSetModelProperty("FrequencyLabel", string2);
        }
        this.setAtomSetModelProperty(".PATH", (string == null ? "" : string + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies") + "Frequencies");
        return string5;
    }

    public String[][] getBondList() {
        String[][] stringArray = new String[this.bondCount][];
        for (int i = 0; i < this.bondCount; ++i) {
            stringArray[i] = new String[]{this.atoms[this.bonds[i].atomIndex1].atomName, this.atoms[this.bonds[i].atomIndex2].atomName, "" + this.bonds[i].order};
        }
        return stringArray;
    }

    public void centralize() {
        P3 p3 = new P3();
        for (int i = 0; i < this.atomSetCount; ++i) {
            int n = this.atomSetAtomCounts[i];
            int n2 = this.atomSetAtomIndexes[i];
            p3.set(0.0f, 0.0f, 0.0f);
            int n3 = n2 + n;
            while (--n3 >= n2) {
                p3.add(this.atoms[n3]);
            }
            p3.scale(1.0f / (float)n);
            n3 = n2 + n;
            while (--n3 >= n2) {
                this.atoms[n3].sub(p3);
            }
        }
    }

    void mergeTrajectories(AtomSetCollection atomSetCollection) {
        if (!this.isTrajectory || !atomSetCollection.isTrajectory || this.vibrationSteps != null) {
            return;
        }
        for (int i = 0; i < atomSetCollection.trajectoryStepCount; ++i) {
            this.trajectorySteps.add(this.trajectoryStepCount++, atomSetCollection.trajectorySteps.get(i));
        }
        this.setInfo("trajectorySteps", this.trajectorySteps);
    }
}

