/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.Viewer;

abstract class ScriptTokenParser {
    protected Viewer vwr;
    protected String script;
    protected boolean isStateScript;
    protected short lineCurrent;
    protected int iCommand;
    protected int ichCurrentCommand;
    protected int ichComment;
    protected int ichEnd;
    protected int ichToken;
    protected T theToken;
    protected T lastFlowCommand;
    protected T tokenCommand;
    protected T lastToken;
    protected T tokenAndEquals;
    protected int theTok;
    protected int nTokens;
    protected int tokCommand;
    protected int ptNewSetModifier;
    protected boolean isNewSet;
    protected boolean logMessages = true;
    protected T[] atokenInfix;
    protected int itokenInfix;
    protected boolean isSetBrace;
    protected boolean isMathExpressionCommand;
    protected boolean isSetOrDefine;
    private Lst<T> ltokenPostfix;
    protected boolean isEmbeddedExpression;
    protected boolean isCommaAsOrAllowed;
    private Object theValue;
    protected Map<String, Boolean> htUserFunctions;
    boolean haveString;
    private boolean residueSpecCodeGenerated;
    protected String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorLine;
    protected String errorType;
    protected static final int ERROR_badArgumentCount = 0;
    protected static final int ERROR_badContext = 1;
    protected static final int ERROR_commandExpected = 2;
    protected static final int ERROR_endOfCommandUnexpected = 4;
    protected static final int ERROR_invalidExpressionToken = 9;
    protected static final int ERROR_missingEnd = 11;
    protected static final int ERROR_tokenExpected = 15;
    protected static final int ERROR_tokenUnexpected = 16;
    protected static final int ERROR_unrecognizedParameter = 18;
    protected static final int ERROR_unrecognizedToken = 19;
    private static final int ERROR_coordinateExpected = 3;
    private static final int ERROR_endOfExpressionExpected = 5;
    private static final int ERROR_identifierOrResidueSpecificationExpected = 6;
    private static final int ERROR_invalidAtomSpecification = 7;
    private static final int ERROR_invalidChainSpecification = 8;
    private static final int ERROR_invalidModelSpecification = 10;
    private static final int ERROR_numberExpected = 12;
    private static final int ERROR_numberOrVariableNameExpected = 13;
    private static final int ERROR_residueSpecificationExpected = 14;
    private static final int ERROR_unrecognizedExpressionToken = 17;

    ScriptTokenParser() {
    }

    protected boolean compileExpressions() {
        boolean bl;
        boolean bl2 = (this.tokCommand == 135271429 || this.tokCommand == 4124) && this.tokAt(2) == 0x10100010;
        this.isEmbeddedExpression = bl2 || this.tokCommand != 0 && (this.tokCommand != 135368713 && this.tokCommand != 102436 && this.tokCommand != 364558 && this.tokCommand != 102412 || this.tokenCommand.intValue != Integer.MAX_VALUE) && this.tokCommand != 0x119009 && !T.tokAttr(this.tokCommand, 12288) && (this.nTokens > 2 || !T.tokAttr(this.tokCommand, 20480));
        this.isMathExpressionCommand = this.tokCommand == 0x40000000 || bl2 || T.tokAttr(this.tokCommand, 36864);
        boolean bl3 = bl = this.isEmbeddedExpression || T.tokAttr(this.tokCommand, 12288);
        if (this.tokAt(1) == 0x100006 && T.tokAttr(this.tokCommand, 12288)) {
            bl = false;
        }
        if (bl && !this.compileExpression()) {
            return false;
        }
        int n = this.atokenInfix.length;
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            if (this.tokAt(i) != 1060866) continue;
            ++n2;
        }
        if (this.isNewSet && (n -= n2) == 1) {
            this.atokenInfix[0] = T.tv(135368713, 0, this.atokenInfix[0].value);
            this.isNewSet = false;
        }
        return (this.isNewSet || this.isSetBrace) && n < this.ptNewSetModifier + 2 ? this.commandExpected() : (n == 1 || !T.tokAttr(this.tokCommand, 262144) ? true : this.error(0));
    }

    protected boolean compileExpression() {
        int n;
        int n2 = this.isSetOrDefine && !this.isSetBrace ? 2 : 1;
        this.ltokenPostfix = new Lst();
        this.itokenInfix = 0;
        T t = null;
        int n3 = this.tokAt(1);
        switch (this.tokCommand) {
            case 1060866: {
                int n4 = n = this.tokAt(1) == 1060866 ? 2 : 1;
                if (this.tokAt(n) != 2 || this.tokAt(n + 1) != 0x100007 || this.tokAt(n + 3) != 269484436) break;
                this.tokCommand = 1085443;
                this.isSetBrace = true;
                this.ptNewSetModifier = n + 3;
                this.isMathExpressionCommand = true;
                this.isEmbeddedExpression = true;
                this.addTokenToPostfixToken(T.tokenSetProperty);
                this.addTokenToPostfixToken(T.tokenExpressionBegin);
                int n5 = 0;
                while (n5++ <= n) {
                    this.addNextToken();
                }
                this.addTokenToPostfixToken(T.tokenExpressionEnd);
                n2 = 0;
                break;
            }
            case 12295: {
                if (n3 != 1678770178) break;
                n2 = 2;
                break;
            }
            case 135280133: {
                switch (n3) {
                    case 0x10000C: 
                    case 0x10000D: {
                        n3 = this.tokAt(++n2);
                    }
                }
            }
            case 12294: 
            case 1610625028: {
                switch (n3) {
                    case 1073742119: 
                    case 1276118017: {
                        n3 = this.tokAt(++n2);
                    }
                }
                if (n3 != 1087373318 || T.tokAttr(this.tokAt(n2 + 1), 0x10100000)) break;
                ++n2;
            }
        }
        for (n = 0; n < n2 && this.addNextToken(); ++n) {
        }
        while (this.moreTokens()) {
            if (this.isEmbeddedExpression) {
                while (!this.isExpressionNext()) {
                    String string;
                    T t2;
                    if (!(!this.tokPeekIs(0x40000000) || this.tokCommand == 135271427 && this.itokenInfix == 1 || (t2 = T.getTokenFromName(string = (String)this.atokenInfix[this.itokenInfix].value)) == null || (this.isMathExpressionCommand || this.lastToken.tok == 1060866) && (this.lastToken.tok != 0x100007 && this.tokAt(this.itokenInfix + 1) != 0x10100010 || this.isUserFunction(string)))) {
                        this.atokenInfix[this.itokenInfix] = t2;
                    }
                    if (this.addNextToken()) continue;
                }
                if (!this.moreTokens()) break;
            }
            if (this.lastToken.tok == 1060866) {
                if (this.clauseDefine(true, false)) continue;
                return false;
            }
            if (!this.isMathExpressionCommand) {
                t = T.o(0x100001, "implicitExpressionBegin");
                this.addTokenToPostfixToken(t);
            }
            if (!this.clauseOr(this.isCommaAsOrAllowed || !this.isMathExpressionCommand && this.tokPeekIs(0x10100010))) {
                return false;
            }
            if (!(this.isMathExpressionCommand || this.isEmbeddedExpression && this.lastToken == T.tokenCoordinateEnd)) {
                this.addTokenToPostfixToken(T.tokenExpressionEnd);
            }
            if (!this.moreTokens()) continue;
            if (this.tokCommand != 135280133 && this.tokCommand != 12291 && !this.isEmbeddedExpression) {
                return this.error(5);
            }
            if (this.tokCommand != 135280133) continue;
            t.intValue = 0;
            this.tokCommand = 0;
            this.isEmbeddedExpression = true;
            this.isMathExpressionCommand = true;
            this.isCommaAsOrAllowed = false;
        }
        this.atokenInfix = this.ltokenPostfix.toArray(new T[this.ltokenPostfix.size()]);
        return true;
    }

    protected boolean isUserFunction(String string) {
        return !this.isStateScript && (this.vwr.isFunction(string) || this.htUserFunctions.containsKey(string));
    }

    private boolean isExpressionNext() {
        return this.tokPeekIs(0x10000A) && (this.tokAt(this.itokenInfix + 1) != 4 || this.tokAt(this.itokenInfix + 2) != 0x10100022) || !this.isMathExpressionCommand && this.tokPeekIs(0x10100010);
    }

    protected static boolean tokenAttr(T t, int n) {
        return t != null && T.tokAttr(t.tok, n);
    }

    private boolean moreTokens() {
        return this.itokenInfix < this.atokenInfix.length;
    }

    protected int tokAt(int n) {
        return n < this.atokenInfix.length ? this.atokenInfix[n].tok : 0;
    }

    private int tokPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? 0 : this.atokenInfix[this.itokenInfix].tok;
    }

    private boolean tokPeekIs(int n) {
        return this.tokAt(this.itokenInfix) == n;
    }

    private int intPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? Integer.MAX_VALUE : this.atokenInfix[this.itokenInfix].intValue;
    }

    private Object valuePeek() {
        return this.moreTokens() ? this.atokenInfix[this.itokenInfix].value : "";
    }

    private T tokenNext() {
        return this.itokenInfix >= this.atokenInfix.length ? null : this.atokenInfix[this.itokenInfix++];
    }

    private boolean tokenNextTok(int n) {
        T t = this.tokenNext();
        return t != null && t.tok == n;
    }

    private boolean returnToken() {
        --this.itokenInfix;
        return false;
    }

    private T getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    private boolean getNumericalToken() {
        return this.getToken() != null && (this.theToken.tok == 2 || this.theToken.tok == 3);
    }

    private float floatValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Float)this.theValue).floatValue();
            }
        }
        return 0.0f;
    }

    private boolean addTokenToPostfix(int n, Object object) {
        return this.addTokenToPostfixToken(T.o(n, object));
    }

    private boolean addTokenToPostfixInt(int n, int n2, Object object) {
        return this.addTokenToPostfixToken(T.tv(n, n2, object));
    }

    private boolean addTokenToPostfixToken(T t) {
        if (t == null) {
            return false;
        }
        if (this.logMessages) {
            Logger.debug("addTokenToPostfix" + t);
        }
        if (t.tok == 0x10100040 && (this.lastToken.tok == 0x100007 || this.lastToken.tok == 0x100008)) {
            int n = this.ltokenPostfix.size() - 1;
            this.ltokenPostfix.remove(n);
            this.ltokenPostfix.addLast(T.tokenRightParen);
            int n2 = 0;
            int n3 = this.ltokenPostfix.size();
            block4: while (--n3 >= 0 && n2 >= 0) {
                int n4;
                int n5 = ((T)this.ltokenPostfix.get((int)n3)).tok;
                switch (n5) {
                    case 0x10100011: 
                    case 0x10100041: {
                        ++n2;
                        continue block4;
                    }
                    case 0x10100010: 
                    case 0x10100040: {
                        if (--n2 != 1 || (n4 = ((T)this.ltokenPostfix.get((int)(n3 - 1))).tok) == 0x10100011 || n4 == 0x10100041) continue block4;
                        n = n5 == 0x10100040 ? n3 - 1 : n3;
                        n2 = -10;
                        continue block4;
                    }
                }
                int n6 = n4 = n3 == 0 ? 0 : ((T)this.ltokenPostfix.get((int)(n3 - 1))).tok;
                if (n4 == 0x100007 || n4 == 0x100008) {
                    n = n3 - 1;
                    continue;
                }
                if (n3 != n - 1) continue;
                n = n3;
                n2 = -10;
            }
            if (n2 == -10) {
                this.ltokenPostfix.add(n, T.tokenLeftParen);
            }
        }
        this.ltokenPostfix.addLast(t);
        this.lastToken = t;
        return true;
    }

    private boolean addNextToken() {
        return this.addTokenToPostfixToken(this.tokenNext());
    }

    private boolean addNextTokenIf(int n) {
        return this.tokPeekIs(n) && this.addNextToken();
    }

    private boolean addSubstituteTokenIf(int n, T t) {
        if (!this.tokPeekIs(n)) {
            return false;
        }
        ++this.itokenInfix;
        return this.addTokenToPostfixToken(t);
    }

    private boolean clauseOr(boolean bl) {
        int n;
        this.haveString = false;
        if (!this.clauseAnd()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 0x100002) {
            return true;
        }
        while ((n = this.tokPeek()) == 0x10100050 || n == 0x10100051 || n == 269484114 || bl && n == 0x10100030) {
            if (n == 0x10100030 && !this.haveString) {
                this.addSubstituteTokenIf(0x10100030, T.tokenOr);
            } else {
                this.addNextToken();
            }
            if (!this.clauseAnd()) {
                return false;
            }
            if (!bl || this.lastToken.tok != 0x10000E && this.lastToken.tok != 10) continue;
            this.haveString = true;
        }
        return true;
    }

    private boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 0x100002) {
            return true;
        }
        while (this.tokPeekIs(0x10100060)) {
            this.addNextToken();
            if (this.clauseNot()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseNot() {
        if (this.tokPeekIs(0x10100070)) {
            this.addNextToken();
            return this.clauseNot();
        }
        return this.clausePrimitive();
    }

    private boolean clausePrimitive() {
        int n = this.tokPeek();
        switch (n) {
            case 1073742195: {
                ++this.itokenInfix;
                return this.clausePrimitive();
            }
            case 0: {
                return this.error(4);
            }
            case 10: 
            case 0x100003: 
            case 0x100009: 
            case 0x10000B: 
            case 0x300007: 
            case 0x300008: 
            case 0x30000A: 
            case 0x300020: 
            case 137363467: 
            case 0x101000B0: {
                return this.addNextToken();
            }
            case 4: {
                this.haveString = true;
                return this.addNextToken();
            }
            case 3: {
                return this.addTokenToPostfixInt(1048611, this.fixModelSpec(this.getToken()), this.theValue);
            }
            case 1095761925: 
            case 1095761926: {
                return this.clauseCell(n);
            }
            case 135266310: 
            case 1276252167: {
                return this.clauseConnected(n == 1276252167);
            }
            case 135267335: 
            case 135267336: {
                return this.clauseSubstructure();
            }
            case 135266325: 
            case 135402505: {
                return this.clauseWithin(n == 135266325);
            }
            case 1060866: {
                return this.clauseDefine(false, false);
            }
            case 1678770178: 
            case 1746538509: {
                this.addNextToken();
                if (this.tokPeekIs(10)) {
                    this.addNextToken();
                } else if (this.tokPeekIs(1060866)) {
                    return this.clauseDefine(false, false);
                }
                return true;
            }
            case 0x10100010: {
                this.addNextToken();
                if (!this.clauseOr(true)) {
                    return false;
                }
                if (!this.addNextTokenIf(0x10100011)) {
                    return this.errorStr(15, ")");
                }
                return this.checkForItemSelector(true);
            }
            case 0x10000A: {
                return this.checkForCoordinate(this.isMathExpressionCommand);
            }
        }
        if (this.clauseResidueSpec()) {
            return true;
        }
        if (this.isError()) {
            return false;
        }
        if (T.tokAttr(n, 0x40500000)) {
            int n2 = this.itokenInfix;
            boolean bl = this.clauseComparator(true);
            if (bl || this.itokenInfix != n2) {
                return bl;
            }
            if (n == 1238369286) {
                return this.clauseSubstructure();
            }
        }
        return this.addNextToken();
    }

    private boolean checkForCoordinate(boolean bl) {
        boolean bl2 = false;
        int n = this.ltokenPostfix.size();
        if (bl) {
            this.addTokenToPostfixToken(T.tokenExpressionBegin);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
            --n;
        } else {
            this.addNextToken();
        }
        boolean bl3 = this.tokPeekIs(4);
        if (bl3) {
            bl = false;
            this.returnToken();
            this.ltokenPostfix.remove(this.ltokenPostfix.size() - 1);
            this.addNextToken();
            int n2 = 1;
            while (n2 != 0) {
                if (this.tokPeekIs(0x10000A)) {
                    if (this.isExpressionNext()) {
                        this.addTokenToPostfixToken(T.o(0x100001, "implicitExpressionBegin"));
                        if (!this.clauseOr(true)) {
                            return false;
                        }
                        if (this.lastToken != T.tokenCoordinateEnd) {
                            this.addTokenToPostfixToken(T.tokenExpressionEnd);
                        }
                    } else {
                        ++n2;
                    }
                }
                if (this.tokPeekIs(0x10000E)) {
                    --n2;
                }
                this.addNextToken();
            }
        } else {
            if (!this.tokPeekIs(0x10000E) && !this.clauseOr(false)) {
                return false;
            }
            int n3 = 1;
            while (!this.tokPeekIs(0x10000E)) {
                boolean bl4 = this.addNextTokenIf(0x10100030);
                if (!this.clauseOr(false)) {
                    return bl4 || n3 < 3 ? false : this.errorStr(15, "}");
                }
                ++n3;
            }
            boolean bl5 = bl2 = n3 >= 2;
        }
        if (bl2 && (bl || this.isEmbeddedExpression)) {
            this.ltokenPostfix.set(n, T.tokenCoordinateBegin);
            this.addTokenToPostfixToken(T.tokenCoordinateEnd);
            this.tokenNext();
        } else if (bl) {
            this.addTokenToPostfixToken(T.tokenExpressionEnd);
            this.tokenNext();
        } else if (this.isEmbeddedExpression && !bl3) {
            this.tokenNext();
        } else {
            this.addNextToken();
        }
        return this.checkForItemSelector(!bl3);
    }

    private boolean checkForItemSelector(boolean bl) {
        int n = this.tokAt(this.itokenInfix + 1);
        if (n == 0x10100040 || bl && n == 0x10000A) {
            return true;
        }
        while (this.addNextTokenIf(0x10100040)) {
            if (!this.clauseItemSelector()) {
                return false;
            }
            if (this.addNextTokenIf(0x10100041)) continue;
            return this.errorStr(15, "]");
        }
        return true;
    }

    private boolean clauseWithin(boolean bl) {
        int n;
        int n2;
        this.addNextToken();
        if (!this.addNextTokenIf(0x10100010)) {
            return false;
        }
        if (this.getToken() == null) {
            return false;
        }
        float f = Float.MAX_VALUE;
        String string = null;
        boolean bl2 = bl;
        int n3 = this.theToken.tok;
        if (!bl) {
            n2 = -1;
            n = this.itokenInfix;
            while (n2 != 0) {
                n2 = this.tokAt(n);
                switch (n2) {
                    case 0x10100030: {
                        n2 = 0;
                        break;
                    }
                    case 0x10000A: 
                    case 0x10100010: 
                    case 0x10100011: {
                        f = 100.0f;
                        this.returnToken();
                        n2 = 0;
                        n3 = 0;
                    }
                }
                ++n;
            }
        }
        switch (n3) {
            case 0x101000A0: {
                if (this.getToken() == null) {
                    return false;
                }
                if (this.theToken.tok != 2) {
                    return this.error(12);
                }
                f = -this.theToken.intValue;
                break;
            }
            case 2: 
            case 3: {
                f = this.floatValue();
                break;
            }
            case 1060866: {
                this.addTokenToPostfixToken(this.theToken);
                if (!this.clauseDefine(true, false)) {
                    return false;
                }
                string = "";
                bl2 = false;
            }
        }
        if (bl && f == Float.MAX_VALUE) {
            block9 : switch (n3) {
                case 1060866: {
                    break;
                }
                case 135267335: 
                case 135267336: 
                case 1073741916: 
                case 1073741925: 
                case 1073742128: 
                case 1073742189: 
                case 1238369286: {
                    this.addTokenToPostfix(4, this.theValue);
                    if (!this.addNextTokenIf(0x10100030)) {
                        return false;
                    }
                    bl2 = false;
                    n2 = this.tokPeek();
                    switch (n2) {
                        case 0: {
                            return false;
                        }
                        case 4: {
                            this.addNextToken();
                            string = "";
                            break block9;
                        }
                        case 1060866: {
                            if (!this.clauseDefine(false, true)) {
                                return false;
                            }
                            string = "";
                            break block9;
                        }
                    }
                    return false;
                }
                case 0x100004: {
                    bl2 = false;
                }
                case 4: 
                case 0x100005: 
                case 0x300020: 
                case 135266319: 
                case 135267841: 
                case 137363467: 
                case 1073741864: 
                case 0x40D00004: 
                case 1087373318: 
                case 1087373320: 
                case 1087375361: 
                case 1087375362: 
                case 1087375365: 
                case 1095761936: 
                case 1095761937: 
                case 1095761941: 
                case 1095766030: 
                case 1614417948: 
                case 1641025539: 
                case 1649412120: 
                case 1679429641: {
                    string = (String)this.theValue;
                    break;
                }
                case 0x40000000: {
                    string = ((String)this.theValue).toLowerCase();
                    break;
                }
                default: {
                    return this.errorIntStr2(18, "WITHIN", ": " + this.theToken.value);
                }
            }
        }
        if (string == null) {
            this.addTokenToPostfix(3, Float.valueOf(f));
        } else if (string.length() > 0) {
            this.addTokenToPostfix(4, string);
        }
        n = 0;
        while (n == 0 && (n3 == 0 || this.addNextTokenIf(0x10100030))) {
            if (n3 == 0) {
                n3 = 135402505;
            }
            boolean bl3 = false;
            n2 = this.tokPeek();
            if (bl) {
                switch (n3) {
                    case 2: 
                    case 3: {
                        if (n2 != 0x10000D && n2 != 0x10000C) break;
                        this.addTokenToPostfixToken(this.getToken());
                        if (!this.addNextTokenIf(0x10100030)) break;
                        n2 = this.tokPeek();
                    }
                }
                if (string == null) {
                    switch (n2) {
                        case 0x100005: 
                        case 135266319: 
                        case 135267841: {
                            bl3 = true;
                            this.addNextToken();
                            break;
                        }
                        case 0x100006: {
                            this.getToken();
                            this.getToken();
                            this.addTokenToPostfix(4, "$" + this.theValue);
                            n = 1;
                            break;
                        }
                        case 1087373318: 
                        case 1614417948: 
                        case 1649412120: {
                            this.getToken();
                            this.addTokenToPostfix(4, T.nameOf(n2));
                            break;
                        }
                        case 0x10000A: {
                            this.returnToken();
                            bl3 = true;
                            this.addTokenToPostfixToken(T.getTokenFromName(f == Float.MAX_VALUE ? "plane" : "coord"));
                        }
                    }
                    if (n == 0) {
                        this.addNextTokenIf(0x10100030);
                    }
                }
            }
            n2 = this.tokPeek();
            if (n != 0) break;
            if (bl3) {
                block37: while (!this.tokPeekIs(0x10100011)) {
                    switch (this.tokPeek()) {
                        case 0: {
                            return this.error(4);
                        }
                        case 0x10100010: {
                            this.addTokenToPostfixToken(T.tokenExpressionBegin);
                            this.addNextToken();
                            if (!this.clauseOr(false)) {
                                return this.errorIntStr2(18, "WITHIN", ": ?");
                            }
                            if (!this.addNextTokenIf(0x10100011)) {
                                return this.errorStr(15, ", / )");
                            }
                            this.addTokenToPostfixToken(T.tokenExpressionEnd);
                            continue block37;
                        }
                        case 1060866: {
                            if (this.clauseDefine(false, false)) continue block37;
                            return false;
                        }
                    }
                    this.addTokenToPostfixToken(this.getToken());
                }
                continue;
            }
            if (this.clauseOr(bl2)) continue;
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.errorStr(15, ")");
        }
        return true;
    }

    private boolean clauseConnected(boolean bl) {
        block12: {
            block15: {
                String string;
                block14: {
                    block13: {
                        block11: {
                            this.addNextToken();
                            if (!this.addNextTokenIf(0x10100010)) {
                                this.addTokenToPostfixToken(T.tokenLeftParen);
                                this.addTokenToPostfixToken(T.tokenRightParen);
                                return true;
                            }
                            if (!this.addNextTokenIf(2)) break block11;
                            if (!this.addNextTokenIf(0x10100030)) break block12;
                            if (!bl) break block13;
                            this.returnToken();
                            break block12;
                        }
                        if (bl && (this.addNextTokenIf(4) || this.addNextTokenIf(0x40000000))) break block12;
                    }
                    if (this.addNextTokenIf(2) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10100030)) break block12;
                    Object object = this.getToken().value;
                    string = object instanceof String ? (String)object : " ";
                    int n = ScriptParam.getBondOrderFromString(string);
                    if (n != 131071) break block14;
                    this.returnToken();
                    break block15;
                }
                this.addTokenToPostfix(4, string);
                if (!this.addNextTokenIf(0x10100030)) break block12;
            }
            if (this.addNextTokenIf(0x10100011)) {
                return true;
            }
            if (!this.clauseOr(this.tokPeekIs(0x10100010))) {
                return false;
            }
            if (this.addNextTokenIf(0x10100011)) {
                return true;
            }
            if (!this.addNextTokenIf(0x10100030)) {
                return false;
            }
            if (!this.clauseOr(this.tokPeekIs(0x10100010))) {
                return false;
            }
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.errorStr(15, ")");
        }
        return true;
    }

    private boolean clauseSubstructure() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x10100010)) {
            return false;
        }
        if (this.tokPeekIs(1060866)) {
            if (!this.clauseDefine(false, true)) {
                return false;
            }
        } else if (!this.addNextTokenIf(4)) {
            return this.errorStr(15, "\"...\"");
        }
        if (this.addNextTokenIf(0x10100030) && !this.clauseOr(this.tokPeekIs(0x10100010))) {
            return false;
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.errorStr(15, ")");
        }
        return true;
    }

    private boolean clauseItemSelector() {
        int n;
        int n2 = 0;
        while ((n = this.tokPeek()) != 0 && n != 0x10100041) {
            this.addNextToken();
            if (n == 0x10100040) {
                ++n2;
            }
            if (this.tokPeek() != 0x10100041 || n2-- <= 0) continue;
            this.addNextToken();
        }
        return true;
    }

    private boolean clauseComparator(boolean bl) {
        T t = this.tokenNext();
        T t2 = this.tokenNext();
        if (!ScriptTokenParser.tokenAttr(t2, 0x10100100)) {
            if (!bl) {
                return this.errorStr(15, "== != < > <= >=");
            }
            if (t2 != null) {
                this.returnToken();
            }
            this.returnToken();
            return false;
        }
        if (ScriptTokenParser.tokenAttr(t, 0x40D00000) && t2.tok != 269484436 && t2.tok != 269484438 && t2.tok != 269484437) {
            return this.errorStr(15, "== !=");
        }
        if (this.tokPeek() == 0x10100040) {
            this.getToken();
            this.addTokenToPostfixToken(T.tokenLeftParen);
            while (true) {
                if (!this.addCompare(t, t2)) {
                    return false;
                }
                if (this.tokPeek() == 0x10100030) {
                    this.getToken();
                } else if (this.tokPeek() == 0x10100041) break;
                this.addTokenToPostfixToken(t2.tok == 269484437 ? T.tokenAnd : T.tokenOr);
            }
            this.getToken();
            this.addTokenToPostfixToken(T.tokenRightParen);
            return true;
        }
        return this.addCompare(t, t2);
    }

    private boolean addCompare(T t, T t2) {
        boolean bl;
        if (this.getToken() == null) {
            return this.errorStr(17, "" + this.valuePeek());
        }
        boolean bl2 = bl = this.theToken.tok == 0x101000A0;
        if (bl && this.getToken() == null) {
            return this.error(12);
        }
        switch (this.theToken.tok) {
            case 2: 
            case 3: 
            case 4: 
            case 0x10000A: 
            case 1060866: 
            case 0x40000000: {
                break;
            }
            default: {
                if (T.tokAttr(this.theToken.tok, 0x40000000)) break;
                return this.error(13);
            }
        }
        this.addTokenToPostfixInt(t2.tok, t.tok, t2.value + (bl ? " -" : ""));
        if (t.tok == 1716520985) {
            this.addTokenToPostfixToken(t);
        }
        if (this.theToken.tok == 0x10000A) {
            this.returnToken();
            return this.clausePrimitive();
        }
        this.addTokenToPostfixToken(this.theToken);
        if (this.theToken.tok == 1060866) {
            return this.clauseDefine(true, false);
        }
        return true;
    }

    private boolean clauseCell(int n) {
        P3 p3 = new P3();
        this.tokenNext();
        if (!this.tokenNextTok(269484436)) {
            return this.errorStr(15, "=");
        }
        if (this.getToken() == null) {
            return this.error(3);
        }
        if (this.theToken.tok == 2) {
            SimpleUnitCell.ijkToPoint3f(this.theToken.intValue, p3, 1);
            return this.addTokenToPostfix(n, p3);
        }
        if (this.theToken.tok != 0x10000A || !this.getNumericalToken()) {
            return this.error(3);
        }
        p3.x = this.floatValue();
        if (this.tokPeekIs(0x10100030)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken()) {
            return this.error(3);
        }
        p3.y = this.floatValue();
        if (this.tokPeekIs(0x10100030)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken() || !this.tokenNextTok(0x10000E)) {
            return this.error(3);
        }
        p3.z = this.floatValue();
        return this.addTokenToPostfix(n, p3);
    }

    private boolean clauseDefine(boolean bl, boolean bl2) {
        if (!bl) {
            T t = this.tokenNext();
            if (bl2) {
                t = T.tokenDefineString;
            }
            this.addTokenToPostfixToken(t);
        }
        if (this.tokPeekIs(0)) {
            return this.error(4);
        }
        if (!this.addSubstituteTokenIf(0x10000A, T.tokenExpressionBegin)) {
            if (this.tokPeek() == 1060866) {
                this.addNextToken();
            }
            return this.addNextToken() && this.checkForItemSelector(true);
        }
        while (this.moreTokens() && !this.tokPeekIs(0x10000E)) {
            if (this.tokPeekIs(0x10000A)) {
                if (this.checkForCoordinate(true)) continue;
                return false;
            }
            this.addNextToken();
        }
        return this.addSubstituteTokenIf(0x10000E, T.tokenExpressionEnd) && this.checkForItemSelector(true);
    }

    private boolean generateResidueSpecCode(T t) {
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfixToken(T.tokenAndSpec);
        }
        this.addTokenToPostfixToken(t);
        this.residueSpecCodeGenerated = true;
        return true;
    }

    private boolean clauseResidueSpec() {
        int n = this.tokPeek();
        this.residueSpecCodeGenerated = false;
        boolean bl = false;
        switch (n) {
            case 0: 
            case 0x300004: 
            case 3145750: {
                return false;
            }
            case 2: 
            case 5: 
            case 0x10100022: 
            case 269484210: {
                break;
            }
            case 0x10100040: 
            case 0x101000B1: 
            case 0x40000000: {
                bl = true;
                break;
            }
            default: {
                if (T.tokAttr(n, 0x10100100)) {
                    return false;
                }
                String string = "" + this.valuePeek();
                boolean bl2 = bl = string.length() == 2 || string.length() == 3;
                if (bl) break;
                return false;
            }
        }
        boolean bl3 = false;
        if (bl) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 2 || n == 0x101000B1 || n == 5) {
            if (!this.clauseSequenceSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 0x10100022) {
            if (!this.clauseChainSpec(n)) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 0x100007) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 269484210) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 0x101000B0) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (!bl3) {
            return this.error(14);
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfixToken(T.tokenAll);
        }
        return true;
    }

    private boolean clauseResNameSpec() {
        this.getToken();
        int n = this.tokPeek();
        switch (this.theToken.tok) {
            case 0x101000B1: {
                return true;
            }
            case 0x10100040: {
                int n2;
                String string = "";
                while (this.getToken() != null && this.theToken.tok != 0x10100041) {
                    string = string + this.theValue;
                }
                if (this.theToken == null) {
                    return false;
                }
                if (string == "") {
                    return true;
                }
                return string.length() > 0 && (n2 = string.indexOf("*")) >= 0 && n2 != string.length() - 1 ? this.error(14) : this.generateResidueSpecCode(T.o(1048612, string.toUpperCase()));
            }
        }
        if (T.tokAttr(n, 0x10100100)) {
            this.returnToken();
            return false;
        }
        String string = (String)this.theValue;
        if (n == 0x101000B1) {
            string = this.theValue + "*";
            this.getToken();
        }
        return this.generateResidueSpecCode(T.o(0x40000000, string));
    }

    private boolean clauseSequenceSpec() {
        if (this.tokPeek() == 0x101000B1) {
            return this.getToken() != null;
        }
        T t = this.getSequenceCode(false);
        if (t == null) {
            return false;
        }
        int n = this.tokPeek();
        if (n == 0x101000A0 || n == 2 && this.intPeek() < 0) {
            if (n == 0x101000A0) {
                this.tokenNext();
            } else {
                int n2;
                this.tokenNext().intValue = n2 = -this.intPeek();
                this.returnToken();
            }
            t.tok = 1048615;
            this.generateResidueSpecCode(t);
            return this.addTokenToPostfixToken(this.getSequenceCode(true));
        }
        return this.generateResidueSpecCode(t);
    }

    private T getSequenceCode(boolean bl) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        switch (this.tokPeek()) {
            case 5: {
                n = this.tokenNext().intValue;
                break;
            }
            case 2: {
                n2 = this.tokenNext().intValue;
                break;
            }
            default: {
                if (bl) break;
                return null;
            }
        }
        return T.tv(1048614, n2, n);
    }

    private boolean clauseChainSpec(int n) {
        int n2;
        String string;
        this.tokenNext();
        n = this.tokPeek();
        if (this.isTerminator(n)) {
            string = " ";
        } else {
            switch (n) {
                case 0x101000B1: {
                    return this.getToken() != null;
                }
                case 2: {
                    this.getToken();
                    n2 = this.theToken.intValue;
                    if (n2 < 0 || n2 > 9999) {
                        return this.error(8);
                    }
                    string = "" + n2;
                    break;
                }
                case 4: {
                    this.vwr.getChainID("a", true);
                }
                default: {
                    string = "" + this.getToken().value;
                }
            }
            if (string.length() == 0) {
                string = " ";
            } else if (string.equals("?")) {
                return true;
            }
        }
        n2 = this.vwr.getChainID(string, false);
        return this.generateResidueSpecCode(T.tv(0x100021, n2, "spec_chain"));
    }

    private boolean clauseAlternateSpec() {
        this.tokenNext();
        if (this.isTerminator(this.tokPeek())) {
            return this.generateResidueSpecCode(T.o(0x10001F, null));
        }
        switch (this.getToken().tok) {
            case 2: 
            case 4: 
            case 0x101000B1: 
            case 0x40000000: 
            case 1112541205: 
            case 1112541206: 
            case 1112541207: 
            case 0x44100011: {
                break;
            }
            default: {
                return this.error(10);
            }
        }
        return this.generateResidueSpecCode(T.o(0x10001F, this.theToken.value));
    }

    private boolean isTerminator(int n) {
        switch (n) {
            case 0: 
            case 0x10000E: 
            case 0x10100011: 
            case 0x10100030: 
            case 0x10100050: 
            case 0x10100060: 
            case 0x10100070: 
            case 0x101000B0: {
                return true;
            }
        }
        return false;
    }

    private boolean clauseModelSpec() {
        this.getToken();
        switch (this.tokPeek()) {
            case 0x101000B1: {
                this.getToken();
                return true;
            }
            case 2: {
                return this.generateResidueSpecCode(T.o(0x100022, this.getToken().intValue));
            }
            case 3: {
                return this.generateResidueSpecCode(T.tv(0x100022, this.fixModelSpec(this.getToken()), this.theValue));
            }
        }
        return this.error(10);
    }

    private int fixModelSpec(T t) {
        int n = t.intValue;
        if (n == Integer.MAX_VALUE) {
            float f = ((Float)this.theValue).floatValue();
            if (f == (float)((int)f)) {
                n = (int)f * 1000000;
            }
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
        }
        return n;
    }

    private boolean clauseAtomSpec() {
        if (!this.tokenNextTok(0x100007)) {
            return this.error(7);
        }
        if (this.getToken() == null) {
            return true;
        }
        String string = "";
        if (this.theToken.tok == 2) {
            string = string + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.error(7);
            }
        }
        if (this.theToken.tok == 0x101000B1) {
            return true;
        }
        string = string + "" + this.theToken.value;
        if (this.tokPeekIs(0x101000B1)) {
            this.tokenNext();
            string = string + "'";
        }
        return this.generateResidueSpecCode(T.tv(0x100020, this.vwr.getJBR().lookupSpecialAtomID(string.toUpperCase()), string));
    }

    static String errorString(int n, String string, String string2, boolean bl) {
        String string3;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string3 = "Unknown compiler error message number: " + n;
                break;
            }
            case 0: {
                string3 = GT._("bad argument count");
                break;
            }
            case 1: {
                string3 = GT._("invalid context for {0}");
                break;
            }
            case 2: {
                string3 = GT._("command expected");
                break;
            }
            case 3: {
                string3 = GT._("{ number number number } expected");
                break;
            }
            case 4: {
                string3 = GT._("unexpected end of script command");
                break;
            }
            case 5: {
                string3 = GT._("end of expression expected");
                break;
            }
            case 6: {
                string3 = GT._("identifier or residue specification expected");
                break;
            }
            case 7: {
                string3 = GT._("invalid atom specification");
                break;
            }
            case 8: {
                string3 = GT._("invalid chain specification");
                break;
            }
            case 9: {
                string3 = GT._("invalid expression token: {0}");
                break;
            }
            case 10: {
                string3 = GT._("invalid model specification");
                break;
            }
            case 11: {
                string3 = GT._("missing END for {0}");
                break;
            }
            case 12: {
                string3 = GT._("number expected");
                break;
            }
            case 13: {
                string3 = GT._("number or variable name expected");
                break;
            }
            case 14: {
                string3 = GT._("residue specification (ALA, AL?, A*) expected");
                break;
            }
            case 15: {
                string3 = GT._("{0} expected");
                break;
            }
            case 16: {
                string3 = GT._("{0} unexpected");
                break;
            }
            case 17: {
                string3 = GT._("unrecognized expression token: {0}");
                break;
            }
            case 18: {
                string3 = GT._("unrecognized {0} parameter");
                break;
            }
            case 19: {
                string3 = GT._("unrecognized token: {0}");
            }
        }
        if (string3.indexOf("{0}") < 0) {
            if (string != null) {
                string3 = string3 + ": " + string;
            }
        } else if ((string3 = PT.rep(string3, "{0}", string)).indexOf("{1}") >= 0) {
            string3 = PT.rep(string3, "{1}", string2);
        } else if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        if (!bl) {
            GT.setDoTranslate(bl2);
        }
        return string3;
    }

    protected boolean commandExpected() {
        this.ichToken = this.ichCurrentCommand;
        return this.error(2);
    }

    protected boolean error(int n) {
        return this.errorIntStr2(n, null, null);
    }

    protected boolean errorStr(int n, String string) {
        return this.errorIntStr2(n, string, null);
    }

    protected boolean errorIntStr2(int n, String string, String string2) {
        String string3 = ScriptTokenParser.errorString(n, string, string2, true);
        String string4 = GT.getDoTranslate() ? ScriptTokenParser.errorString(n, string, string2, false) : null;
        return this.errorStr2(string3, string4);
    }

    private boolean isError() {
        return this.errorMessage != null;
    }

    protected boolean errorStr2(String string, String string2) {
        this.errorMessage = string;
        this.errorMessageUntranslated = string2;
        return false;
    }
}

