/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.i18n.GT;
import org.jmol.io.JmolBinary;
import org.jmol.java.BS;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.Group;
import org.jmol.script.ContextToken;
import org.jmol.script.SV;
import org.jmol.script.ScriptContext;
import org.jmol.script.ScriptError;
import org.jmol.script.ScriptFlowContext;
import org.jmol.script.ScriptFunction;
import org.jmol.script.ScriptManager;
import org.jmol.script.ScriptParam;
import org.jmol.script.ScriptTokenParser;
import org.jmol.script.T;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class ScriptCompiler
extends ScriptTokenParser {
    private String filename;
    private boolean isSilent;
    private Map<String, SV> contextVariables;
    private T[][] aatokenCompiled;
    private short[] lineNumbers;
    private int[][] lineIndices;
    private int lnLength = 8;
    private boolean preDefining;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private boolean haveComments;
    String scriptExtensions;
    private ScriptFunction thisFunction;
    private ScriptFlowContext flowContext;
    private Lst<T> ltoken;
    private Lst<T[]> lltoken;
    private Lst<T> vBraces;
    private int ichBrace;
    private int cchToken;
    private int cchScript;
    private int nSemiSkip;
    private int parenCount;
    private int braceCount;
    private int setBraceCount;
    private int bracketCount;
    private int ptSemi;
    private int forPoint3;
    private int setEqualPt;
    private int iBrace;
    private boolean iHaveQuotedString;
    private boolean isEndOfCommand;
    private boolean needRightParen;
    private boolean endOfLine;
    private String comment;
    private static final int OK = 0;
    private static final int OK2 = 1;
    private static final int CONTINUE = 2;
    private static final int EOL = 3;
    private static final int ERROR = 4;
    private int tokLastMath;
    private boolean checkImpliedScriptCmd;
    private Lst<ScriptFunction> vFunctionStack;
    private boolean allowMissingEnd;
    private boolean isShowCommand;
    private boolean isComment;
    private boolean isUserToken;
    private boolean implicitString;
    private int tokInitialPlusPlus;
    private int afterWhite;
    private boolean isDotDot;
    private String ident;
    private String identLC;
    Lst<T> vPush = new Lst();
    int pushCount;
    private char chFirst = '\u0000';
    private int afterMath;

    public ScriptCompiler(Viewer viewer) {
        this.vwr = viewer;
    }

    synchronized ScriptContext compile(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.isCheckOnly = bl4;
        this.filename = string;
        this.isSilent = bl2;
        this.script = string2;
        this.logMessages = !bl2 && !bl && bl3;
        this.preDefining = string == "#predefine";
        boolean bl5 = true;
        boolean bl6 = this.compile0(bl5);
        this.atokenInfix = null;
        if (!bl6) {
            this.handleError();
        }
        ScriptContext scriptContext = new ScriptContext();
        scriptContext.isComplete = bl6 = this.iBrace == 0 && this.parenCount == 0 && this.braceCount == 0 && this.bracketCount == 0;
        scriptContext.script = string2;
        scriptContext.scriptExtensions = this.scriptExtensions;
        scriptContext.errorType = this.errorType;
        if (this.errorType != null) {
            scriptContext.iCommandError = this.iCommand;
            this.setAaTokenCompiled();
        }
        scriptContext.saveTokens(this.aatokenCompiled);
        scriptContext.errorMessage = this.errorMessage;
        String string3 = scriptContext.errorMessageUntranslated = this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
        if (this.allowMissingEnd && scriptContext.errorMessage != null && scriptContext.errorMessageUntranslated.indexOf("missing END") >= 0) {
            scriptContext.errorMessage = scriptContext.errorMessageUntranslated;
        }
        scriptContext.lineIndices = this.lineIndices;
        scriptContext.lineNumbers = this.lineNumbers;
        scriptContext.vars = this.contextVariables;
        return scriptContext;
    }

    private void newContextVariable(String string) {
        this.theToken = T.o(0x40000000, string);
        if (this.pushCount > 0) {
            ContextToken contextToken = (ContextToken)this.vPush.get(this.pushCount - 1);
            contextToken.addName(string);
            if (contextToken.tok != 364558) {
                return;
            }
        }
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable<String, SV>();
            }
            ScriptCompiler.addContextVariable(this.contextVariables, string);
        } else {
            this.thisFunction.addVariable(string, false);
        }
    }

    static void addContextVariable(Map<String, SV> map, String string) {
        map.put(string, SV.newS("").setName(string));
    }

    private boolean isContextVariable(String string) {
        int n = this.vPush.size();
        while (--n >= 0) {
            ContextToken contextToken = (ContextToken)this.vPush.get(n);
            if (contextToken.contextVariables == null || !contextToken.contextVariables.containsKey(string)) continue;
            return true;
        }
        return this.thisFunction != null ? this.thisFunction.isVariable(string) : this.contextVariables != null && this.contextVariables.containsKey(string);
    }

    private String cleanScriptComments(String string) {
        int n;
        if (string.indexOf(8220) >= 0) {
            string = string.replace('\u201c', '\"');
        }
        if (string.indexOf(8221) >= 0) {
            string = string.replace('\u201d', '\"');
        }
        if (string.indexOf(65279) >= 0) {
            string = string.replace('\ufeff', ' ');
        }
        if ((n = string.indexOf("\u0001##")) >= 0) {
            this.scriptExtensions = string.substring(n + 1);
            string = string.substring(0, n);
            this.allowMissingEnd = this.scriptExtensions.indexOf("##noendcheck") >= 0;
        }
        this.haveComments = string.indexOf("#") >= 0;
        return JmolBinary.getEmbeddedScript(string);
    }

    private void addTokenToPrefix(T t) {
        if (this.logMessages) {
            Logger.info("addTokenToPrefix" + t);
        }
        this.ltoken.addLast(t);
        if (t.tok != 0) {
            this.lastToken = t;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean compile0(boolean var1_1) {
        this.vFunctionStack = new Lst<V>();
        this.htUserFunctions = new Hashtable<K, V>();
        this.script = this.cleanScriptComments(this.script);
        this.ichToken = this.script.indexOf("# Jmol state version ");
        v0 = this.isStateScript = this.ichToken >= 0;
        if (this.isStateScript) {
            this.ptSemi = this.script.indexOf(";", this.ichToken);
            if (this.ptSemi >= this.ichToken) {
                ScriptManager.setStateScriptVersion(this.vwr, this.script.substring(this.ichToken + "# Jmol state version ".length(), this.ptSemi).trim());
            }
        }
        this.cchScript = this.script.length();
        this.contextVariables = null;
        this.lineNumbers = null;
        this.lineIndices = null;
        this.aatokenCompiled = null;
        this.thisFunction = null;
        this.flowContext = null;
        this.errorType = null;
        this.errorMessage = null;
        this.errorMessageUntranslated = null;
        this.errorLine = null;
        this.nSemiSkip = 0;
        this.ichToken = 0;
        this.ichCurrentCommand = 0;
        this.ichComment = 0;
        this.ichBrace = 0;
        this.lineCurrent = 1;
        this.iCommand = 0;
        this.tokLastMath = 0;
        this.lastToken = T.tokenOff;
        this.vBraces = new Lst<V>();
        this.vPush = new Lst<V>();
        this.pushCount = 0;
        this.iBrace = 0;
        this.braceCount = 0;
        this.parenCount = 0;
        this.isDotDot = false;
        this.ptSemi = -10;
        this.cchToken = 0;
        this.lnLength = 8;
        this.lineNumbers = new short[this.lnLength];
        this.lineIndices = new int[this.lnLength][2];
        this.isSetBrace = false;
        this.isNewSet = false;
        this.ptNewSetModifier = 1;
        this.isShowScriptOutput = false;
        this.iHaveQuotedString = false;
        this.checkImpliedScriptCmd = false;
        this.lltoken = new Lst<V>();
        this.ltoken = new Lst<V>();
        this.tokCommand = 0;
        this.lastFlowCommand = null;
        this.tokenAndEquals = null;
        this.tokInitialPlusPlus = 0;
        this.setBraceCount = 0;
        this.bracketCount = 0;
        this.forPoint3 = -1;
        this.setEqualPt = 0x7FFFFFFF;
        this.endOfLine = false;
        this.comment = null;
        this.isEndOfCommand = false;
        this.needRightParen = false;
        this.theTok = 0;
        var2_2 = 1;
        while (true) {
            block32: {
                block34: {
                    block33: {
                        if ((this.nTokens = this.ltoken.size()) == 0) {
                            if (this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                this.thisFunction.chpt0 = this.ichToken;
                            }
                            this.ichCurrentCommand = this.ichToken;
                            var2_2 = this.lineCurrent;
                        }
                        if (this.lookingAtLeadingWhitespace()) break block32;
                        this.endOfLine = false;
                        if (this.isEndOfCommand) break block33;
                        this.endOfLine = this.lookingAtEndOfLine();
                        switch (this.endOfLine != false ? 0 : this.lookingAtComment()) {
                            case 2: {
                                break block32;
                            }
                            case 3: {
                                this.isEndOfCommand = true;
                                break block32;
                            }
                            case 1: {
                                this.isEndOfCommand = true;
                                this.comment = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                            }
                            default: {
                                v1 = this.isEndOfCommand = this.isEndOfCommand != false || this.endOfLine != false || this.lookingAtTerminator() != false;
                            }
                        }
                    }
                    if (!this.isEndOfCommand) break block34;
                    this.isEndOfCommand = false;
                    switch (this.processTokenList(var2_2, var1_1)) {
                        case 2: {
                            break block32;
                        }
                        case 4: {
                            return false;
                        }
                        default: {
                            this.checkImpliedScriptCmd = false;
                            if (this.ichToken >= this.cchScript) {
                                this.setAaTokenCompiled();
                                return this.flowContext == null || this.errorStr(11, T.nameOf(this.flowContext.token.tok)) != false;
                            }
                            break block32;
                        }
                    }
                }
                if (this.nTokens <= 0 || this.isDotDot) ** GOTO lbl-1000
                block9 : switch (this.checkSpecialParameterSyntax()) {
                    case 2: {
                        break;
                    }
                    case 4: {
                        return false;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (this.lookingAtLookupToken(this.ichToken)) {
                            switch (this.parseKnownToken()) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            switch (this.parseCommandParameter()) {
                                case 2: {
                                    break block9;
                                }
                                case 4: {
                                    return false;
                                }
                            }
                            this.addTokenToPrefix(this.theToken);
                            break;
                        }
                        if (this.nTokens == 0 || (this.isNewSet || this.isSetBrace) && this.nTokens == this.ptNewSetModifier) {
                            if (this.nTokens == 0) {
                                if (this.lookingAtString(true)) {
                                    this.addTokenToPrefix(this.setCommand(T.tokenScript));
                                    this.cchToken = 0;
                                    break;
                                }
                                if (this.lookingAtImpliedString(true, true, true)) {
                                    this.ichEnd = this.ichToken + this.cchToken;
                                }
                            }
                            return this.commandExpected();
                        }
                        return this.errorStr(19, this.script.substring(this.ichToken, this.ichToken + 1));
                    }
                }
            }
            this.ichToken += this.cchToken;
        }
    }

    private void setAaTokenCompiled() {
        this.aatokenCompiled = (T[][])this.lltoken.toArray((T[])new T[this.lltoken.size()][]);
    }

    private boolean lookingAtLeadingWhitespace() {
        int n = this.ichToken;
        while (ScriptCompiler.isSpaceOrTab(this.charAt(n))) {
            ++n;
        }
        if (this.isLineContinuation(n, true)) {
            n += 1 + this.nCharNewLine(n + 1);
        }
        this.cchToken = n - this.ichToken;
        if (this.cchToken == 0) {
            return false;
        }
        this.afterWhite = n;
        return true;
    }

    private boolean isLineContinuation(int n, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = n + 2 < this.cchScript && this.script.charAt(n) == '\\' && this.nCharNewLine(n + 1) > 0 || bl && this.lookingAtMathContinuation(n);
        if (bl2) {
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return bl2;
    }

    private boolean lookingAtMathContinuation(int n) {
        int n2 = this.nCharNewLine(n);
        if (n2 == 0 || this.lastToken.tok == 0x10000A) {
            return false;
        }
        if (this.parenCount > 0 || this.bracketCount > 0) {
            return true;
        }
        if (!(this.tokCommand == 1085443 && this.isNewSet || this.tokCommand == 36865 || this.tokCommand == 36869)) {
            return false;
        }
        if (this.lastToken.tok == this.tokLastMath) {
            return true;
        }
        n += n2;
        while (ScriptCompiler.isSpaceOrTab(this.charAt(n))) {
            ++n;
        }
        return this.lookingAtLookupToken(n) && this.tokLastMath == 1;
    }

    private boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            this.ichEnd = this.cchScript;
            return true;
        }
        this.ichEnd = this.ichToken;
        this.cchToken = this.nCharNewLine(this.ichEnd);
        return this.cchToken > 0;
    }

    private int nCharNewLine(int n) {
        char c = this.charAt(n);
        return c != '\r' ? (c == '\n' ? 1 : 0) : (this.charAt(++n) == '\n' ? 2 : 1);
    }

    private boolean lookingAtTerminator() {
        boolean bl;
        boolean bl2 = bl = this.script.charAt(this.ichToken) == ';';
        if (bl && this.nTokens > 0) {
            this.ptSemi = this.nTokens;
        }
        if (!bl || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private int lookingAtComment() {
        boolean bl;
        char c = this.script.charAt(this.ichToken);
        int n = this.ichToken;
        int n2 = -1;
        if (this.ichToken == this.ichCurrentCommand && c == '$' && (this.isShowScriptOutput || this.ichToken == 0)) {
            this.isShowScriptOutput = true;
            this.isShowCommand = true;
            if (this.charAt(++n) == '[') {
                while (c != ']' && !this.eol(c = this.charAt(n))) {
                    ++n;
                }
            }
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (this.isShowScriptOutput && !this.isShowCommand) {
            n2 = n;
        }
        if (c == '/' && n + 1 < this.cchScript) {
            switch (this.script.charAt(++n)) {
                case '/': {
                    n2 = this.ichToken;
                    this.ichEnd = n - 1;
                    break;
                }
                case '*': {
                    this.ichEnd = n - 1;
                    c = this.charAt(++n);
                    String string = c == '*' ? "**/" : "*/";
                    n = this.script.indexOf(string, this.ichToken + 2);
                    if (n < 0) {
                        this.ichToken = this.cchScript;
                        return 3;
                    }
                    this.incrementLineCount(this.script.substring(this.ichToken, n));
                    this.cchToken = n + (c == '*' ? 3 : 2) - this.ichToken;
                    return 2;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean bl2 = bl = n2 < 0;
        if (bl && !this.haveComments) {
            return 0;
        }
        if (this.ichComment > n) {
            n = this.ichComment;
        }
        while (n < this.cchScript) {
            c = this.script.charAt(n);
            if (this.eol(c)) {
                this.ichEnd = n;
                if (n > 0 && this.isLineContinuation(n - 1, false)) {
                    n += this.nCharNewLine(n);
                } else if (bl || c != ';') break;
            } else if (n2 < 0 && c == '#') {
                n2 = n;
            }
            ++n;
        }
        if (n2 < 0) {
            return 0;
        }
        this.ichComment = n2;
        if (bl && this.nTokens == 0 && this.cchScript - n2 >= 3 && this.script.charAt(n2 + 1) == 'j' && this.script.charAt(n2 + 2) == 'c') {
            this.cchToken = n - this.ichToken;
            return 2;
        }
        if (n2 != this.ichToken) {
            return 0;
        }
        if (bl && this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && ScriptCompiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return 2;
        }
        if (n == this.ichToken) {
            return 0;
        }
        this.cchToken = n - this.ichToken;
        return this.nTokens == 0 ? 1 : 2;
    }

    private char charAt(int n) {
        return n < this.cchScript ? this.script.charAt(n) : (char)'\u0000';
    }

    private int processTokenList(short s, boolean bl) {
        if (this.nTokens > 0 || this.comment != null) {
            T t;
            if (this.nTokens == 0) {
                this.ichCurrentCommand = this.ichToken;
                if (this.comment != null) {
                    this.isComment = true;
                    this.addTokenToPrefix(T.o(0, this.comment));
                }
            } else if (this.setBraceCount > 0 && this.endOfLine && this.ichToken < this.cchScript) {
                return 2;
            }
            if (this.wasImpliedScript()) {
                return 2;
            }
            if (this.isNewSet && this.nTokens > 2 && this.tokAt(2) == 0x100007 && (this.tokAt(3) == 1276117011 || this.tokAt(3) == 1141899269 || this.tokAt(3) == 1276384259 || this.tokAt(3) == 1276383249)) {
                this.ltoken.set(0, T.tokenSet);
                this.ltoken.add(1, this.tokAt(3) == 1276383249 ? T.tokenAll : (T)this.ltoken.get(1));
            } else if (this.tokInitialPlusPlus != 0) {
                if (!this.isNewSet) {
                    this.checkNewSetCommand();
                }
                this.tokenizePlusPlus(this.tokInitialPlusPlus, true);
                this.ichCurrentCommand -= 2;
            }
            this.iCommand = this.lltoken.size();
            if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                this.thisFunction.cmdpt0 = this.iCommand;
            }
            if (this.nTokens == 1 && this.braceCount == 1) {
                if (this.lastFlowCommand == null) {
                    this.braceCount = 0;
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.ltoken.remove(0);
                    ++this.iBrace;
                    t = ContextToken.newContext(true);
                    this.addTokenToPrefix(this.setCommand(t));
                    ++this.pushCount;
                    this.vPush.addLast(t);
                    this.vBraces.addLast(this.tokenCommand);
                } else {
                    this.setBraceCount = 0;
                    this.parenCount = 0;
                    this.setCommand(this.lastFlowCommand);
                    if (this.lastFlowCommand.tok != 102439 && this.tokAt(0) == 0x10000A) {
                        this.ltoken.remove(0);
                    }
                    this.lastFlowCommand = null;
                }
            }
            if (this.bracketCount > 0 || this.setBraceCount > 0 || this.parenCount > 0 || this.braceCount == 1 && !this.checkFlowStartBrace(true)) {
                this.error(this.nTokens == 1 ? 2 : 4);
                return 4;
            }
            if (this.needRightParen) {
                this.addTokenToPrefix(T.tokenRightParen);
                this.needRightParen = false;
            }
            if (this.tokAt(1) == 1074790550 && T.tokAttr(this.tokCommand, 135168)) {
                switch (this.tokAt(2)) {
                    case 0: 
                    case 4: 
                    case 1060866: {
                        break;
                    }
                    default: {
                        t = (T)this.ltoken.remove(2);
                        this.ltoken.add(2, T.o(4, t.tok == 2 ? "" + t.intValue : t.value.toString()));
                    }
                }
            }
            if (this.ltoken.size() > 0) {
                if (bl && !this.compileCommand()) {
                    return 4;
                }
                if (this.logMessages) {
                    Logger.debug("-------------------------------------");
                }
                boolean bl2 = true;
                switch (this.tokCommand) {
                    case 102436: 
                    case 364558: 
                    case 0x119009: 
                    case 135368713: {
                        boolean bl3 = bl2 = this.atokenInfix.length > 0 && this.atokenInfix[0].intValue != Integer.MAX_VALUE;
                    }
                }
                if (bl2) {
                    if (this.iCommand == this.lnLength) {
                        this.lineNumbers = AU.doubleLengthShort(this.lineNumbers);
                        int[][] nArray = new int[this.lnLength * 2][2];
                        System.arraycopy(this.lineIndices, 0, nArray, 0, this.lnLength);
                        this.lineIndices = nArray;
                        this.lnLength *= 2;
                    }
                    this.lineNumbers[this.iCommand] = s;
                    this.lineIndices[this.iCommand][0] = this.ichCurrentCommand;
                    this.lineIndices[this.iCommand][1] = Math.max(this.ichCurrentCommand, Math.min(this.cchScript, this.ichEnd == this.ichCurrentCommand ? this.ichToken : this.ichEnd));
                    this.lltoken.addLast(this.atokenInfix);
                    this.iCommand = this.lltoken.size();
                }
                if (this.tokCommand == 1085443) {
                    this.lastFlowCommand = null;
                }
            }
            this.setCommand(null);
            this.comment = null;
            this.needRightParen = false;
            this.isSetBrace = false;
            this.isNewSet = false;
            this.iHaveQuotedString = false;
            this.ptNewSetModifier = 1;
            this.ltoken.clear();
            this.nSemiSkip = 0;
            this.nTokens = 0;
            this.tokInitialPlusPlus = 0;
            this.tokenAndEquals = null;
            this.ptSemi = -10;
            this.forPoint3 = -1;
            this.setEqualPt = Integer.MAX_VALUE;
        }
        if (this.endOfLine) {
            if (this.flowContext != null && this.flowContext.checkForceEndIf()) {
                if (!this.isComment) {
                    this.forceFlowEnd(this.flowContext.token);
                }
                this.isEndOfCommand = true;
                this.cchToken = 0;
                this.ichCurrentCommand = this.ichToken;
                this.lineCurrent = (short)(this.lineCurrent - 1);
                return 2;
            }
            this.isComment = false;
            this.isShowCommand = false;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        if (this.ichToken >= this.cchScript) {
            this.setCommand(T.tokenAll);
            this.theTok = 0;
            switch (this.checkFlowEndBrace()) {
                case 4: {
                    return 4;
                }
                case 2: {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
            }
            this.ichToken = this.cchScript;
            return 0;
        }
        return 0;
    }

    private boolean wasImpliedScript() {
        if (this.nTokens >= 2 && (this.tokCommand == 135271429 || this.tokCommand == 4124) && this.checkImpliedScriptCmd) {
            String string;
            String string2 = string = this.nTokens == 2 ? this.lastToken.value.toString().toUpperCase() : null;
            if (this.nTokens > 2 ? this.tokAt(2) != 0x10100010 || !((T)this.ltoken.get((int)1)).value.toString().endsWith(".spt") : string.endsWith(".SORT") || string.endsWith(".REVERSE") || string.endsWith(".POP") || string.indexOf(".SORT(") >= 0 || string.indexOf(".REVERSE(") >= 0 || string.indexOf(".POP(") >= 0 || string.indexOf(".PUSH(") >= 0 || string.endsWith("++") || string.endsWith("--") || string.endsWith("=") || this.tokInitialPlusPlus != 0) {
                this.ichToken = this.ichCurrentCommand;
                this.nTokens = 0;
                this.ltoken.clear();
                this.cchToken = 0;
                this.tokCommand = 0;
                return true;
            }
        }
        return false;
    }

    private boolean compileCommand() {
        int n;
        switch (this.ltoken.size()) {
            case 0: {
                this.atokenInfix = new T[0];
                return true;
            }
            case 4: {
                if (!this.isNewSet || !this.tokenAt((int)2).value.equals(".") || !this.tokenAt((int)3).value.equals("spt")) break;
                String string = this.tokenAt((int)1).value + "." + this.tokenAt((int)3).value;
                this.ltoken.clear();
                this.addTokenToPrefix(T.tokenScript);
                this.addTokenToPrefix(T.o(4, string));
                this.isNewSet = false;
            }
        }
        this.setCommand(this.tokenAt(0));
        int n2 = this.ltoken.size();
        if (n2 == 1 && T.tokAttr(this.tokCommand, 524288)) {
            this.addTokenToPrefix(T.tokenOn);
        }
        if (this.tokenAndEquals != null) {
            int n3 = 0;
            for (n3 = 1; n3 < n2 && (n = this.tokAt(n3)) != 269484242; ++n3) {
            }
            n2 = n3++;
            if (this.ltoken.size() < n3) {
                Logger.error("COMPILER ERROR! - andEquals ");
            } else {
                n = 1;
                while (n < n2) {
                    this.ltoken.add(n3, this.tokenAt(n));
                    ++n;
                    ++n3;
                }
                this.ltoken.set(n2, T.tokenEquals);
                this.ltoken.add(n3, this.tokenAndEquals);
                this.ltoken.add(++n3, T.tokenLeftParen);
                this.addTokenToPrefix(T.tokenRightParen);
            }
        }
        n2 = this.ltoken.size();
        this.atokenInfix = this.ltoken.toArray(new T[n2]);
        if (this.logMessages) {
            Logger.debug("token list:");
            for (n = 0; n < this.atokenInfix.length; ++n) {
                Logger.debug(n + ": " + this.atokenInfix[n]);
            }
            Logger.debug("vBraces list:");
            for (n = 0; n < this.vBraces.size(); ++n) {
                Logger.debug(n + ": " + this.vBraces.get(n));
            }
            Logger.debug("-------------------------------------");
        }
        return this.compileExpressions();
    }

    private T tokenAt(int n) {
        return (T)this.ltoken.get(n);
    }

    @Override
    protected int tokAt(int n) {
        return n < this.ltoken.size() ? this.tokenAt((int)n).tok : 0;
    }

    private T setCommand(T t) {
        this.tokenCommand = t;
        if (t == null) {
            this.tokCommand = 0;
        } else {
            this.tokCommand = this.tokenCommand.tok;
            this.isMathExpressionCommand = this.tokCommand == 0x40000000 || T.tokAttr(this.tokCommand, 36864);
            this.isSetOrDefine = this.tokCommand == 1085443 || this.tokCommand == 1060866;
            this.isCommaAsOrAllowed = T.tokAttr(this.tokCommand, 12288);
            this.implicitString = T.tokAttr(this.tokCommand, 20480);
        }
        return t;
    }

    private void replaceCommand(T t) {
        this.ltoken.remove(0);
        this.ltoken.add(0, this.setCommand(t));
    }

    private void getPrefixToken() {
        this.ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
        this.identLC = this.ident.toLowerCase();
        boolean bl = this.isContextVariable(this.identLC);
        String string = this.ident;
        String string2 = null;
        if (this.nTokens == 0) {
            this.isUserToken = bl;
        }
        if (this.nTokens == 1 && (this.tokCommand == 135368713 || this.tokCommand == 102436 || this.tokCommand == 36868) || this.nTokens != 0 && bl || !this.isDotDot && this.isUserFunction(this.identLC) && (string2 = this.ident) != null && (this.thisFunction == null || !this.thisFunction.name.equals(this.identLC))) {
            this.ident = string2 == null ? this.identLC : string2;
            this.theToken = null;
        } else if (this.ident.length() == 1 || this.lastToken.tok == 0x10100022) {
            this.theToken = T.getTokenFromName(this.ident);
            if (this.theToken == null && (this.theToken = T.getTokenFromName(this.identLC)) != null) {
                this.theToken = T.tv(this.theToken.tok, this.theToken.intValue, this.ident);
            }
        } else {
            this.theToken = T.getTokenFromName(this.identLC);
            if (this.theToken != null && (this.lastToken.tok == 0x100007 || this.lastToken.tok == 0x10100040)) {
                this.theToken = T.o(this.theToken.tok, this.ident);
            }
        }
        if (this.theToken == null) {
            if (this.identLC.indexOf("property_") == 0) {
                this.theToken = T.o(1716520985, this.identLC);
            } else if (string != null) {
                this.theToken = SV.newSV(0x40000000, Integer.MAX_VALUE, this.ident);
                ((SV)this.theToken).myName = string;
            } else {
                this.theToken = T.o(0x40000000, this.ident);
            }
        }
        this.theTok = this.theToken.tok;
    }

    /*
     * Unable to fully structure code
     */
    private int checkSpecialParameterSyntax() {
        if (this.lookingAtString(this.implicitString == false)) {
            if (this.cchToken < 0) {
                return this.ERROR(4);
            }
            var1_1 = this.getUnescapedStringLiteral(this.lastToken != null && this.iHaveQuotedString == false && this.lastToken.tok != 1073741983 && (this.tokCommand == 1085443 && this.nTokens == 2 && this.lastToken.tok == 545259546 || this.tokCommand == 135271427 || this.tokCommand == 1610616835 || this.tokCommand == 135271429 || this.tokCommand == 4124));
            this.iHaveQuotedString = true;
            if ((this.tokCommand == 135271427 || this.tokCommand == 135174) && this.lastToken.tok == 0x8101008 || this.tokCommand == 0x8101008 && var1_1.indexOf("@") < 0) {
                if (!this.getData(var1_1)) {
                    return this.ERROR(11, "data");
                }
            } else {
                this.addTokenToPrefix(T.o(4, var1_1));
                if (this.implicitString) {
                    this.ichEnd = this.ichToken + this.cchToken;
                    this.isEndOfCommand = true;
                }
            }
            return 2;
        }
        if (this.nTokens == this.ptNewSetModifier) {
            var1_2 = this.script.charAt(this.ichToken);
            var2_3 = "+-\\*/&|=".indexOf(var1_2) >= 0 ? 1 : 0;
            var3_9 = var2_3 != 0 || var1_2 == '.' || var1_2 == '[' ? 1 : 0;
            var4_13 = this.charAt(this.ichToken + 1);
            if (!this.isNewSet && this.isUserToken && var3_9 != 0 && (var1_2 == '=' || var4_13 == var1_2 || var4_13 == '=')) {
                this.isNewSet = true;
            }
            if (this.isNewSet || this.tokCommand == 1085443 || T.tokAttr(this.tokCommand, 0x20000000)) {
                if (var1_2 == '=') {
                    this.setEqualPt = this.ichToken;
                }
                if (T.tokAttr(this.tokCommand, 0x20000000) && var1_2 == '=' || (this.isNewSet || this.isSetBrace) && var3_9 != 0) {
                    this.setCommand(var2_3 != 0 ? T.tokenSet : (var1_2 == '[' && this.isSetBrace == false || var1_2 == '.' && var4_13 == '.' ? T.tokenSetArray : T.tokenSetProperty));
                    this.ltoken.add(0, this.tokenCommand);
                    this.cchToken = 1;
                    switch (var1_2) {
                        case '[': {
                            this.tokLastMath = 1;
                            this.addTokenToPrefix(T.tokenArrayOpen);
                            ++this.bracketCount;
                            return 2;
                        }
                        case '.': {
                            if (var4_13 == '.') {
                                this.addTokenToPrefix(T.tokenArrayOpen);
                                this.cchToken = 2;
                                this.isDotDot = true;
                                return 2;
                            }
                            this.addTokenToPrefix(T.o(0x100007, "."));
                            return 2;
                        }
                        case '&': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '/': 
                        case '\\': 
                        case '|': {
                            if (var4_13 == '\u0000') {
                                return this.ERROR(4);
                            }
                            if (var4_13 == var1_2 || var4_13 == '=') break;
                            return this.ERROR(1, "\"" + var1_2 + "\"");
                        }
                        default: {
                            this.lastToken = T.tokenMinus;
                            return 2;
                        }
                    }
                }
            }
        }
        switch (this.tokCommand) {
            case 135270926: {
                if (this.nTokens != 2) ** GOTO lbl58
                if (this.lastToken.tok == 4120) {
                    this.iHaveQuotedString = true;
                }
                ** GOTO lbl60
lbl58:
                // 1 sources

                if (!this.iHaveQuotedString && this.lastToken.tok != 1073741925 && this.lastToken.tok != 1073742189) {
                    return 0;
                }
            }
lbl60:
            // 4 sources

            case 4124: 
            case 135271427: 
            case 135271429: 
            case 1276121098: {
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                if (this.tokCommand == 135271427) {
                    if ((this.nTokens == 1 || this.nTokens == 2 && this.tokAt(1) == 0x4000000F) && this.lookingAtLoadFormat((boolean)(var2_3 = Viewer.isDatabaseCode(this.charAt(this.ichToken))))) {
                        var3_10 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                        var4_14 = T.getTokenFromName(var3_10.toLowerCase());
                        switch (var4_14 == null ? 0 : var4_14.tok) {
                            case 4130: 
                            case 0x4000000F: 
                            case 1073742015: 
                            case 1073742077: 
                            case 1073877011: 
                            case 1610616855: {
                                if (this.nTokens != 1) {
                                    return 4;
                                }
                            }
                            case 135267336: 
                            case 0x8101008: 
                            case 0x2000000E: 
                            case 1073741849: 
                            case 1073741983: 
                            case 1095766030: 
                            case 1229984263: {
                                this.addTokenToPrefix(var4_14);
                                break;
                            }
                            default: {
                                v0 = var2_3 != 0 ? 4 : (var5_16 = PT.isOneOf(var3_10 = var3_10.toLowerCase(), ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;") != false ? 0x40000000 : 0);
                                if (var5_16 == 0) break;
                                this.addTokenToPrefix(T.o(var5_16, var3_10));
                                this.iHaveQuotedString = var5_16 == 4;
                            }
                        }
                        return 2;
                    }
                    if (this.script.charAt(this.ichToken) == '{' || this.parenCount > 0) break;
                    var2_4 = this.lookingAtBitset();
                    if (var2_4 != null) {
                        this.addTokenToPrefix(T.o(10, var2_4));
                        return 2;
                    }
                }
                if (this.iHaveQuotedString || !this.lookingAtImpliedString(this.tokCommand == 135270926, this.tokCommand == 135271427, this.nTokens > 1 || this.tokCommand != 135271429 && this.tokCommand != 4124)) break;
                var2_5 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (this.tokCommand == 135271429) {
                    if (var2_5.startsWith("javascript:")) {
                        this.lookingAtImpliedString(true, true, true);
                        var2_5 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    } else if (var2_5.toUpperCase().indexOf(".PUSH(") >= 0) {
                        this.cchToken = 0;
                        this.iHaveQuotedString = true;
                        return 2;
                    }
                }
                this.iHaveQuotedString = true;
                this.addTokenToPrefix(T.o(4, var2_5));
                return 2;
            }
            case 4156: {
                if (this.nTokens != 1 || !this.lookForSyncID()) break;
                var2_6 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                var3_9 = PT.parseInt(var2_6);
                if (var3_9 == -2147483648 || Math.abs(var3_9) < 1000) {
                    this.addTokenToPrefix(T.o(0x40000000, var2_6));
                } else {
                    this.addTokenToPrefix(T.i(var3_9));
                }
                return 2;
            }
            case 135270422: {
                if (this.nTokens == 2 && this.lastToken.tok == 4115) {
                    this.iHaveQuotedString = true;
                }
                if (this.iHaveQuotedString) break;
                if (this.script.charAt(this.ichToken) == '@') {
                    this.iHaveQuotedString = true;
                    return 0;
                }
                if (!this.lookingAtImpliedString(true, true, true)) break;
                var2_3 = this.cchToken;
                var3_11 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                if (var3_11.indexOf(" ") < 0 && var3_11.indexOf(".") >= 0) {
                    this.addTokenToPrefix(T.o(4, var3_11));
                    this.iHaveQuotedString = true;
                    return 2;
                }
                this.cchToken = var2_3;
            }
        }
        this.implicitString &= this.nTokens == 1;
        if (this.implicitString && (this.tokCommand != 135271429 && this.tokCommand != 4124 || !this.iHaveQuotedString) && this.lookingAtImpliedString(true, true, true)) {
            var2_7 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 1826248716 && PT.isOneOf(var2_7.toLowerCase(), ";on;off;hide;display;")) {
                this.addTokenToPrefix(T.getTokenFromName(var2_7.toLowerCase()));
            } else {
                this.addTokenToPrefix(T.o(4, var2_7));
            }
            return 2;
        }
        if (this.lookingAtObjectID()) {
            this.addTokenToPrefix(T.getTokenFromName("$"));
            this.addTokenToPrefix(T.o(0x40000000, this.script.substring(this.ichToken, this.ichToken + this.cchToken)));
            return 2;
        }
        var2_8 = this.lookingAtExponential();
        if (!Float.isNaN(var2_8)) {
            this.addNumber(3, 0x7FFFFFFF, Float.valueOf(var2_8));
            return 2;
        }
        if (this.lookingAtDecimal()) {
            var2_8 = PT.fVal(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            var3_9 = ScriptParam.getFloatEncodedInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
            this.addNumber(3, var3_9, Float.valueOf(var2_8));
            return 2;
        }
        if (this.lookingAtSeqcode()) {
            var1_2 = this.script.charAt(this.ichToken);
            try {
                var3_9 = var1_2 == '*' || var1_2 == '^' ? 0x7FFFFFFF : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                var4_13 = this.script.charAt(this.ichToken + this.cchToken - 1);
                if (var4_13 == '^') {
                    var4_13 = ' ';
                }
                if (var3_9 < 0) {
                    var3_9 = -var3_9;
                    this.addTokenToPrefix(T.tokenMinus);
                }
                var5_17 = Group.getSeqcodeFor(var3_9, var4_13);
                this.addTokenToPrefix(T.tv(5, var5_17, "seqcode"));
            }
            catch (NumberFormatException var3_12) {
                return this.ERROR(9, "" + var1_2);
            }
            return 2;
        }
        var3_9 = this.lookingAtInteger();
        if (var3_9 != 0x7FFFFFFF) {
            var4_15 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
            if (this.tokCommand == 102407 || this.tokCommand == 102408) {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (this.flowContext == null) {
                    v1 = null;
                } else {
                    var3_9 = Math.abs(var3_9);
                    v1 = var5_18 = this.flowContext.getBreakableContext(var3_9);
                }
                if (var5_18 == null) {
                    return this.ERROR(1, (String)this.tokenCommand.value);
                }
                this.tokenAt((int)0).intValue = var5_18.pt0;
            }
            if (var3_9 == 0 && var4_15.equals("-0")) {
                this.addTokenToPrefix(T.tokenMinus);
            }
            this.addNumber(2, var3_9, var4_15);
            return 2;
        }
        if (!this.isMathExpressionCommand && this.parenCount == 0 || this.lastToken.tok != 0x40000000 && !ScriptCompiler.tokenAttr(this.lastToken, 0x8100000)) {
            var4_13 = this.script.charAt(this.ichToken) == '[' ? '\u0001' : '\u0000';
            var5_19 = this.lookingAtBitset();
            if (var5_19 != null) {
                this.addTokenToPrefix(T.o(10, var4_13 != '\u0000' ? BondSet.newBS(var5_19, null) : var5_19));
                return 2;
            }
            if (var4_13 != '\u0000' && (var6_20 = this.lookingAtMatrix()) instanceof M34) {
                this.addTokenToPrefix(T.o(var6_20 instanceof M4 != false ? 12 : 11, var6_20));
                return 2;
            }
        }
        return 0;
    }

    private void addNumber(int n, int n2, Object object) {
        this.addTokenToPrefix(this.afterWhite == this.ichToken ? SV.newSV(n, n2, object) : T.tv(n, n2, object));
    }

    private Object lookingAtMatrix() {
        Object object;
        int n;
        if (this.ichToken + 4 >= this.cchScript || this.script.charAt(this.ichToken) != '[' || this.script.charAt(this.ichToken + 1) != '[' || (n = this.script.indexOf("]]", this.ichToken)) < 0 || (object = Escape.unescapeMatrix(this.script.substring(this.ichToken, n + 2))) == null) {
            return null;
        }
        this.cchToken = n + 2 - this.ichToken;
        return object;
    }

    private int parseKnownToken() {
        this.getPrefixToken();
        if (this.isDotDot) {
            if (this.theTok == 0x10100040) {
                ++this.bracketCount;
            } else {
                this.addTokenToPrefix(T.o(4, this.ident));
                this.addTokenToPrefix(T.tokenArrayClose);
            }
            this.isDotDot = false;
            return 2;
        }
        if (this.tokLastMath != 0) {
            this.tokLastMath = this.theTok;
        }
        if (this.flowContext != null && this.flowContext.token.tok == 102410 && this.flowContext.var != null && this.theTok != 102411 && this.theTok != 102413 && this.lastToken.tok != 102410) {
            return this.ERROR(1, this.ident);
        }
        if (this.lastToken.tok == 1060866 && this.theTok != 0x10000A && this.nTokens != 1) {
            this.addTokenToPrefix(this.theTok == 1060866 ? this.lastToken : T.o(4, this.ident));
            return 2;
        }
        switch (this.theTok) {
            case 0x40000000: {
                if (this.nTokens != 0 || this.checkImpliedScriptCmd) break;
                if (this.ident.charAt(0) == '\'') {
                    this.addTokenToPrefix(this.setCommand(T.tokenScript));
                    this.cchToken = 0;
                    return 2;
                }
                if (this.charAt(this.ichToken + this.cchToken) != '.') break;
                this.addTokenToPrefix(this.setCommand(T.tokenScript));
                this.nTokens = 1;
                this.cchToken = 0;
                this.checkImpliedScriptCmd = true;
                return 2;
            }
            case 269484242: {
                if (this.nSemiSkip == this.forPoint3 && this.nTokens == this.ptSemi + 2) {
                    T t = this.lastToken;
                    this.addTokenToPrefix(T.tokenEquals);
                    this.addTokenToPrefix(t);
                    t = T.getTokenFromName(this.ident.substring(0, 1));
                    this.addTokenToPrefix(t);
                    this.addTokenToPrefix(T.tokenLeftParen);
                    this.needRightParen = true;
                    return 2;
                }
                this.checkNewSetCommand();
                if (this.tokCommand == 1085443) {
                    this.tokenAndEquals = T.getTokenFromName(this.ident.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                if (this.tokCommand == 554176565 || this.tokCommand == 554176526) {
                    this.addTokenToPrefix(this.tokenCommand);
                    this.replaceCommand(T.tokenSet);
                    this.tokenAndEquals = T.getTokenFromName(this.ident.substring(0, 1));
                    this.setEqualPt = this.ichToken;
                    return 0;
                }
                return 2;
            }
            case 0x119009: {
                if (this.tokCommand == 135174 || this.tokCommand == 4103 && this.nTokens == 1) {
                    return 0;
                }
            }
            case 364548: {
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = false;
                }
            }
            case 364547: {
                if (this.nTokens <= 0) break;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 135369224: {
                if (this.bracketCount > 0) break;
            }
            case 102402: 
            case 102406: 
            case 102410: 
            case 102411: 
            case 102412: 
            case 102413: 
            case 135369225: {
                if (this.nTokens <= 1 || this.tokCommand == 1085443 || this.nSemiSkip != 0) break;
                this.isEndOfCommand = true;
                if (this.flowContext != null) {
                    this.flowContext.forceEndIf = true;
                }
                this.cchToken = 0;
                return 2;
            }
            case 0x101000C1: 
            case 269484226: {
                if (this.afterWhite == this.ichToken || this.afterMath == this.ichToken) {
                    this.theToken = T.tv(this.theToken.tok, -1, this.theToken.value);
                }
                if (!this.isNewSet && this.nTokens == 1) {
                    this.checkNewSetCommand();
                }
                if (this.isNewSet && this.parenCount == 0 && this.bracketCount == 0 && this.ichToken <= this.setEqualPt) {
                    this.tokenizePlusPlus(this.theTok, false);
                    return 2;
                }
                if (this.nSemiSkip != this.forPoint3 || this.nTokens != this.ptSemi + 2) break;
                T t = this.lastToken;
                this.addTokenToPrefix(T.tokenEquals);
                this.addTokenToPrefix(t);
                this.addTokenToPrefix(this.theTok == 0x101000C1 ? T.tokenMinus : T.tokenPlus);
                this.addTokenToPrefix(T.i(1));
                return 2;
            }
            case 269484436: {
                if (this.parenCount != 0 || this.bracketCount != 0) break;
                this.setEqualPt = this.ichToken;
                break;
            }
            case 0x100007: {
                if (this.tokCommand != 1085443 || this.parenCount != 0 || this.bracketCount != 0 || this.ichToken >= this.setEqualPt || this.ltoken.size() <= 1 || ((T)this.ltoken.get((int)1)).tok != 0x10000A) break;
                this.ltoken.set(0, T.tokenSetProperty);
                this.ltoken.add(1, T.tokenExpressionBegin);
                this.addTokenToPrefix(T.tokenExpressionEnd);
                this.setEqualPt = 0;
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                if (this.braceCount == 1 && this.parenCount == 0 && this.checkFlowStartBrace(false)) {
                    this.isEndOfCommand = true;
                    if (this.flowContext != null) {
                        this.flowContext.forceEndIf = false;
                    }
                    return 2;
                }
            }
            case 0x10100010: {
                ++this.parenCount;
                if (this.nTokens <= 1 || this.lastToken.tok != 135280133 && this.lastToken.tok != 135369224 && this.lastToken.tok != 135369225) break;
                this.nSemiSkip += 2;
                break;
            }
            case 0x10000E: {
                if (this.iBrace > 0 && this.parenCount == 0 && this.braceCount == 0) {
                    this.ichBrace = this.ichToken;
                    if (this.nTokens == 0) {
                        this.parenCount = 1;
                        this.braceCount = 1;
                    } else {
                        if (!this.wasImpliedScript()) {
                            this.nSemiSkip = 0;
                            this.parenCount = 0;
                            this.braceCount = 0;
                            if (this.theToken.tok != 102411 && this.theToken.tok != 102413) {
                                this.vBraces.addLast(this.theToken);
                            }
                            ++this.iBrace;
                            this.isEndOfCommand = true;
                            this.ichEnd = this.ichToken;
                        }
                        return 2;
                    }
                }
                --this.braceCount;
            }
            case 0x10100011: {
                --this.parenCount;
                if (this.parenCount < 0) {
                    return this.ERROR(16, this.ident);
                }
                if (this.parenCount == 0) {
                    this.nSemiSkip = 0;
                }
                if (!this.needRightParen) break;
                this.addTokenToPrefix(T.tokenRightParen);
                this.needRightParen = false;
                break;
            }
            case 0x10100040: {
                if (this.ichToken > 0 && PT.isWhitespace(this.script.charAt(this.ichToken - 1))) {
                    this.addTokenToPrefix(T.tokenSpaceBeforeSquare);
                }
                ++this.bracketCount;
                break;
            }
            case 0x10100041: {
                --this.bracketCount;
                if (this.bracketCount >= 0) break;
                return this.ERROR(16, "]");
            }
            case 0x100008: {
                this.isDotDot = true;
                this.addTokenToPrefix(T.tokenArrayOpen);
                return 2;
            }
        }
        return 0;
    }

    private void tokenizePlusPlus(int n, boolean bl) {
        if (bl) {
            this.setCommand(T.tokenSet);
            if (this.nTokens == 1) {
                this.ltoken.add(0, this.tokenCommand);
            }
        }
        this.nTokens = this.ltoken.size();
        this.addTokenToPrefix(T.tokenEquals);
        this.setEqualPt = 0;
        for (int i = 1; i < this.nTokens; ++i) {
            this.addTokenToPrefix((T)this.ltoken.get(i));
        }
        this.addTokenToPrefix(n == 0x101000C1 ? T.tokenMinus : T.tokenPlus);
        this.addTokenToPrefix(T.i(1));
    }

    private boolean checkNewSetCommand() {
        String string = ((T)this.ltoken.get((int)0)).value.toString();
        if (!this.isContextVariable(string.toLowerCase())) {
            return false;
        }
        T t = this.setNewSetCommand(false, string);
        this.setCommand(T.tokenSet);
        this.ltoken.add(0, this.tokenCommand);
        this.ltoken.set(1, t);
        return true;
    }

    private int parseCommandParameter() {
        this.nTokens = this.ltoken.size();
        block0 : switch (this.tokCommand) {
            case 0: {
                int n;
                this.lastToken = T.tokenOff;
                this.ichCurrentCommand = this.ichEnd = this.ichToken;
                this.setCommand(this.theToken);
                if (T.tokAttr(this.tokCommand, 102400)) {
                    this.lastFlowCommand = this.tokenCommand;
                }
                if ((n = this.checkFlowEndBrace()) == 4) {
                    return 4;
                }
                if (n == 2) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (T.tokAttr(this.tokCommand, 102400)) {
                    if (!this.checkFlowCommand((String)this.tokenCommand.value)) {
                        return 4;
                    }
                    this.theToken = this.tokenCommand;
                    if (this.theTok != 102411) break;
                    this.addTokenToPrefix(this.tokenCommand);
                    this.theToken = T.tokenLeftParen;
                    break;
                }
                if (this.theTok == 0x10100022) {
                    ++this.braceCount;
                    this.isEndOfCommand = true;
                    break;
                }
                if (this.theTok == 0x10000E) {
                    this.vBraces.addLast(this.tokenCommand);
                    ++this.iBrace;
                    this.tokCommand = 0;
                    return 2;
                }
                if (this.theTok != 0x10000A) {
                    this.lastFlowCommand = null;
                }
                if (this.theTok == 0x10100060) {
                    this.theToken = T.o(4143, "resume");
                    this.setCommand(this.theToken);
                    this.addTokenToPrefix(this.theToken);
                    this.theToken = T.o(14, "context");
                    return 0;
                }
                if (T.tokAttr(this.tokCommand, 4096)) break;
                boolean bl = this.isSetBrace = this.theTok == 0x10000A;
                if (this.isSetBrace) {
                    if (!this.lookingAtSetBraceSyntax()) {
                        this.isEndOfCommand = true;
                        if (this.flowContext != null) {
                            this.flowContext.forceEndIf = false;
                        }
                    }
                } else {
                    switch (this.theTok) {
                        case 0x101000C1: 
                        case 269484226: {
                            this.tokInitialPlusPlus = this.theTok;
                            this.tokCommand = 0;
                            return 2;
                        }
                        case 36868: 
                        case 1060866: 
                        case 0x10100010: 
                        case 0x40000000: {
                            break;
                        }
                        default: {
                            if (T.tokAttr(this.theTok, 0x40000000) || T.tokAttr(this.theTok, 0x20000000) || this.isContextVariable(this.identLC)) break;
                            this.commandExpected();
                            return 4;
                        }
                    }
                }
                this.theToken = this.setNewSetCommand(this.isSetBrace, this.ident);
                break;
            }
            case 102412: {
                switch (this.nTokens) {
                    case 1: {
                        if (this.theTok == 0x10100010) break block0;
                        return this.ERROR(15, "(");
                    }
                    case 2: {
                        if (this.theTok != 0x10100011) {
                            ((ContextToken)this.tokenCommand).name0 = this.ident;
                        }
                        this.newContextVariable(this.ident);
                        break block0;
                    }
                    case 3: {
                        if (this.theTok != 0x10100011) {
                            return this.ERROR(15, ")");
                        }
                        this.isEndOfCommand = true;
                        this.ichEnd = this.ichToken + 1;
                        this.flowContext.setLine();
                        break block0;
                    }
                }
                return this.ERROR(0);
            }
            case 102436: 
            case 135368713: {
                if (this.tokenCommand.intValue == 0) {
                    if (this.nTokens != 1) break;
                    this.tokenCommand.value = this.ident;
                    return 2;
                }
                if (this.nTokens == 1) {
                    if (this.thisFunction != null) {
                        this.vFunctionStack.add(0, this.thisFunction);
                    }
                    this.thisFunction = this.tokCommand == 102436 ? ScriptCompiler.newScriptParallelProcessor(this.ident, this.tokCommand) : new ScriptFunction(this.ident, this.tokCommand);
                    this.htUserFunctions.put(this.ident, Boolean.TRUE);
                    this.flowContext.setFunction(this.thisFunction);
                    break;
                }
                if (this.nTokens == 2) {
                    if (this.theTok == 0x10100010) break;
                    return this.ERROR(15, "(");
                }
                if (this.nTokens == 3 && this.theTok == 0x10100011) break;
                if (this.nTokens % 2 == 0) {
                    if (this.theTok == 0x10100030 || this.theTok == 0x10100011) break;
                    return this.ERROR(15, ")");
                }
                this.thisFunction.addVariable(this.ident, true);
                break;
            }
            case 102411: {
                if (this.nTokens <= 1 || this.parenCount != 0 || this.braceCount != 0 || this.theTok != 0x10100022) break;
                this.addTokenToPrefix(T.tokenRightParen);
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 102413: {
                if (this.nTokens <= 1) break;
                this.braceCount = 1;
                this.isEndOfCommand = true;
                this.cchToken = 0;
                return 2;
            }
            case 364547: {
                if (this.nTokens == 1 && this.theTok != 135369225) {
                    this.isEndOfCommand = true;
                    this.cchToken = 0;
                    return 2;
                }
                if (this.nTokens != 1 || this.theTok != 135369225 && this.theTok != 0x10000A) {
                    return this.ERROR(0);
                }
                this.flowContext.token = ContextToken.newCmd(102402, "elseif");
                this.replaceCommand(this.flowContext.token);
                this.tokCommand = 102402;
                return 2;
            }
            case 0x119009: {
                if (this.nTokens != 1) {
                    return this.ERROR(0);
                }
                if (!this.checkFlowEnd(this.theTok, this.ident, this.ichCurrentCommand)) {
                    return 4;
                }
                if (this.theTok != 135368713 && this.theTok != 102436) break;
                return 2;
            }
            case 102406: 
            case 102410: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 102402: 
            case 135369225: {
                if (this.nTokens <= 2 || this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 102439: {
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 135369224: {
                if (this.nTokens == 1) {
                    if (this.theTok != 0x10100010) {
                        return this.ERROR(19, this.ident);
                    }
                    this.nSemiSkip = 0;
                    this.forPoint3 = 0;
                    this.nSemiSkip += 2;
                    break;
                }
                if (this.nTokens == 3 && this.tokAt(2) == 36868) {
                    this.newContextVariable(this.ident);
                    break;
                }
                if ((this.nTokens == 3 || this.nTokens == 4) && this.theTok == 1276116993) {
                    this.nSemiSkip -= 2;
                    this.forPoint3 = 2;
                    this.addTokenToPrefix(this.theToken);
                    this.theToken = T.tokenLeftParen;
                    break;
                }
                if (this.braceCount != 0 || this.parenCount != 0) break;
                this.isEndOfCommand = true;
                this.ichEnd = this.ichToken + 1;
                this.flowContext.setLine();
                break;
            }
            case 36868: {
                if (this.nTokens == 1) {
                    this.replaceCommand(T.tokenSetVar);
                    this.newContextVariable(this.ident);
                    break;
                }
                if (this.ident.equals(",")) {
                    return 2;
                }
                if (!PT.isLetter(this.ident.charAt(0))) {
                    if (this.nTokens != 2 || this.ident.equals("[")) {
                        return this.ERROR(0);
                    }
                    this.replaceCommand(T.tokenSet);
                } else {
                    this.newContextVariable(this.ident);
                    break;
                }
            }
            case 1085443: {
                if (this.theTok == 0x10000A) {
                    ++this.setBraceCount;
                } else if (this.theTok == 0x10000E) {
                    --this.setBraceCount;
                    if (this.isSetBrace && this.setBraceCount == 0 && this.ptNewSetModifier == Integer.MAX_VALUE) {
                        this.ptNewSetModifier = this.nTokens + 1;
                    }
                }
                if (this.nTokens != this.ptNewSetModifier) break;
                T t = this.tokenAt(0);
                if (this.theTok == 0x10100010 || this.isUserFunction(t.value.toString())) {
                    this.ltoken.set(0, this.setCommand(T.tv(0x40000000, 0, t.value)));
                    this.setBraceCount = 0;
                    break;
                }
                if (this.theTok != 0x40000000 && this.theTok != 269484242 && this.theTok != 1060866 && !T.tokAttr(this.theTok, 0x20000000)) {
                    if (this.isNewSet) {
                        this.commandExpected();
                    } else {
                        this.errorIntStr2(18, "SET", ": " + this.ident);
                    }
                    return 4;
                }
                if (this.nTokens != 1 || this.lastToken.tok != 269484226 && this.lastToken.tok != 0x101000C1) break;
                this.replaceCommand(T.tokenSet);
                this.addTokenToPrefix(this.lastToken);
                break;
            }
            case 135271427: {
                if (this.theTok == 1060866 && (this.nTokens == 1 || this.lastToken.tok == 0x40000074 || this.lastToken.tok == 1073742152)) {
                    this.addTokenToPrefix(T.tokenDefineString);
                    return 2;
                }
                if (this.theTok != 1073741848) break;
                this.iHaveQuotedString = false;
                break;
            }
            case 12291: 
            case 12294: 
            case 12295: 
            case 1060866: 
            case 135280133: 
            case 1610625028: {
                if (this.tokCommand == 1060866) {
                    if (this.nTokens == 1) {
                        if (this.theTok != 0x40000000) {
                            if (this.preDefining) {
                                if (!T.tokAttr(this.theTok, 0x300000)) {
                                    this.errorStr2("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + this.ident, null);
                                    return 4;
                                }
                            } else if (T.tokAttr(this.theTok, 0x300000)) {
                                Logger.warn("WARNING: predefined term '" + this.ident + "' has been redefined by the user until the next file load.");
                            } else if (!this.isCheckOnly && this.ident.length() > 1) {
                                Logger.warn("WARNING: redefining " + this.ident + "; was " + this.theToken + "not all commands may continue to be functional for the life of the applet!");
                                this.theToken.tok = 0x40000000;
                                this.theTok = 0x40000000;
                                T.addToken(this.ident, this.theToken);
                            }
                        }
                        this.addTokenToPrefix(this.theToken);
                        this.lastToken = T.tokenComma;
                        return 2;
                    }
                    if (this.nTokens == 2 && this.theTok == 269484436) {
                        this.ltoken.add(0, T.tokenSet);
                        return 2;
                    }
                }
                if (this.bracketCount != 0 || this.theTok == 0x40000000 || T.tokAttr(this.theTok, 0x100000) || T.tokAttr(this.theTok, 0x40000000) || (this.theTok & 0x1E0) == this.theTok) break;
                return this.ERROR(9, this.ident);
            }
            case 12289: {
                if (this.theTok == 0x40000000 || this.theTok == 0x100006 || T.tokAttr(this.theTok, 0x100000)) break;
                return this.ERROR(9, this.ident);
            }
            case 135180: 
            case 135188: 
            case 135190: {
                char c = this.charAt(this.ichToken + this.cchToken);
                if (this.parenCount != 0 || this.bracketCount != 0 || ".:/\\+-!?".indexOf(c) < 0 || c == '-' && this.ident.equals("=")) break;
                this.checkUnquotedFileName();
            }
        }
        return 0;
    }

    private static ScriptFunction newScriptParallelProcessor(String string, int n) {
        ScriptFunction scriptFunction = (ScriptFunction)Interface.getInterface("org.jmol.script.ScriptParallelProcessor", null, null);
        scriptFunction.set(string, n);
        return scriptFunction;
    }

    private T setNewSetCommand(boolean bl, String string) {
        this.tokCommand = 1085443;
        this.isNewSet = !bl && !this.isUserFunction(string);
        this.setBraceCount = bl ? 1 : 0;
        this.bracketCount = 0;
        this.setEqualPt = Integer.MAX_VALUE;
        this.ptNewSetModifier = this.isNewSet ? (string.equals("(") ? 2 : 1) : Integer.MAX_VALUE;
        return bl || this.theToken.tok == 0x10100010 || this.theToken.tok == 0x20000006 || this.theToken.tok == 269484226 || this.theToken.tok == 0x101000C1 ? this.theToken : T.o(0x40000000, string);
    }

    private void checkUnquotedFileName() {
        char c;
        int n = this.ichToken;
        while (++n < this.cchScript && !PT.isWhitespace(c = this.script.charAt(n)) && c != '#' && c != ';' && c != '}') {
        }
        String string = this.script.substring(this.ichToken, n).replace('\\', '/');
        this.cchToken = n - this.ichToken;
        this.theToken = T.o(4, string);
    }

    private boolean checkFlowStartBrace(boolean bl) {
        if (!T.tokAttr(this.tokCommand, 102400) || this.tokCommand == 102407 || this.tokCommand == 102408) {
            return false;
        }
        if (bl) {
            if (this.tokenCommand.tok != 102411 && this.tokenCommand.tok != 102413) {
                ++this.iBrace;
                this.vBraces.addLast(this.tokenCommand);
                this.lastFlowCommand = null;
            }
            this.braceCount = 0;
            this.parenCount = 0;
        }
        return true;
    }

    private int checkFlowEndBrace() {
        if (this.iBrace <= 0 || ((T)this.vBraces.get((int)(this.iBrace - 1))).tok != 0x10000E) {
            return 0;
        }
        this.vBraces.remove(--this.iBrace);
        T t = (T)this.vBraces.remove(--this.iBrace);
        if (this.theTok == 0x10000A) {
            --this.braceCount;
            --this.parenCount;
        }
        if (t.tok == 1276384259) {
            this.vPush.remove(--this.pushCount);
            this.addTokenToPrefix(this.setCommand(ContextToken.newContext(false)));
            this.isEndOfCommand = true;
            return 2;
        }
        switch (this.flowContext == null ? 0 : this.flowContext.token.tok) {
            case 102402: 
            case 364547: 
            case 135369225: {
                if (this.tokCommand != 364547 && this.tokCommand != 102402) break;
                return 0;
            }
            case 102410: 
            case 102411: 
            case 102413: {
                if (this.tokCommand != 102411 && this.tokCommand != 102413) break;
                return 0;
            }
        }
        return this.forceFlowEnd(t);
    }

    private int forceFlowEnd(T t) {
        T t2 = this.tokenCommand;
        this.setCommand(T.o(0x119009, "end"));
        if (!this.checkFlowCommand("end")) {
            return 0;
        }
        this.addTokenToPrefix(this.tokenCommand);
        switch (t.tok) {
            case 102402: 
            case 364547: 
            case 135369225: {
                t = T.tokenIf;
                break;
            }
            case 102411: 
            case 102413: {
                t = T.tokenSwitch;
                break;
            }
            default: {
                t = T.getTokenFromName((String)t.value);
            }
        }
        if (!this.checkFlowEnd(t.tok, (String)t.value, this.ichBrace)) {
            return 4;
        }
        if (t.tok != 135368713 && t.tok != 102436 && t.tok != 364558) {
            this.addTokenToPrefix(t);
        }
        this.setCommand(t2);
        return 2;
    }

    static boolean isBreakableContext(int n) {
        return n == 135369224 || n == 102439 || n == 102406 || n == 102411 || n == 102413;
    }

    private boolean checkFlowCommand(String string) {
        Object object;
        int n = this.lltoken.size();
        boolean bl = false;
        boolean bl2 = true;
        switch (this.tokCommand) {
            case 102436: 
            case 135368713: {
                if (this.flowContext == null) break;
                return this.errorStr(1, T.nameOf(this.tokCommand));
            }
            case 0x119009: {
                if (this.flowContext == null) {
                    return this.errorStr(1, string);
                }
                bl = true;
                if (this.flowContext.token.tok == 135368713 || this.flowContext.token.tok == 102436 || this.flowContext.token.tok == 364558) break;
                this.setCommand(T.tv(this.tokCommand, this.flowContext.ptDefault > 0 ? this.flowContext.ptDefault : -this.flowContext.pt0, string));
                break;
            }
            case 102412: 
            case 364558: {
                break;
            }
            case 102406: 
            case 102410: 
            case 102439: 
            case 135369224: 
            case 135369225: {
                break;
            }
            case 364548: {
                bl = true;
                if (this.flowContext != null && (this.flowContext.token.tok == 135369225 || this.flowContext.token.tok == 102439 || this.flowContext.token.tok == 364547 || this.flowContext.token.tok == 102402)) break;
                return this.errorStr(1, string);
            }
            case 364547: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402) {
                    return this.errorStr(1, string);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
                break;
            }
            case 102407: 
            case 102408: {
                bl2 = false;
                Object object2 = object = this.flowContext == null ? null : this.flowContext.getBreakableContext(0);
                if (this.tokCommand == 102408) {
                    while (object != null && ((ScriptFlowContext)object).token.tok != 135369224 && ((ScriptFlowContext)object).token.tok != 102406) {
                        object = ((ScriptFlowContext)object).getParent();
                    }
                }
                if (object == null) {
                    return this.errorStr(1, string);
                }
                this.setCommand(T.tv(this.tokCommand, ((ScriptFlowContext)object).pt0, string));
                break;
            }
            case 102413: {
                if (this.flowContext == null || this.flowContext.token.tok != 102410 && this.flowContext.token.tok != 102411 && this.flowContext.ptDefault > 0) {
                    return this.errorStr(1, string);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, true);
                break;
            }
            case 102411: {
                if (this.flowContext == null || this.flowContext.token.tok != 102410 && this.flowContext.token.tok != 102411 && this.flowContext.token.tok != 102413) {
                    return this.errorStr(1, string);
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
                break;
            }
            case 102402: {
                if (this.flowContext == null || this.flowContext.token.tok != 135369225 && this.flowContext.token.tok != 102402 && this.flowContext.token.tok != 364547) {
                    return this.errorStr(1, "elseif");
                }
                this.flowContext.token.intValue = this.flowContext.setPt0(n, false);
            }
        }
        if (bl) {
            int n2 = this.flowContext.token.intValue = this.tokCommand == 102412 ? -n : n;
            if (this.tokCommand == 364548) {
                this.flowContext = this.flowContext.getParent();
            }
        } else if (bl2) {
            object = ContextToken.newCmd(this.tokCommand, this.tokenCommand.value);
            if (this.tokCommand == 102410) {
                ((ContextToken)object).addName("_var");
            }
            this.setCommand((T)object);
            switch (this.tokCommand) {
                case 364558: {
                    this.flowContext = new ScriptFlowContext(this, (ContextToken)object, n, this.flowContext);
                    if (this.thisFunction != null) {
                        this.vFunctionStack.add(0, this.thisFunction);
                    }
                    this.thisFunction = ScriptCompiler.newScriptParallelProcessor("", this.tokCommand);
                    this.flowContext.setFunction(this.thisFunction);
                    ++this.pushCount;
                    this.vPush.addLast((T)object);
                    break;
                }
                case 102402: 
                case 364547: {
                    this.flowContext.token = object;
                    break;
                }
                case 102411: 
                case 102413: {
                    ((ContextToken)object).contextVariables = this.flowContext.token.contextVariables;
                    this.flowContext.token = object;
                    break;
                }
                case 102406: 
                case 102412: 
                case 102439: 
                case 135369224: {
                    ++this.pushCount;
                    this.vPush.addLast((T)object);
                }
                default: {
                    this.flowContext = new ScriptFlowContext(this, (ContextToken)object, n, this.flowContext);
                }
            }
        }
        return true;
    }

    private boolean checkFlowEnd(int n, String string, int n2) {
        if (this.flowContext == null || this.flowContext.token.tok != n) {
            boolean bl = true;
            switch (n) {
                case 135369225: {
                    bl = this.flowContext.token.tok == 364547 || this.flowContext.token.tok == 102402;
                    break;
                }
                case 102410: {
                    bl = this.flowContext.token.tok == 102411 || this.flowContext.token.tok == 102413;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                return this.errorStr(1, "end " + string);
            }
        }
        switch (n) {
            case 102410: 
            case 135369225: {
                break;
            }
            case 102406: 
            case 102412: 
            case 102439: 
            case 135369224: {
                this.vPush.remove(--this.pushCount);
                break;
            }
            case 102436: 
            case 364558: 
            case 135368713: {
                if (!this.isCheckOnly) {
                    this.addTokenToPrefix(T.o(n, this.thisFunction));
                    ScriptFunction.setFunction(this.thisFunction, this.script, n2, this.lltoken.size(), this.lineNumbers, this.lineIndices, this.lltoken);
                }
                this.thisFunction = this.vFunctionStack.size() == 0 ? null : (ScriptFunction)this.vFunctionStack.remove(0);
                this.tokenCommand.intValue = 0;
                if (n != 364558) break;
                this.vPush.remove(--this.pushCount);
                break;
            }
            default: {
                return this.errorStr(19, "end " + string);
            }
        }
        this.flowContext = this.flowContext.getParent();
        return true;
    }

    private boolean getData(String string) {
        int n;
        this.addTokenToPrefix(T.o(4, string));
        this.ichToken += string.length() + 2;
        if (this.charAt(this.ichToken) == '\r') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if (this.charAt(this.ichToken) == '\n') {
            this.lineCurrent = (short)(this.lineCurrent + 1);
            ++this.ichToken;
        }
        if ((n = this.script.indexOf(this.chFirst + string + this.chFirst, this.ichToken) - 4) < 0 || !this.script.substring(n, n + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String string2 = this.script.substring(this.ichToken, n);
        this.incrementLineCount(string2);
        this.addTokenToPrefix(T.o(0x8101008, string2));
        this.addTokenToPrefix(T.o(0x40000000, "end"));
        this.addTokenToPrefix(T.o(4, string));
        this.cchToken = n - this.ichToken + string.length() + 6;
        return true;
    }

    private int incrementLineCount(String string) {
        int n = string.indexOf(13);
        int n2 = string.indexOf(10);
        if (n < 0 && n2 < 0) {
            return 0;
        }
        short s = this.lineCurrent;
        if (n < 0 || n2 < n) {
            n = n2;
        }
        int n3 = string.length();
        while (--n3 >= n) {
            char c = string.charAt(n3);
            if (c != '\n' && c != '\r') continue;
            this.lineCurrent = (short)(this.lineCurrent + 1);
        }
        return this.lineCurrent - s;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean eol(char c) {
        return c == '\u0000' || c == '\r' || c == '\n' || c == ';' && this.nSemiSkip <= 0;
    }

    private boolean lookingAtSetBraceSyntax() {
        int n = this.ichToken;
        int n2 = 1;
        while (++n < this.cchScript && n2 > 0) {
            switch (this.script.charAt(n)) {
                case '{': {
                    ++n2;
                    break;
                }
                case '}': {
                    --n2;
                }
            }
        }
        if (this.charAt(n) == '[' && ++n2 == 1) {
            while (++n < this.cchScript && n2 > 0) {
                switch (this.script.charAt(n)) {
                    case '[': {
                        ++n2;
                        break;
                    }
                    case ']': {
                        if (this.charAt(n + 1) == '[') {
                            ++n;
                            break;
                        }
                        --n2;
                    }
                }
            }
        }
        return this.charAt(n) == '.' && n2 == 0;
    }

    private boolean lookingAtString(boolean bl) {
        char c;
        if (this.ichToken + 2 > this.cchScript) {
            return false;
        }
        this.chFirst = this.script.charAt(this.ichToken);
        if (!(this.chFirst == '\"' || bl && this.chFirst == '\'')) {
            return false;
        }
        int n = this.ichToken;
        boolean bl2 = false;
        while (++n < this.cchScript && ((c = this.script.charAt(n)) != this.chFirst || bl2)) {
            bl2 = c == '\\' ? !bl2 : false;
        }
        if (n == this.cchScript) {
            this.cchToken = -1;
            this.ichEnd = this.cchScript;
        } else {
            this.cchToken = ++n - this.ichToken;
        }
        return true;
    }

    private String getUnescapedStringLiteral(boolean bl) {
        Object object;
        if (bl) {
            object = this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1);
            if (((String)object).indexOf("\\u") >= 0) {
                object = Escape.unescapeUnicode((String)object);
            }
            if (((String)object).indexOf(";base64,") != 0) {
                return object;
            }
        }
        object = SB.newN(this.cchToken - 2);
        int n = this.ichToken + this.cchToken - 1;
        int n2 = this.ichToken + 1;
        while (n2 < n) {
            int n3;
            if ((n3 = this.script.charAt(n2++)) == 92 && n2 < n) {
                n3 = this.script.charAt(n2++);
                switch (n3) {
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    case 116: {
                        n3 = 9;
                        break;
                    }
                    case 114: {
                        n3 = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char c;
                        int n4;
                        int n5;
                        int n6 = n5 = n3 == 120 ? 2 : 4;
                        if (n2 >= n) break;
                        int n7 = 0;
                        int n8 = n5;
                        while (--n8 >= 0 && n2 < n && (n4 = Escape.getHexitValue(c = this.script.charAt(n2))) >= 0) {
                            n7 <<= 4;
                            n7 += n4;
                            ++n2;
                        }
                        n3 = (char)n7;
                    }
                }
            }
            ((SB)object).appendC((char)n3);
        }
        return ((SB)object).toString();
    }

    private boolean lookingAtLoadFormat(boolean bl) {
        char c;
        int n = this.ichToken;
        while (PT.isLetterOrDigit(c = this.charAt(n)) && (bl || PT.isLetter(c)) || bl && !this.eol(c) && !PT.isWhitespace(c)) {
            ++n;
        }
        if (!bl && n == this.ichToken || !ScriptCompiler.isSpaceOrTab(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtImpliedString(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        int n = this.ichToken;
        char c = this.script.charAt(n);
        boolean bl5 = this.lastToken.tok == 1074790550;
        boolean bl6 = T.tokAttr(this.tokCommand, 20480) && (this.tokCommand & 1) == 1;
        boolean bl7 = c == '@';
        boolean bl8 = bl4 = bl7 && n + 3 < this.cchScript && this.script.charAt(n + 1) == '{';
        if (bl4 && (bl5 || !bl6)) {
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        boolean bl9 = true;
        int n4 = 0;
        block6: while (bl9 && !this.eol(c = this.charAt(n))) {
            switch (c) {
                case '(': {
                    if (bl3 || this.tokCommand != 4124 && (n < 5 || !this.script.substring(n - 4, n).equals(".spt") && !this.script.substring(n - 4, n).equals(".png") && !this.script.substring(n - 5, n).equals(".pngj"))) break;
                    bl9 = false;
                    continue block6;
                }
                case '=': {
                    if (bl2) break;
                    bl9 = false;
                    continue block6;
                }
                case '{': {
                    ++n4;
                    break;
                }
                case '}': {
                    if (--n4 < 0 && (this.braceCount > 0 || this.iBrace > 0)) {
                        bl9 = false;
                        continue block6;
                    }
                }
                default: {
                    if (PT.isWhitespace(c)) {
                        if (n2 >= 0) break;
                        n2 = n;
                        break;
                    }
                    n3 = n;
                }
            }
            ++n;
        }
        if (bl) {
            n = n3 + 1;
        } else if (n2 > 0) {
            n = n2;
        }
        if (bl7 && (!bl || n2 < 0 && n4 <= 0 && n - this.ichToken > 1)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    private float lookingAtExponential() {
        int n;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int n2 = n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n3 = 88;
        while (true) {
            char c = this.charAt(n);
            n3 = c;
            if (!PT.isDigit(c)) break;
            ++n;
            bl = true;
        }
        if (n < this.cchScript && n3 == 46) {
            ++n;
        }
        while (true) {
            char c = this.charAt(n);
            n3 = c;
            if (!PT.isDigit(c)) break;
            ++n;
            bl = true;
        }
        if (n == this.cchScript || !bl) {
            return Float.NaN;
        }
        boolean bl2 = bl = n3 != 69 && n3 != 101;
        if (bl || ++n == this.cchScript) {
            return Float.NaN;
        }
        n3 = this.script.charAt(n);
        if (n3 == 45 || n3 == 43) {
            ++n;
        }
        while (PT.isDigit(this.charAt(n))) {
            ++n;
            bl = true;
        }
        if (!bl) {
            return Float.NaN;
        }
        this.cchToken = n - this.ichToken;
        return (float)PT.dVal(this.script.substring(n2, n));
    }

    private boolean lookingAtDecimal() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            // empty if block
        }
        boolean bl = false;
        while (true) {
            int n2 = ++n;
            ++n;
            c = this.charAt(n2);
            if (!PT.isDigit(c)) break;
            bl = true;
        }
        if (c != '.') {
            return false;
        }
        char c2 = this.charAt(n);
        if (!this.eol(c2)) {
            if (PT.isLetter(c2) || c2 == '?' || c2 == '*') {
                return false;
            }
            c2 = this.charAt(n + 1);
            if (PT.isLetter(c2) || c2 == '?') {
                return false;
            }
        }
        while (PT.isDigit(this.charAt(n))) {
            ++n;
            bl = true;
        }
        this.cchToken = n - this.ichToken;
        return bl;
    }

    private boolean lookingAtSeqcode() {
        char c;
        int n = this.ichToken;
        if (this.charAt(n + 1) == '^' && this.script.charAt(n) == '*') {
            c = '^';
            ++n;
        } else {
            if (this.script.charAt(n) == '-') {
                ++n;
            }
            while (true) {
                char c2 = this.charAt(n);
                c = c2;
                if (!PT.isDigit(c2)) break;
                ++n;
            }
        }
        if (c != '^') {
            return false;
        }
        if ((c = ++n == this.cchScript ? (char)' ' : (char)this.script.charAt(n++)) != ' ' && c != '*' && c != '?' && !PT.isLetter(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private int lookingAtInteger() {
        if (this.ichToken == this.cchScript) {
            return Integer.MAX_VALUE;
        }
        int n = this.ichToken;
        if (this.script.charAt(this.ichToken) == '-') {
            ++n;
        }
        int n2 = n;
        while (PT.isDigit(this.charAt(n))) {
            ++n;
        }
        if (n2 == n) {
            return Integer.MAX_VALUE;
        }
        this.cchToken = n - this.ichToken;
        try {
            this.ident = this.script.substring(this.ichToken, n);
            int n3 = Integer.parseInt(this.ident);
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    BS lookingAtBitset() {
        int n;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BS();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || (n = this.script.indexOf("}", this.ichToken)) < 0 || n + 1 == this.cchScript) {
            return null;
        }
        BS bS = BS.unescape(this.script.substring(this.ichToken, n + 2));
        if (bS != null) {
            this.cchToken = n + 2 - this.ichToken;
        }
        return bS;
    }

    private boolean lookingAtObjectID() {
        boolean bl = this.nTokens == 1;
        int n = this.ichToken;
        if (this.charAt(n) != '$') {
            return false;
        }
        if (this.charAt(++n) == '\"') {
            return false;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            if (PT.isWhitespace(c)) {
                if (n != this.ichToken + 1) break;
                return false;
            }
            if (!PT.isLetterOrDigit(c)) {
                switch (c) {
                    default: {
                        return false;
                    }
                    case '*': {
                        if (bl) break;
                        return false;
                    }
                    case '_': 
                    case '~': 
                }
            }
            ++n;
        }
        this.cchToken = n - ++this.ichToken;
        return true;
    }

    private boolean lookingAtLookupToken(int n) {
        if (n == this.cchScript) {
            return false;
        }
        int n2 = n;
        this.afterMath = this.tokLastMath != 0 ? n : 0;
        this.tokLastMath = 0;
        char c = this.script.charAt(n++);
        switch (c) {
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '|': {
                if (n < this.cchScript) {
                    if (this.script.charAt(n) == c) {
                        ++n;
                        if (c == '-' || c == '+') break;
                        if (c == '&' && this.charAt(n) == c) {
                            ++n;
                        }
                    } else if (this.script.charAt(n) == '=') {
                        ++n;
                    }
                }
                this.tokLastMath = 1;
                break;
            }
            case '/': {
                if (this.charAt(n) == '/') break;
            }
            case '!': 
            case '\\': {
                if (this.charAt(n) == '=') {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            case ')': 
            case ']': 
            case '}': {
                break;
            }
            case '.': {
                if (this.charAt(n) != '.') break;
                ++n;
                break;
            }
            case '@': 
            case '{': {
                this.tokLastMath = 2;
                break;
            }
            case ':': {
                this.tokLastMath = 1;
                break;
            }
            case '$': 
            case '%': 
            case '(': 
            case ',': 
            case ';': 
            case '[': {
                this.tokLastMath = 1;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                c = this.charAt(n);
                if (c == '<' || c == '=' || c == '>') {
                    ++n;
                }
                this.tokLastMath = 1;
                break;
            }
            default: {
                if (!PT.isLetter(c) && !this.isDotDot) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                if (c == '?') {
                    this.tokLastMath = 1;
                }
                while (PT.isLetterOrDigit(c = this.charAt(n)) || c == '_' || c == '*' && this.charAt(n - 1) == '?' || c == '?' || c == '~' || c == '\'' || c == '\\' && this.charAt(n + 1) == '?' || c == '^' && n > n2 && PT.isDigit(this.charAt(n - 1))) {
                    ++n;
                }
                break block0;
            }
        }
        this.cchToken = n - n2;
        return true;
    }

    private boolean lookForSyncID() {
        char c = this.charAt(this.ichToken);
        if (c == '\"' || c == '@' || c == '\u0000') {
            return false;
        }
        int n = this.ichToken;
        while (!ScriptCompiler.isSpaceOrTab(c = this.charAt(n)) && c != '#' && c != '}' && !this.eol(c)) {
            ++n;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private int ERROR(int n) {
        this.errorIntStr2(n, null, null);
        return 4;
    }

    private int ERROR(int n, String string) {
        this.errorStr(n, string);
        return 4;
    }

    private boolean handleError() {
        this.errorType = this.errorMessage;
        this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichEnd <= this.ichCurrentCommand ? this.ichToken : this.ichEnd);
        String string = (this.ichToken < this.ichEnd ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = GT._("script compiler ERROR: ") + this.errorMessage + ScriptError.getErrorLineMessage(null, this.filename, this.lineCurrent, this.iCommand, string);
        if (!this.isSilent) {
            this.ichToken = Math.max(this.ichEnd, this.ichToken);
            while (!this.lookingAtEndOfLine() && !this.lookingAtTerminator()) {
                ++this.ichToken;
            }
            this.errorLine = this.script.substring(this.ichCurrentCommand, this.ichToken);
            this.vwr.addCommand(this.errorLine + "#??");
            Logger.error(this.errorMessage);
        }
        return false;
    }
}

