/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.script.SV;
import org.jmol.util.Logger;

public class MMCifValidationParser {
    private boolean asResidues;
    private AtomSetCollectionReader reader;
    private Map<String, int[]> resMap;
    private Map<String, Integer> atomMap;

    public MMCifValidationParser set(AtomSetCollectionReader atomSetCollectionReader) {
        this.reader = atomSetCollectionReader;
        this.asResidues = atomSetCollectionReader.checkFilterKey("ASRES");
        return this;
    }

    public String finalizeValidations(Map<String, Integer> map) {
        this.mapAtomResIDs(map);
        SV sV = (SV)this.reader.validation;
        Lst<Object> lst = this.reader.vwr.getAnnotationParser().catalogValidations(this.reader.vwr, sV, this.getModelAtomIndices(), this.resMap, this.asResidues ? null : this.atomMap, map);
        String string = lst == null || lst.size() == 0 ? null : this.setProperties(lst);
        sV.mapPut("_note", SV.newS(string));
        return string;
    }

    public String finalizeRna3d(Map<String, Integer> map) {
        this.mapAtomResIDs(map);
        SV sV = this.getRna3dMap(this.reader.addedData);
        String string = this.reader.vwr.getAnnotationParser().catalogStructureUnits(this.reader.vwr, sV, this.getModelAtomIndices(), this.resMap, null, map);
        sV.mapPut("_note", SV.newS(string));
        int n = this.reader.asc.atomSetCount;
        while (--n >= 0) {
            Map<String, Object> map2 = this.reader.asc.getAtomSetAuxiliaryInfo(n);
            map2.put("rna3d", sV);
        }
        return string;
    }

    private SV getRna3dMap(String string) {
        Hashtable hashtable = new Hashtable();
        int[] nArray = new int[1];
        String string2 = "";
        block5: while ((string2 = PT.getQuotedStringNext(string, nArray)).length() > 0) {
            String string3 = PT.getQuotedStringNext(string, nArray);
            String string4 = "?";
            switch (string2.charAt(0)) {
                case 'H': {
                    string4 = "hairpinLoops";
                    break;
                }
                case 'I': {
                    string4 = "internalLoops";
                    break;
                }
                case 'J': {
                    string4 = "junctions";
                    break;
                }
                default: {
                    Logger.error("MMCif could not read: " + string2 + " " + string3);
                    continue block5;
                }
            }
            Lst<Hashtable<String, Object>> lst = (Lst<Hashtable<String, Object>>)hashtable.get(string4);
            if (lst == null) {
                lst = new Lst<Hashtable<String, Object>>();
                hashtable.put(string4, lst);
            }
            Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
            hashtable2.put("index", PT.parseInt(string2.substring(string2.lastIndexOf("_") + 1)));
            hashtable2.put("units", string3);
            lst.addLast(hashtable2);
        }
        return SV.getVariableMap(hashtable);
    }

    private void mapAtomResIDs(Map<String, Integer> map) {
        Atom[] atomArray = this.reader.asc.atoms;
        this.resMap = new Hashtable<String, int[]>();
        this.atomMap = new Hashtable<String, Integer>();
        int n = -1;
        int[] nArray = null;
        String string = "" + map.get("_0");
        int n2 = 1;
        int n3 = 0;
        int n4 = this.reader.asc.getAtomSetAtomCount(0);
        for (int i = 0; i < n4; ++i) {
            Atom atom = atomArray[i];
            int n5 = atom.sequenceNumber;
            String string2 = string + "_" + atom.chainID + "_" + n5 + "_" + (atom.insertionCode == '\u0000' ? "" : "" + atom.insertionCode);
            String string3 = string2 + "_" + atom.atomName.toUpperCase() + "_" + (atom.altLoc == '\u0000' ? "" : "" + Character.toLowerCase(atom.altLoc));
            Integer n6 = i - n3;
            if (n5 != n) {
                n = n5;
                if (nArray != null) {
                    nArray[1] = i - n3;
                }
                nArray = new int[]{i - n3, n4};
                this.resMap.put(string2, nArray);
            }
            this.atomMap.put(string3, n6);
            if (i != n4 - 1) continue;
            n3 += n4;
            n4 = this.reader.asc.getAtomSetAtomCount(n2++);
        }
    }

    private int[] getModelAtomIndices() {
        int[] nArray = new int[this.reader.asc.atomSetCount + 1];
        int n = nArray.length - 1;
        while (--n >= 0) {
            nArray[n] = this.reader.baseAtomIndex + this.reader.asc.getAtomSetAtomIndex(n);
        }
        nArray[nArray.length - 1] = this.reader.asc.ac;
        return nArray;
    }

    private String setProperties(Lst<Object> lst) {
        String string = "Validations loaded:";
        int n = 0;
        int n2 = lst.size();
        while (n < n2) {
            String string2 = (String)lst.get(n++);
            float[] fArray = (float[])lst.get(n++);
            int n3 = (Integer)lst.get(n++);
            boolean bl = (Boolean)lst.get(n++);
            int n4 = 0;
            float f = 0.0f;
            int n5 = -1;
            int n6 = this.reader.asc.getAtomSetAtomIndex(n3);
            int n7 = fArray.length;
            while (--n7 >= 0) {
                if (fArray[n7] == 0.0f) continue;
                if (bl) {
                    int n8 = this.reader.asc.atoms[n6 + n7].sequenceNumber;
                    if (n8 != n5) {
                        n5 = n8;
                        ++n4;
                    }
                } else {
                    ++n4;
                }
                f = Math.max(fArray[n7], f);
            }
            string = string + "\n  property_" + string2 + " (" + (bl ? "residues: " : "atoms: ") + n4 + (f == 1.0f ? "" : ", max: " + (float)((int)(f * 100.0f)) / 100.0f) + ")";
            this.reader.asc.setAtomProperties(string2, fArray, n3, bl);
        }
        return string;
    }
}

