/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.V3;
import org.jmol.api.JmolModulationSet;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Vectors;
import org.jmol.util.Point3fi;
import org.jmol.util.Vibration;

public class VectorsRenderer
extends ShapeRenderer {
    private static final float arrowHeadOffset = -0.2f;
    private final Point3fi ptTemp = new Point3fi();
    private final P3 pointVectorStart = new P3();
    private final Point3fi pointVectorEnd = new Point3fi();
    private final P3 pointArrowHead = new P3();
    private final P3 screenVectorStart = new P3();
    private final P3 screenVectorEnd = new P3();
    private final P3 screenArrowHead = new P3();
    private final V3 headOffsetVector = new V3();
    private final P3 pTemp3 = new P3();
    private int diameter;
    private int headWidthPixels;
    private float vectorScale;
    private boolean vectorSymmetry;
    private float headScale;
    private boolean drawShaft;
    private Vibration vibTemp;
    private boolean vectorsCentered;
    private boolean standardVector = true;
    private boolean vibrationOn;
    private boolean drawCap;
    private boolean showModVecs;

    @Override
    protected boolean render() {
        JmolModulationSet jmolModulationSet;
        Atom atom;
        Vectors vectors = (Vectors)this.shape;
        if (!vectors.isActive) {
            return false;
        }
        short[] sArray = vectors.mads;
        if (sArray == null) {
            return false;
        }
        Atom[] atomArray = vectors.atoms;
        short[] sArray2 = vectors.colixes;
        boolean bl = false;
        this.vectorScale = this.vwr.getFloat(1649410049);
        if (this.vectorScale < 0.0f) {
            this.vectorScale = 1.0f;
        }
        this.vectorSymmetry = this.vwr.getBoolean(603979973);
        this.vectorsCentered = this.vwr.getBoolean(603979972);
        this.showModVecs = this.vwr.getBoolean(603979927);
        this.vibrationOn = this.vwr.tm.vibrationOn;
        this.headScale = -0.2f;
        if (this.vectorScale < 0.0f) {
            this.headScale = -this.headScale;
        }
        boolean bl2 = false;
        int n = this.ms.ac;
        while (--n >= 0) {
            Vibration vibration;
            atom = atomArray[n];
            if (!this.isVisibleForMe(atom)) continue;
            jmolModulationSet = this.ms.getModulation(n);
            if (this.showModVecs && !bl2 && jmolModulationSet != null) {
                bl2 = true;
            }
            if ((vibration = this.ms.getVibration(n, false)) == null || !this.transform(sArray[n], atom, vibration, jmolModulationSet)) continue;
            if (!this.g3d.setC(Shape.getColix(sArray2, n, atom))) {
                bl = true;
                continue;
            }
            this.renderVector(atom);
            if (!this.vectorSymmetry) continue;
            if (this.vibTemp == null) {
                this.vibTemp = new Vibration();
            }
            this.vibTemp.setT(vibration);
            this.vibTemp.scale(-1.0f);
            this.transform(sArray[n], atom, this.vibTemp, null);
            this.renderVector(atom);
        }
        if (bl2) {
            n = this.ms.ac;
            while (--n >= 0) {
                atom = atomArray[n];
                if (!this.isVisibleForMe(atom) || (jmolModulationSet = this.ms.getModulation(n)) == null || !this.transform(sArray[n], atom, null, jmolModulationSet)) continue;
                if (!this.g3d.setC(Shape.getColix(sArray2, n, atom))) {
                    bl = true;
                    continue;
                }
                this.renderVector(atom);
            }
        }
        return bl;
    }

    private boolean transform(short s, Atom atom, Vibration vibration, JmolModulationSet jmolModulationSet) {
        boolean bl;
        boolean bl2 = vibration == null || vibration.modDim >= 0;
        boolean bl3 = bl = !bl2 && vibration.modDim == -2;
        if (vibration == null) {
            vibration = (Vibration)((Object)jmolModulationSet);
        }
        this.drawCap = true;
        if (!bl2) {
            float f = vibration.length();
            if ((double)Math.abs(f * this.vectorScale) < 0.01) {
                return false;
            }
            this.standardVector = true;
            this.drawShaft = 0.1 + (double)Math.abs(this.headScale / f) < (double)Math.abs(this.vectorScale);
            this.headOffsetVector.setT(vibration);
            this.headOffsetVector.scale(this.headScale / f);
        }
        this.ptTemp.setT(atom);
        JmolModulationSet jmolModulationSet2 = atom.getModulation();
        if (this.vibrationOn && jmolModulationSet2 != null) {
            this.vwr.tm.getVibrationPoint((Vibration)((Object)jmolModulationSet2), this.ptTemp, 1.0f);
        }
        if (bl2) {
            this.standardVector = false;
            this.drawShaft = true;
            jmolModulationSet2 = (JmolModulationSet)((Object)vibration);
            this.pointVectorStart.setT(this.ptTemp);
            this.pointVectorEnd.setT(this.ptTemp);
            if (jmolModulationSet2.isEnabled()) {
                if (this.vibrationOn) {
                    this.vwr.tm.getVibrationPoint(vibration, this.pointVectorEnd, Float.NaN);
                }
                jmolModulationSet2.addTo(this.pointVectorStart, Float.NaN);
            } else {
                jmolModulationSet2.addTo(this.pointVectorEnd, 1.0f);
            }
            this.headOffsetVector.sub2(this.pointVectorEnd, this.pointVectorStart);
            float f = this.headOffsetVector.length();
            this.drawCap = f + -0.2f > 0.001f;
            this.drawShaft = f > 0.01f;
            this.headOffsetVector.scale(this.headScale / this.headOffsetVector.length());
        } else if (this.vectorsCentered || bl) {
            this.standardVector = false;
            this.pointVectorEnd.scaleAdd2(0.5f * this.vectorScale, vibration, this.ptTemp);
            this.pointVectorStart.scaleAdd2(-0.5f * this.vectorScale, vibration, this.ptTemp);
        } else {
            this.pointVectorEnd.scaleAdd2(this.vectorScale, vibration, this.ptTemp);
            this.pointArrowHead.add2(this.pointVectorEnd, this.headOffsetVector);
            if (this.vibrationOn) {
                P3i p3i = this.tm.transformPtVib(this.pointVectorEnd, vibration);
                this.screenVectorEnd.set(p3i.x, p3i.y, p3i.z);
                p3i = this.tm.transformPtVib(this.pointArrowHead, vibration);
                this.screenArrowHead.set(p3i.x, p3i.y, p3i.z);
            } else {
                this.tm.transformPtScrT3(this.pointVectorEnd, this.screenVectorEnd);
                this.tm.transformPtScrT3(this.pointArrowHead, this.screenArrowHead);
            }
        }
        if (!this.standardVector) {
            this.tm.transformPtScrT3(this.pointVectorEnd, this.screenVectorEnd);
            this.tm.transformPtScrT3(this.pointVectorStart, this.screenVectorEnd);
            if (this.drawCap) {
                this.pointArrowHead.add2(this.pointVectorEnd, this.headOffsetVector);
            } else {
                this.pointArrowHead.setT(this.pointVectorEnd);
            }
            this.tm.transformPtScrT3(this.pointArrowHead, this.screenArrowHead);
        }
        this.diameter = (int)(s < 0 ? (float)(-s) : (s < 1 ? 1.0f : this.vwr.tm.scaleToScreen((int)this.screenVectorEnd.z, s)));
        this.headWidthPixels = this.diameter << 1;
        if (this.headWidthPixels < this.diameter + 2) {
            this.headWidthPixels = this.diameter + 2;
        }
        return true;
    }

    private void renderVector(Atom atom) {
        if (this.drawShaft) {
            this.pTemp3.set(atom.sX, atom.sY, atom.sZ);
            if (this.standardVector) {
                this.g3d.fillCylinderBits((byte)1, this.diameter, this.pTemp3, this.screenArrowHead);
            } else {
                this.g3d.fillCylinderBits((byte)2, this.diameter, this.screenVectorStart, this.screenArrowHead);
            }
        }
        if (this.drawCap) {
            this.g3d.fillConeScreen3f((byte)2, this.headWidthPixels, this.screenArrowHead, this.screenVectorEnd, false);
        }
    }
}

