/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.java.BS;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;

public final class Chain {
    public Model model;
    public int chainID;
    public int chainNo;
    public Group[] groups;
    public int groupCount;
    public int selectedGroupCount;
    public boolean isDna;
    public boolean isRna;

    Chain(Model model, int n, int n2) {
        this.model = model;
        this.chainID = n;
        this.chainNo = n2;
        this.groups = new Group[16];
    }

    public String getIDStr() {
        return this.chainID == 0 ? "" : (this.chainID < 256 ? "" + (char)this.chainID : this.model.ms.vwr.getChainIDStr(this.chainID));
    }

    void calcSelectedGroupsCount(BS bS) {
        this.selectedGroupCount = 0;
        for (int i = 0; i < this.groupCount; ++i) {
            int n;
            Group group = this.groups[i];
            if (this.groups[i].isSelected(bS)) {
                int n2 = this.selectedGroupCount;
                n = n2;
                this.selectedGroupCount = n2 + 1;
            } else {
                n = -1;
            }
            group.selectedIndex = n;
        }
    }

    void fixIndices(int n, BS bS) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].fixIndices(n, bS);
        }
    }

    public void setAtomBits(BS bS) {
        for (int i = 0; i < this.groupCount; ++i) {
            this.groups[i].setAtomBits(bS);
        }
    }
}

