/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.server;

import com.sparshui.GestureType;
import com.sparshui.common.Event;
import com.sparshui.gestures.Gesture;
import com.sparshui.server.GestureFactory;
import com.sparshui.server.ServerToClientProtocol;
import com.sparshui.server.TouchPoint;
import java.io.IOException;
import javajs.util.Lst;

public class Group {
    private int _id;
    private Lst<GestureType> _gestureTypes;
    private Lst<Gesture> _gestures;
    private Lst<TouchPoint> _touchPoints;
    private ServerToClientProtocol _clientProtocol;

    public Group(int n, Lst<GestureType> lst, ServerToClientProtocol serverToClientProtocol) {
        this._id = n;
        this._gestureTypes = lst;
        this._gestures = new Lst();
        this._touchPoints = new Lst();
        this._clientProtocol = serverToClientProtocol;
        for (int i = 0; i < this._gestureTypes.size(); ++i) {
            Gesture gesture = GestureFactory.createGesture((GestureType)this._gestureTypes.get(i));
            if (gesture == null) continue;
            this._gestures.addLast(gesture);
        }
    }

    public int getID() {
        return this._id;
    }

    public synchronized void update(TouchPoint touchPoint) {
        Lst<Event> lst = new Lst<Event>();
        int n = touchPoint.getState();
        if (n == 0) {
            this._touchPoints.addLast(touchPoint);
        }
        for (int i = 0; i < this._gestures.size(); ++i) {
            Gesture gesture = (Gesture)this._gestures.get(i);
            lst.addAll(gesture.processChange(this._touchPoints, touchPoint));
        }
        if (n == 1) {
            this._touchPoints.removeObj(touchPoint);
        }
        try {
            this._clientProtocol.processEvents(this._id, lst);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

