/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipReader;
import jspecview.api.SourceReader;
import jspecview.common.Coordinate;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PeakInfo;
import jspecview.common.Spectrum;
import jspecview.exception.JSVException;
import jspecview.source.JDXDataObject;
import jspecview.source.JDXDecompressor;
import jspecview.source.JDXHeader;
import jspecview.source.JDXSource;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.api.JmolJDXMOLParser;
import org.jmol.api.JmolJDXMOLReader;
import org.jmol.util.Logger;

public class JDXReader
implements JmolJDXMOLReader {
    private static final String[] VAR_LIST_TABLE = new String[]{"PEAKTABLE   XYDATA      XYPOINTS", " (XY..XY)    (X++(Y..Y)) (XY..XY)    "};
    static final String ERROR_SEPARATOR = "=====================\n";
    private float nmrMaxY = Float.NaN;
    private JDXSource source;
    private JDXSourceStreamTokenizer t;
    private SB errorLog;
    private boolean obscure;
    private boolean done;
    private boolean isZipFile;
    private String filePath;
    private boolean loadImaginary = true;
    private boolean isSimulation;
    private boolean isTabularData;
    private int firstSpec = 0;
    private int lastSpec = 0;
    private int nSpec = 0;
    private double blockID;
    private JmolJDXMOLParser mpr;
    private BufferedReader reader;
    private Spectrum modelSpectrum;
    private Lst<String[]> acdAssignments;
    private String acdMolFile;
    private Lst<PeakInfo> peakData;

    public static String getVarList(String string) {
        int n = VAR_LIST_TABLE[0].indexOf(string);
        return VAR_LIST_TABLE[1].substring(n + 1, n + 12).trim();
    }

    private JDXReader(String string, boolean bl, boolean bl2, int n, int n2, float f) {
        string = PT.trimQuotes(string);
        boolean bl3 = this.isSimulation = string != null && string.startsWith("http://SIMULATION/");
        if (this.isSimulation) {
            this.nmrMaxY = Float.isNaN(f) ? 10000.0f : f;
        }
        this.filePath = string;
        this.obscure = bl;
        this.firstSpec = n;
        this.lastSpec = n2;
        this.loadImaginary = bl2;
    }

    public static JDXSource createJDXSourceFromStream(InputStream inputStream, boolean bl, boolean bl2, float f) throws Exception {
        return JDXReader.createJDXSource(JSVFileManager.getBufferedReaderForInputStream(inputStream), "stream", bl, bl2, -1, -1, f);
    }

    public static JDXSource createJDXSource(BufferedReader bufferedReader, String string, boolean bl, boolean bl2, int n, int n2, float f) throws Exception {
        String string2 = null;
        try {
            if (bufferedReader == null) {
                bufferedReader = JSVFileManager.getBufferedReaderFromName(string, "##TITLE");
            }
            bufferedReader.mark(400);
            char[] cArray = new char[400];
            bufferedReader.read(cArray, 0, 400);
            bufferedReader.reset();
            string2 = new String(cArray);
            int n3 = string2.indexOf(35);
            int n4 = string2.indexOf(60);
            if (n3 < 0 || n4 >= 0 && n4 < n3) {
                String string3 = string2.toLowerCase();
                string3 = string3.contains("<animl") || string3.contains("<!doctype technique") ? "AnIML" : (string3.contains("xml-cml") ? "CML" : null);
                JDXSource jDXSource = null;
                if (string3 != null) {
                    jDXSource = ((SourceReader)JSViewer.getInterface("jspecview.source." + string3 + "Reader")).getSource(string, bufferedReader);
                }
                bufferedReader.close();
                if (jDXSource == null) {
                    Logger.error(string2 + "...");
                    throw new JSVException("File type not recognized");
                }
                return jDXSource;
            }
            return new JDXReader(string, bl, bl2, n, n2, f).getJDXSource(bufferedReader);
        }
        catch (Exception exception) {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (string2 != null) {
                Logger.error(string2 + "...");
            }
            String string4 = exception.getMessage();
            throw new JSVException("Error reading data: " + string4);
        }
    }

    private JDXSource getJDXSource(Object object) throws JSVException {
        this.source = new JDXSource(0, this.filePath);
        this.isZipFile = object instanceof JSVZipReader;
        this.t = new JDXSourceStreamTokenizer((BufferedReader)object);
        this.errorLog = new SB();
        String string = null;
        String string2 = null;
        boolean bl = false;
        while (!this.done && "##TITLE".equals(this.t.peakLabel())) {
            bl = true;
            if (string != null && !this.isZipFile) {
                this.errorLog.append("Warning - file is a concatenation without LINK record -- does not conform to IUPAC standards!\n");
            }
            Spectrum spectrum = new Spectrum();
            Lst<String[]> lst = new Lst<String[]>();
            while (!this.done && (string = this.t.getLabel()) != null && (string2 = this.getValue(string)) != null) {
                if (this.isTabularData) {
                    this.setTabularDataType(spectrum, string);
                    if (!this.processTabularData(spectrum, lst)) {
                        throw new JSVException("Unable to read JDX file");
                    }
                    this.addSpectrum(spectrum, false);
                    spectrum = null;
                    continue;
                }
                if (string.equals("##DATATYPE") && string2.toUpperCase().equals("LINK")) {
                    this.getBlockSpectra(lst);
                    spectrum = null;
                    continue;
                }
                if (string.equals("##NTUPLES") || string.equals("##VARNAME")) {
                    this.getNTupleSpectra(lst, spectrum, string);
                    spectrum = null;
                    continue;
                }
                if (spectrum == null) {
                    spectrum = new Spectrum();
                }
                if (this.readDataLabel(spectrum, string, string2, this.errorLog, this.obscure)) continue;
                JDXReader.addHeader(lst, this.t.rawLabel, string2);
                if (!this.checkCustomTags(spectrum, string, string2)) continue;
            }
        }
        if (!bl) {
            throw new JSVException("##TITLE record not found");
        }
        this.source.setErrorLog(this.errorLog.toString());
        return this.source;
    }

    private String getValue(String string) {
        String string2 = this.isTabularDataLabel(string) ? "" : this.t.getValue();
        return "##END".equals(string) ? null : string2;
    }

    private boolean isTabularDataLabel(String string) {
        this.isTabularData = "##DATATABLE##PEAKTABLE##XYDATA##XYPOINTS#".indexOf(string + "#") >= 0;
        return this.isTabularData;
    }

    private boolean addSpectrum(Spectrum spectrum, boolean bl) {
        if (!this.loadImaginary && spectrum.isImaginary()) {
            Logger.info("FileReader skipping imaginary spectrum -- use LOADIMAGINARY TRUE to load this spectrum.");
            return true;
        }
        if (this.acdAssignments != null) {
            if (!spectrum.dataType.equals("MASS SPECTRUM") && !spectrum.isContinuous()) {
                Logger.info("Skipping ACD Labs line spectrum for " + spectrum);
                return true;
            }
            if (this.acdAssignments.size() > 0) {
                try {
                    this.mpr.setACDAssignments(spectrum.title, spectrum.getTypeLabel(), this.source.peakCount, this.acdAssignments, this.acdMolFile);
                }
                catch (Exception exception) {
                    Logger.info("Failed to create peak data: " + exception);
                }
            }
            if (this.acdMolFile != null) {
                JSVFileManager.htCorrelationCache.put("mol", this.acdMolFile);
            }
        }
        if (!Float.isNaN(this.nmrMaxY)) {
            spectrum.doNormalize(this.nmrMaxY);
        } else if (spectrum.getMaxY() >= 10000.0) {
            spectrum.doNormalize(1000.0);
        }
        if (this.isSimulation) {
            spectrum.setSimulated(this.filePath);
        }
        ++this.nSpec;
        if (this.firstSpec > 0 && this.nSpec < this.firstSpec) {
            return true;
        }
        if (this.lastSpec > 0 && this.nSpec > this.lastSpec) {
            this.done = true;
            return !true;
        }
        spectrum.setBlockID(this.blockID);
        this.source.addJDXSpectrum(null, spectrum, bl);
        return true;
    }

    private JDXSource getBlockSpectra(Lst<String[]> lst) throws JSVException {
        Logger.debug("--JDX block start--");
        String string = "";
        String string2 = null;
        boolean bl = this.source.type == 0;
        boolean bl2 = false;
        while ((string = this.t.getLabel()) != null && !string.equals("##TITLE")) {
            int n;
            string2 = this.getValue(string);
            if (bl && !JDXReader.readHeaderLabel(this.source, string, string2, this.errorLog, this.obscure)) {
                JDXReader.addHeader(lst, this.t.rawLabel, string2);
            }
            if (!string.equals("##BLOCKS") || (n = PT.parseInt(string2)) <= 100 || this.firstSpec > 0) continue;
            bl2 = true;
        }
        string2 = this.getValue(string);
        if (!"##TITLE".equals(string)) {
            throw new JSVException("Unable to read block source");
        }
        if (bl) {
            this.source.setHeaderTable(lst);
        }
        this.source.type = 1;
        this.source.isCompoundSource = true;
        Spectrum spectrum = new Spectrum();
        Lst<Object> lst2 = new Lst<String[]>();
        this.readDataLabel(spectrum, string, string2, this.errorLog, this.obscure);
        try {
            String string3;
            while ((string3 = this.t.getLabel()) != null) {
                string2 = this.getValue(string3);
                if (string2 == null && "##END".equals(string)) {
                    Logger.debug("##END= " + this.t.getValue());
                } else {
                    string = string3;
                    if (this.isTabularData) {
                        this.setTabularDataType(spectrum, string);
                        if (this.processTabularData(spectrum, lst2)) continue;
                        throw new JSVException("Unable to read Block Source");
                    }
                    if (string.equals("##DATATYPE") && string2.toUpperCase().equals("LINK")) {
                        this.getBlockSpectra(lst2);
                        spectrum = null;
                        string = null;
                    } else if (string.equals("##NTUPLES") || string.equals("##VARNAME")) {
                        this.getNTupleSpectra(lst2, spectrum, string);
                        spectrum = null;
                        string = "";
                    }
                    if (!this.done) {
                        if (spectrum == null) {
                            spectrum = new Spectrum();
                            lst2 = new Lst();
                            if (string == "") continue;
                            if (string == null) {
                                string = "##END";
                                continue;
                            }
                        }
                        if (string2 == null) {
                            if (spectrum.getXYCoords().length > 0 && !this.addSpectrum(spectrum, bl2)) {
                                return this.source;
                            }
                            spectrum = new Spectrum();
                            lst2 = new Lst();
                            continue;
                        }
                        if (this.readDataLabel(spectrum, string, string2, this.errorLog, this.obscure)) continue;
                        JDXReader.addHeader(lst2, this.t.rawLabel, string2);
                        if (!this.checkCustomTags(spectrum, string, string2)) continue;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new JSVException(exception.getMessage());
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.debug("--JDX block end--");
        return this.source;
    }

    private void addErrorLogSeparator() {
        if (this.errorLog.length() > 0 && this.errorLog.lastIndexOf(ERROR_SEPARATOR) != this.errorLog.length() - ERROR_SEPARATOR.length()) {
            this.errorLog.append(ERROR_SEPARATOR);
        }
    }

    private JDXSource getNTupleSpectra(Lst<String[]> lst, JDXDataObject jDXDataObject, String string) throws JSVException {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        double[] dArray = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        this.blockID = Math.random();
        boolean bl3 = true;
        if (this.firstSpec > 0) {
            jDXDataObject.numDim = 1;
        }
        if (!(bl2 = string.equals("##VARNAME"))) {
            string = "";
        }
        Hashtable<String, Lst<String>> hashtable = new Hashtable<String, Lst<String>>();
        String[] stringArray = new String[2];
        boolean bl4 = bl = this.source.type == 0;
        if (bl) {
            this.source.type = 2;
            this.source.isCompoundSource = true;
            this.source.setHeaderTable(lst);
        }
        while (!(string = bl2 ? string : this.t.getLabel()).equals("##PAGE")) {
            bl2 = false;
            object2 = new StringTokenizer(this.t.getValue(), ",");
            object = new Lst();
            while (((StringTokenizer)object2).hasMoreTokens()) {
                ((Lst)object).addLast(((StringTokenizer)object2).nextToken().trim());
            }
            hashtable.put(string, (Lst<String>)object);
        }
        object2 = (Lst)hashtable.get("##SYMBOL");
        if (!string.equals("##PAGE")) {
            throw new JSVException("Error Reading NTuple Source");
        }
        object = this.t.getValue();
        Spectrum spectrum = null;
        boolean bl5 = true;
        while (!this.done) {
            String[] stringArray2;
            int n;
            string = this.t.getLabel();
            if (string.equals("##ENDNTUPLES")) {
                this.t.getValue();
                break;
            }
            if (string.equals("##PAGE")) {
                object = this.t.getValue();
                continue;
            }
            if (spectrum == null) {
                int n2;
                spectrum = new Spectrum();
                jDXDataObject.copyTo(spectrum);
                spectrum.setTitle(jDXDataObject.getTitle());
                if (!spectrum.is1D() && (n2 = ((String)object).indexOf(61)) >= 0) {
                    try {
                        spectrum.setY2D(Double.parseDouble(((String)object).substring(n2 + 1).trim()));
                        String string2 = ((String)object).substring(0, n2).trim();
                        int n3 = ((ArrayList)object2).indexOf(string2);
                        if (n3 >= 0) {
                            spectrum.setY2DUnits((String)((Lst)hashtable.get("##UNITS")).get(n3));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            Lst<String[]> lst2 = new Lst<String[]>();
            spectrum.setHeaderTable(lst2);
            while (!string.equals("##DATATABLE")) {
                JDXReader.addHeader(lst2, this.t.rawLabel, this.t.getValue());
                string = this.t.getLabel();
            }
            boolean bl6 = true;
            String string3 = this.t.flushLine();
            if (string3.trim().indexOf("PEAKS") > 0) {
                bl6 = false;
            }
            int n4 = string3.indexOf(40);
            int n5 = string3.lastIndexOf(41);
            if (n4 == -1 || n5 == -1) {
                throw new JSVException("Variable List not Found");
            }
            String string4 = string3.substring(n4, n5 + 1);
            int n6 = 0;
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                stringArray2 = ((String)((ArrayList)object2).get(n)).trim();
                if (string4.indexOf((String)stringArray2) != -1) {
                    stringArray[n6++] = stringArray2;
                }
                if (n6 == 2) break;
            }
            this.setTabularDataType(spectrum, "##" + (bl6 ? "XYDATA" : "PEAKTABLE"));
            if (!this.readNTUPLECoords(spectrum, hashtable, stringArray, dArray)) {
                throw new JSVException("Unable to read Ntuple Source");
            }
            if (!spectrum.nucleusX.equals("?")) {
                jDXDataObject.nucleusX = spectrum.nucleusX;
            }
            jDXDataObject.nucleusY = spectrum.nucleusY;
            jDXDataObject.freq2dX = spectrum.freq2dX;
            jDXDataObject.freq2dY = spectrum.freq2dY;
            jDXDataObject.y2DUnits = spectrum.y2DUnits;
            for (n = 0; n < lst.size(); ++n) {
                stringArray2 = (String[])lst.get(n);
                String string5 = JDXSourceStreamTokenizer.cleanLabel(stringArray2[0]);
                if (string5.equals("##TITLE") || string5.equals("##DATACLASS") || string5.equals("##NTUPLES")) continue;
                lst2.addLast(stringArray2);
            }
            if (bl3) {
                this.addSpectrum(spectrum, !bl5);
            }
            bl5 = false;
            spectrum = null;
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.info("NTUPLE MIN/MAX Y = " + dArray[0] + " " + dArray[1]);
        return this.source;
    }

    private boolean readDataLabel(JDXDataObject jDXDataObject, String string, String string2, SB sB, boolean bl) {
        if (JDXReader.readHeaderLabel(jDXDataObject, string, string2, sB, bl)) {
            return true;
        }
        if ("##MINX ##MINY ##MAXX ##MAXY ##FIRSTY ##DELTAX ##DATACLASS ".indexOf(string = string + " ") >= 0) {
            return true;
        }
        switch ("##FIRSTX  ##LASTX   ##NPOINTS ##XFACTOR ##YFACTOR ##XUNITS  ##YUNITS  ##XLABEL  ##YLABEL  ##NUMDIM  ##OFFSET  ".indexOf(string)) {
            case 0: {
                jDXDataObject.fileFirstX = Double.parseDouble(string2);
                return true;
            }
            case 10: {
                jDXDataObject.fileLastX = Double.parseDouble(string2);
                return true;
            }
            case 20: {
                jDXDataObject.nPointsFile = Integer.parseInt(string2);
                return true;
            }
            case 30: {
                jDXDataObject.xFactor = Double.parseDouble(string2);
                return true;
            }
            case 40: {
                jDXDataObject.yFactor = Double.parseDouble(string2);
                return true;
            }
            case 50: {
                jDXDataObject.setXUnits(string2);
                return true;
            }
            case 60: {
                jDXDataObject.setYUnits(string2);
                return true;
            }
            case 70: {
                jDXDataObject.setXLabel(string2);
                return false;
            }
            case 80: {
                jDXDataObject.setYLabel(string2);
                return false;
            }
            case 90: {
                jDXDataObject.numDim = Integer.parseInt(string2);
                return true;
            }
            case 100: {
                if (jDXDataObject.shiftRefType != 0) {
                    if (jDXDataObject.offset == Double.MAX_VALUE) {
                        jDXDataObject.offset = Double.parseDouble(string2);
                    }
                    jDXDataObject.dataPointNum = 1;
                    jDXDataObject.shiftRefType = 1;
                }
                return false;
            }
        }
        if (string.length() < 17) {
            return false;
        }
        if (string.equals("##.OBSERVEFREQUENCY ")) {
            jDXDataObject.observedFreq = Double.parseDouble(string2);
            return true;
        }
        if (string.equals("##.OBSERVENUCLEUS ")) {
            jDXDataObject.setObservedNucleus(string2);
            return true;
        }
        if (string.equals("##$REFERENCEPOINT ") && jDXDataObject.shiftRefType != 0) {
            jDXDataObject.offset = Double.parseDouble(string2);
            jDXDataObject.dataPointNum = 1;
            jDXDataObject.shiftRefType = 2;
            return false;
        }
        if (string.equals("##.SHIFTREFERENCE ")) {
            if (!jDXDataObject.dataType.toUpperCase().contains("SPECTRUM")) {
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (stringTokenizer.countTokens() != 4) {
                return true;
            }
            try {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                jDXDataObject.dataPointNum = Integer.parseInt(stringTokenizer.nextToken().trim());
                jDXDataObject.offset = Double.parseDouble(stringTokenizer.nextToken().trim());
            }
            catch (Exception exception) {
                return true;
            }
            if (jDXDataObject.dataPointNum <= 0) {
                jDXDataObject.dataPointNum = 1;
            }
            jDXDataObject.shiftRefType = 0;
            return true;
        }
        return false;
    }

    private static boolean readHeaderLabel(JDXHeader jDXHeader, String string, String string2, SB sB, boolean bl) {
        switch ("##TITLE#####JCAMPDX###ORIGIN####OWNER#####DATATYPE##LONGDATE##DATE######TIME####".indexOf(string + "#")) {
            case 0: {
                jDXHeader.setTitle(bl || string2 == null || string2.equals("") ? "Unknown" : string2);
                return true;
            }
            case 10: {
                jDXHeader.jcampdx = string2;
                float f = PT.parseFloat(string2);
                if (((double)f >= 6.0 || Float.isNaN(f)) && sB != null) {
                    sB.append("Warning: JCAMP-DX version may not be fully supported: " + string2 + "\n");
                }
                return true;
            }
            case 20: {
                jDXHeader.origin = string2 != null && !string2.equals("") ? string2 : "Unknown";
                return true;
            }
            case 30: {
                jDXHeader.owner = string2 != null && !string2.equals("") ? string2 : "Unknown";
                return true;
            }
            case 40: {
                jDXHeader.dataType = string2;
                return true;
            }
            case 50: {
                jDXHeader.longDate = string2;
                return true;
            }
            case 60: {
                jDXHeader.date = string2;
                return true;
            }
            case 70: {
                jDXHeader.time = string2;
                return true;
            }
        }
        return false;
    }

    private void setTabularDataType(JDXDataObject jDXDataObject, String string) {
        if (string.equals("##PEAKASSIGNMENTS")) {
            jDXDataObject.setDataClass("PEAKASSIGNMENTS");
        } else if (string.equals("##PEAKTABLE")) {
            jDXDataObject.setDataClass("PEAKTABLE");
        } else if (string.equals("##XYDATA")) {
            jDXDataObject.setDataClass("XYDATA");
        } else if (string.equals("##XYPOINTS")) {
            jDXDataObject.setDataClass("XYPOINTS");
        }
    }

    private boolean processTabularData(JDXDataObject jDXDataObject, Lst<String[]> lst) throws JSVException {
        jDXDataObject.setHeaderTable(lst);
        if (jDXDataObject.dataClass.equals("XYDATA")) {
            jDXDataObject.checkRequiredTokens();
            this.decompressData(jDXDataObject, null);
            return true;
        }
        if (jDXDataObject.dataClass.equals("PEAKTABLE") || jDXDataObject.dataClass.equals("XYPOINTS")) {
            jDXDataObject.setContinuous(jDXDataObject.dataClass.equals("XYPOINTS"));
            try {
                this.t.readLineTrimmed();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Coordinate[] coordinateArray = jDXDataObject.xFactor != Double.MAX_VALUE && jDXDataObject.yFactor != Double.MAX_VALUE ? Coordinate.parseDSV(this.t.getValue(), jDXDataObject.xFactor, jDXDataObject.yFactor) : Coordinate.parseDSV(this.t.getValue(), 1.0, 1.0);
            jDXDataObject.setXYCoords(coordinateArray);
            double d = Coordinate.deltaX(coordinateArray[coordinateArray.length - 1].getXVal(), coordinateArray[0].getXVal(), coordinateArray.length);
            jDXDataObject.setIncreasing(d > 0.0);
            return true;
        }
        return false;
    }

    private boolean readNTUPLECoords(JDXDataObject jDXDataObject, Map<String, Lst<String>> map, String[] stringArray, double[] dArray) {
        if (jDXDataObject.dataClass.equals("XYDATA")) {
            Lst<String> lst = map.get("##SYMBOL");
            int n = lst.indexOf(stringArray[0]);
            int n2 = lst.indexOf(stringArray[1]);
            lst = map.get("##VARNAME");
            jDXDataObject.varName = ((String)lst.get(n2)).toUpperCase();
            lst = map.get("##FACTOR");
            jDXDataObject.xFactor = Double.parseDouble((String)lst.get(n));
            jDXDataObject.yFactor = Double.parseDouble((String)lst.get(n2));
            lst = map.get("##LAST");
            jDXDataObject.fileLastX = Double.parseDouble((String)lst.get(n));
            lst = map.get("##FIRST");
            jDXDataObject.fileFirstX = Double.parseDouble((String)lst.get(n));
            lst = map.get("##VARDIM");
            jDXDataObject.nPointsFile = Integer.parseInt((String)lst.get(n));
            lst = map.get("##UNITS");
            jDXDataObject.setXUnits((String)lst.get(n));
            jDXDataObject.setYUnits((String)lst.get(n2));
            if (jDXDataObject.nucleusX == null && (lst = map.get("##.NUCLEUS")) != null) {
                jDXDataObject.setNucleusAndFreq((String)lst.get(0), false);
                jDXDataObject.setNucleusAndFreq((String)lst.get(n), true);
            } else if (jDXDataObject.nucleusX == null) {
                jDXDataObject.nucleusX = "?";
            }
            this.decompressData(jDXDataObject, dArray);
            return true;
        }
        if (jDXDataObject.dataClass.equals("PEAKTABLE") || jDXDataObject.dataClass.equals("XYPOINTS")) {
            jDXDataObject.setContinuous(jDXDataObject.dataClass.equals("XYPOINTS"));
            Lst<String> lst = map.get("##SYMBOL");
            int n = lst.indexOf(stringArray[0]);
            int n3 = lst.indexOf(stringArray[1]);
            lst = map.get("##UNITS");
            jDXDataObject.setXUnits((String)lst.get(n));
            jDXDataObject.setYUnits((String)lst.get(n3));
            jDXDataObject.setXYCoords(Coordinate.parseDSV(this.t.getValue(), jDXDataObject.xFactor, jDXDataObject.yFactor));
            return true;
        }
        return false;
    }

    private void decompressData(JDXDataObject jDXDataObject, double[] dArray) {
        double d;
        int n = this.errorLog.length();
        double d2 = Coordinate.deltaX(jDXDataObject.fileLastX, jDXDataObject.fileFirstX, jDXDataObject.nPointsFile);
        jDXDataObject.setIncreasing(d2 > 0.0);
        jDXDataObject.setContinuous(true);
        JDXDecompressor jDXDecompressor = new JDXDecompressor(this.t, jDXDataObject.fileFirstX, jDXDataObject.xFactor, jDXDataObject.yFactor, d2, jDXDataObject.nPointsFile);
        double[] dArray2 = new double[2];
        long l = System.currentTimeMillis();
        Coordinate[] coordinateArray = jDXDecompressor.decompressData(this.errorLog, dArray2);
        if (Logger.debugging) {
            Logger.debug("decompression time = " + (System.currentTimeMillis() - l) + " ms");
        }
        jDXDataObject.setXYCoords(coordinateArray);
        double d3 = jDXDecompressor.getMinY();
        if (dArray != null) {
            if (d3 < dArray[0]) {
                dArray[0] = d3;
            }
            if ((d3 = jDXDecompressor.getMaxY()) > dArray[1]) {
                dArray[1] = d3;
            }
        }
        double d4 = d = Double.isNaN(jDXDataObject.freq2dX) ? jDXDataObject.observedFreq : jDXDataObject.freq2dX;
        if (jDXDataObject.offset != Double.MAX_VALUE && d != Double.MAX_VALUE && jDXDataObject.dataType.toUpperCase().contains("SPECTRUM")) {
            Coordinate.applyShiftReference(coordinateArray, jDXDataObject.dataPointNum, jDXDataObject.fileFirstX, jDXDataObject.fileLastX, jDXDataObject.offset, d, jDXDataObject.shiftRefType);
        }
        if (d != Double.MAX_VALUE && jDXDataObject.getXUnits().toUpperCase().equals("HZ")) {
            double d5 = d;
            Coordinate.applyScale(coordinateArray, 1.0 / d5, 1.0);
            jDXDataObject.setXUnits("PPM");
            jDXDataObject.setHZtoPPM(true);
        }
        if (this.errorLog.length() != n) {
            this.errorLog.append(jDXDataObject.getTitle()).append("\n");
            this.errorLog.append("firstX: " + jDXDataObject.fileFirstX + " Found " + dArray2[0] + "\n");
            this.errorLog.append("lastX from Header " + jDXDataObject.fileLastX + " Found " + dArray2[1] + "\n");
            this.errorLog.append("deltaX from Header " + d2 + "\n");
            this.errorLog.append("Number of points in Header " + jDXDataObject.nPointsFile + " Found " + coordinateArray.length + "\n");
        }
        if (Logger.debugging) {
            System.err.println(this.errorLog.toString());
        }
    }

    public static void addHeader(Lst<String[]> lst, String string, String string2) {
        for (int i = 0; i < lst.size(); ++i) {
            String[] stringArray = (String[])lst.get(i);
            if (!stringArray[0].equals(string)) continue;
            stringArray[1] = string2;
            return;
        }
        lst.addLast(new String[]{string, string2, JDXSourceStreamTokenizer.cleanLabel(string)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCustomTags(Spectrum spectrum, String string, String string2) throws JSVException {
        if (string.length() > 10) {
            string = string.substring(0, 10);
        }
        if (spectrum == null) {
            System.out.println(string);
        } else {
            this.modelSpectrum = spectrum;
        }
        int n = "##$MODELS ##$PEAKS  ##$SIGNALS##$MOLFILE##PEAKASSI##$UVIRASS##$MSFRAGM".indexOf(string);
        if (n < 0) {
            return false;
        }
        this.getMpr().set(this, this.filePath, null);
        try {
            this.reader = new BufferedReader(new StringReader(string2));
            switch (n) {
                case 0: {
                    this.mpr.readModels();
                    return true;
                }
                case 10: 
                case 20: {
                    this.peakData = new Lst();
                    this.source.peakCount = this.source.peakCount + this.mpr.readPeaks(n == 20, this.source.peakCount);
                    return true;
                }
                case 30: {
                    this.acdAssignments = new Lst();
                    this.acdMolFile = PT.rep(string2, "$$ Empty String", "");
                    return true;
                }
                case 40: 
                case 50: 
                case 60: {
                    this.acdAssignments = this.mpr.readACDAssignments(spectrum.nPointsFile, n == 40);
                    return true;
                }
            }
            return true;
        }
        catch (Exception exception) {
            throw new JSVException(exception.getMessage());
        }
        finally {
            this.reader = null;
        }
    }

    private JmolJDXMOLParser getMpr() {
        return this.mpr == null ? (this.mpr = (JmolJDXMOLParser)JSViewer.getInterface("org.jmol.jsv.JDXMOLParser")) : this.mpr;
    }

    @Override
    public String rd() throws Exception {
        return this.reader.readLine();
    }

    @Override
    public void setSpectrumPeaks(int n, String string, String string2) {
        this.modelSpectrum.setPeakList(this.peakData, string, string2);
        if (this.modelSpectrum.isNMR()) {
            this.modelSpectrum.setNHydrogens(n);
        }
    }

    @Override
    public void addPeakData(String string) {
        if (this.peakData == null) {
            this.peakData = new Lst();
        }
        this.peakData.addLast(new PeakInfo(string));
    }

    @Override
    public void processModelData(String string, String string2, String string3, String string4, String string5, float f, float f2, boolean bl) throws Exception {
    }

    @Override
    public String discardLinesUntilContains(String string) throws Exception {
        String string2;
        while ((string2 = this.rd()) != null && string2.indexOf(string) < 0) {
        }
        return string2;
    }

    @Override
    public String discardLinesUntilContains2(String string, String string2) throws Exception {
        String string3;
        while ((string3 = this.rd()) != null && string3.indexOf(string) < 0 && string3.indexOf(string2) < 0) {
        }
        return string3;
    }

    @Override
    public String discardLinesUntilNonBlank() throws Exception {
        String string;
        while ((string = this.rd()) != null && string.trim().length() == 0) {
        }
        return string;
    }
}

