/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.quantum.QS;
import org.jmol.util.Logger;

public class GenNBOReader
extends MOReader {
    private boolean isOutputFile;
    private String nboType = "";
    private int nOrbitals0;
    private boolean isArchive;
    private static String P_LIST = "101   102   103";
    private static String SP_LIST = "1     101   102   103";
    private static String DS_LIST = "255   252   253   254   251";
    private static String DC_LIST = "201   204   206   202   203   205";
    private static String FS_LIST = "351   352   353   354   355   356   357";
    private static String FC_LIST = "301   307   310   304   302   303   306   309   308   305";

    @Override
    protected void initializeReader() throws Exception {
        boolean bl;
        String string = this.rd().trim();
        boolean bl2 = this.isArchive = string.indexOf("$GENNBO") >= 0 || string.indexOf("$NBO") >= 0;
        if (this.isArchive) {
            this.readData47();
            return;
        }
        String string2 = this.rd();
        this.line = string + string2;
        boolean bl3 = this.isOutputFile = string2.indexOf("****") >= 0;
        if (this.isOutputFile) {
            bl = this.getFile31();
            super.initializeReader();
            this.moData.put("isNormalized", Boolean.TRUE);
        } else if (string2.indexOf("s in the AO basis:") >= 0) {
            this.nboType = string2.substring(1, string2.indexOf("s"));
            this.asc.setCollectionName(string + ": " + this.nboType + "s");
            bl = this.getFile31();
        } else {
            this.nboType = "AO";
            this.asc.setCollectionName(string + ": " + this.nboType + "s");
            bl = this.readData31(string);
        }
        if (!bl) {
            Logger.error((String)("Unimplemented shell type -- no orbitals avaliable: " + this.line));
        }
        if (this.isOutputFile) {
            return;
        }
        if (bl) {
            this.readMOs();
        }
        this.continuing = false;
    }

    protected void finalizeSubclassReader() throws Exception {
        this.appendLoadNote("NBO type " + this.nboType);
        this.finalizeReaderASCR();
    }

    private void readMOs() throws Exception {
        Object object;
        this.nOrbitals0 = this.orbitals.size();
        this.getFile46();
        boolean bl = !this.nboType.equals("AO");
        int n = this.nOrbitals;
        this.nOrbitals = this.orbitals.size();
        this.line = null;
        for (int i = this.nOrbitals0; i < this.nOrbitals; ++i) {
            Map map = (Map)this.orbitals.get(i);
            object = new float[n];
            map.put("coefficients", object);
            if (bl) {
                if (this.line == null) {
                    while (this.rd() != null && Float.isNaN(this.parseFloatStr(this.line))) {
                    }
                } else {
                    this.line = null;
                }
                this.fillFloatArray(this.line, 0, (float[])object);
                this.line = null;
                continue;
            }
            object[i] = 1.0f;
        }
        if (this.nboType.equals("NBO")) {
            float[] fArray = new float[this.nOrbitals - this.nOrbitals0];
            this.fillFloatArray(null, 0, fArray);
            for (int i = this.nOrbitals0; i < this.nOrbitals; ++i) {
                object = (Map)this.orbitals.get(i);
                object.put("occupancy", Float.valueOf(fArray[i - this.nOrbitals0]));
            }
        }
        this.moData.put(this.nboType + "_coefs", this.orbitals);
        this.setMOData(false);
        this.moData.put("isNormalized", Boolean.TRUE);
        this.moData.put("nboType", this.nboType);
        Logger.info((String)(this.orbitals.size() - this.nOrbitals0 + " orbitals read"));
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("SECOND ORDER PERTURBATION THEORY ANALYSIS") >= 0 && !this.orbitalsRead) {
            this.nboType = "NBO";
            String string = this.getFileData(".37");
            if (string == null) {
                return true;
            }
            BufferedReader bufferedReader = this.reader;
            this.reader = Rdr.getBR((String)string);
            this.rd();
            this.rd();
            this.readMOs();
            this.reader = bufferedReader;
            this.orbitalsRead = false;
            return true;
        }
        return this.checkNboLine();
    }

    private String getFileData(String string) throws Exception {
        String string2 = (String)this.htParams.get("fullPathName");
        int n = string2.lastIndexOf(".");
        if (n < 0) {
            n = string2.length();
        }
        string2 = string2.substring(0, n);
        this.moData.put("nboRoot", string2);
        string2 = string2 + string;
        String string3 = this.vwr.getFileAsString3(string2, false, null);
        Logger.info((String)(string3.length() + " bytes read from " + string2));
        if (string3.length() == 0 || string3.indexOf("java.io.FileNotFound") >= 0) {
            throw new Exception(" supplemental file " + string2 + " was not found");
        }
        return string3;
    }

    private boolean getFile31() throws Exception {
        String string = this.getFileData(".31");
        BufferedReader bufferedReader = this.reader;
        this.reader = Rdr.getBR((String)string);
        return this.readData31(null) && (this.reader = bufferedReader) != null;
    }

    private void getFile46() throws Exception {
        String string = this.getFileData(".46");
        BufferedReader bufferedReader = this.reader;
        this.reader = Rdr.getBR((String)string);
        this.readData46();
        this.reader = bufferedReader;
    }

    private void readData47() throws Exception {
        int n;
        Object[] objectArray;
        this.allowNoOrbitals = true;
        this.discardLinesUntilContains("$COORD");
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.rd().trim());
        while (this.rd().indexOf("$END") < 0) {
            objectArray = this.getTokens();
            this.addAtomXYZSymName((String[])objectArray, (int)2, null, null).elementNumber = (short)this.parseIntStr(objectArray[0]);
        }
        this.discardLinesUntilContains("$BASIS");
        objectArray = this.getIntData();
        int[] nArray = this.getIntData();
        this.discardLinesUntilContains("NSHELL =");
        this.shellCount = this.parseIntAt(this.line, 10);
        this.gaussianCount = this.parseIntAt(this.rd(), 10);
        this.rd();
        int[] nArray2 = this.getIntData();
        int[] nArray3 = this.getIntData();
        int[] nArray4 = this.getIntData();
        this.shells = new Lst();
        this.gaussians = AU.newFloat2((int)this.gaussianCount);
        for (n = 0; n < this.gaussianCount; ++n) {
            this.gaussians[n] = new float[6];
        }
        this.nOrbitals = 0;
        n = 0;
        String string = this.line;
        for (int i = 0; i < this.shellCount; ++i) {
            int[] nArray5 = new int[4];
            int n2 = nArray2[i];
            nArray5[0] = (int)(objectArray[n] - true);
            this.line = "";
            for (int j = 0; j < n2; ++j) {
                this.line = this.line + nArray[n++] + " ";
            }
            if (this.fillSlater(nArray5, n2, nArray4[i] - 1, nArray3[i])) continue;
            return;
        }
        this.line = string;
        this.getAlphasAndExponents();
        this.nboType = "AO";
        this.readMOs();
        this.continuing = false;
    }

    private int[] getIntData() throws Exception {
        while (this.line.indexOf("=") < 0) {
            this.rd();
        }
        String string = this.line.substring(this.line.indexOf("=") + 1);
        this.line = "";
        while (this.rd().indexOf("=") < 0 && this.line.indexOf("$") < 0) {
            string = string + this.line;
        }
        String[] stringArray = PT.getTokens((String)string);
        int[] nArray = new int[stringArray.length];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = this.parseIntStr(stringArray[n]);
        }
        return nArray;
    }

    private boolean fillSlater(int[] nArray, int n, int n2, int n3) {
        this.nOrbitals += n;
        switch (n) {
            case 1: {
                nArray[1] = 0;
                break;
            }
            case 3: {
                if (!this.getDFMap(this.line, 1, P_LIST, 3)) {
                    return false;
                }
                nArray[1] = 1;
                break;
            }
            case 4: {
                if (!this.getDFMap(this.line, 2, SP_LIST, 1)) {
                    return false;
                }
                nArray[1] = 2;
                break;
            }
            case 5: {
                if (!this.getDFMap(this.line, 3, DS_LIST, 3)) {
                    return false;
                }
                nArray[1] = 3;
                break;
            }
            case 6: {
                if (!this.getDFMap(this.line, 4, DC_LIST, 3)) {
                    return false;
                }
                nArray[1] = 4;
                break;
            }
            case 7: {
                if (!this.getDFMap(this.line, 5, FS_LIST, 3)) {
                    return false;
                }
                nArray[1] = 5;
                break;
            }
            case 10: {
                if (!this.getDFMap(this.line, 6, FC_LIST, 3)) {
                    return false;
                }
                nArray[1] = 6;
            }
        }
        nArray[2] = n2;
        nArray[3] = n3;
        this.shells.addLast((Object)nArray);
        return true;
    }

    private void getAlphasAndExponents() throws Exception {
        int n;
        for (n = 0; n < 5; ++n) {
            if (this.line.indexOf("=") < 0) {
                this.rd();
            }
            if (this.line.indexOf("$END") >= 0) break;
            this.line = this.line.substring(this.line.indexOf("=") + 1);
            float[] fArray = this.fillFloatArray(this.line, 0, new float[this.gaussianCount]);
            for (int i = 0; i < this.gaussianCount; ++i) {
                this.gaussians[i][n] = fArray[i];
                if (n <= 1) continue;
                float[] fArray2 = this.gaussians[i];
                fArray2[5] = fArray2[5] + fArray[i];
            }
        }
        for (n = 0; n < this.gaussianCount; ++n) {
            if (this.gaussians[n][1] != 0.0f) continue;
            this.gaussians[n][1] = this.gaussians[n][5];
        }
        if (Logger.debugging) {
            Logger.debug((String)(this.shells.size() + " slater shells read"));
            Logger.debug((String)(this.gaussians.length + " gaussian primitives read"));
        }
    }

    private boolean readData31(String string) throws Exception {
        int n;
        if (string == null) {
            string = this.rd();
            this.rd();
        }
        this.rd();
        String[] stringArray = PT.getTokens((String)this.rd());
        int n2 = this.parseIntStr(stringArray[0]);
        this.shellCount = this.parseIntStr(stringArray[1]);
        this.gaussianCount = this.parseIntStr(stringArray[2]);
        this.rd();
        this.asc.newAtomSet();
        this.asc.setAtomSetName(this.nboType + "s: " + string.trim());
        this.asc.setCurrentModelInfo("nboType", (Object)this.nboType);
        for (n = 0; n < n2; ++n) {
            stringArray = PT.getTokens((String)this.rd());
            int n3 = this.parseIntStr(stringArray[0]);
            if (n3 < 0) continue;
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)n3;
            this.setAtomCoordTokens(atom, stringArray, 1);
        }
        this.shells = new Lst();
        this.gaussians = AU.newFloat2((int)this.gaussianCount);
        for (n = 0; n < this.gaussianCount; ++n) {
            this.gaussians[n] = new float[6];
        }
        this.rd();
        this.nOrbitals = 0;
        for (n = 0; n < this.shellCount; ++n) {
            stringArray = PT.getTokens((String)this.rd());
            int[] nArray = new int[4];
            nArray[0] = this.parseIntStr(stringArray[0]) - 1;
            int n4 = this.parseIntStr(stringArray[1]);
            int n5 = this.parseIntStr(stringArray[2]) - 1;
            int n6 = this.parseIntStr(stringArray[3]);
            this.line = this.rd().trim();
            if (this.fillSlater(nArray, n4, n5, n6)) continue;
            return false;
        }
        this.rd();
        this.getAlphasAndExponents();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readData46() throws Exception {
        int n;
        String[] stringArray = PT.getTokens((String)this.rd());
        int n2 = 1;
        if (stringArray[1].equals("ALPHA")) {
            n2 = 2;
            if (this.haveNboOrbitals) {
                stringArray = PT.getTokens((String)this.discardLinesUntilContains("BETA"));
                this.alphaBeta = "beta";
            } else {
                this.alphaBeta = "alpha";
                this.haveNboOrbitals = true;
            }
            this.line = stringArray[0] + " " + stringArray[2];
        }
        if (this.parseIntStr(stringArray[n2]) != this.nOrbitals) {
            Logger.error((String)("file 46 number of orbitals does not match nOrbitals: " + this.nOrbitals));
            return;
        }
        SB sB = new SB();
        sB.append(this.line);
        while (this.rd() != null && this.line.indexOf("ALPHA") < 0 && this.line.indexOf("BETA") < 0) {
            sB.append(this.line);
        }
        sB.appendC(' ');
        String string = PT.rep((String)sB.toString(), (String)" )", (String)")");
        int n3 = string.length() - 1;
        sB = new SB();
        block5: for (n = 0; n < n3; ++n) {
            char c = string.charAt(n);
            switch (c) {
                case '(': 
                case '-': {
                    if (string.charAt(n + 1) != ' ') break;
                    ++n;
                    break;
                }
                case ' ': {
                    if (PT.isDigit((char)string.charAt(n + 1)) || string.charAt(n + 1) == '(') continue block5;
                }
            }
            sB.appendC(c);
        }
        stringArray = PT.getTokens((String)sB.toString());
        this.moData.put("nboLabels", stringArray);
        n = 0;
        while (true) {
            if (n >= this.nOrbitals) {
                new QS().setNboLabels(stringArray, this.nOrbitals, (Lst<Map<String, Object>>)this.orbitals, this.nOrbitals0, this.nboType);
                return;
            }
            this.setMO(new Hashtable<String, Object>());
            ++n;
        }
    }
}

