/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.script.T;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Dipole;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;

public class Dipoles
extends Shape {
    static final short DEFAULT_MAD = 5;
    static final float DEFAULT_OFFSETSIDE = 0.4f;
    public int dipoleCount = 0;
    public Dipole[] dipoles = new Dipole[4];
    private Dipole currentDipole;
    private Dipole tempDipole;
    private P3 startCoord = new P3();
    private P3 endCoord = new P3();
    private float dipoleValue;
    private boolean isUserValue;
    private boolean isBond;
    private boolean iHaveTwoEnds;
    private int atomIndex1;
    private int atomIndex2;
    private short colix;
    private V3 calculatedDipole;
    private String wildID;
    private static final float E_ANG_PER_DEBYE = 0.208194f;

    public void setProperty(String string, Object object, BS bS) {
        BS bS2;
        if ("init" == string) {
            this.tempDipole = new Dipole();
            this.tempDipole.dipoleValue = 1.0f;
            this.tempDipole.mad = (short)5;
            this.atomIndex1 = -1;
            this.tempDipole.modelIndex = -1;
            this.dipoleValue = 0.0f;
            this.calculatedDipole = null;
            this.iHaveTwoEnds = false;
            this.isBond = false;
            this.isUserValue = false;
            return;
        }
        if ("calculate" == string) {
            this.calculatedDipole = this.vwr.calculateMolecularDipole((BS)object);
            Logger.info((String)("calculated molecular dipole = " + this.calculatedDipole + " " + (this.calculatedDipole == null ? "" : "" + this.calculatedDipole.length())));
            return;
        }
        if ("thisID" == string) {
            this.wildID = null;
            String string2 = (String)object;
            if (string2 == null || PT.isWild((String)string2)) {
                this.currentDipole = null;
                if (string2 != null) {
                    this.wildID = string2.toUpperCase();
                }
                return;
            }
            this.currentDipole = this.findDipole(string2);
            if (this.currentDipole == null) {
                this.currentDipole = this.allocDipole(string2, "");
            }
            this.tempDipole = this.currentDipole;
            if (string2.equals("molecular")) {
                this.getMolecular(null);
            }
            return;
        }
        if ("bonds" == string) {
            this.isBond = true;
            this.currentDipole = null;
            int n = this.dipoleCount;
            while (--n >= 0) {
                if (!this.isBondDipole(n)) continue;
                return;
            }
            this.getBondDipoles();
            return;
        }
        if ("all" == string) {
            this.tempDipole.lstDipoles = new Lst();
            return;
        }
        if ("on" == string) {
            this.setPropertyTok(0x10000D, this.isBond, 0, 0.0f);
            return;
        }
        if ("off" == string) {
            this.setPropertyTok(0x10000C, this.isBond, 0, 0.0f);
            return;
        }
        if ("delete" == string) {
            if (this.wildID == null && this.currentDipole == null) {
                this.clear(false);
                return;
            }
            this.setPropertyTok(12291, this.isBond, 0, 0.0f);
            return;
        }
        if ("width" == string) {
            short s = this.tempDipole.mad = (short)(((Float)object).floatValue() * 1000.0f);
            if (this.currentDipole == null) {
                this.setPropertyTok(659488, this.isBond, s, 0.0f);
            }
            return;
        }
        if ("offset" == string) {
            float f = this.tempDipole.offsetAngstroms = ((Float)object).floatValue();
            if (this.currentDipole == null) {
                this.setPropertyTok(1611272194, this.isBond, 0, f);
            }
            return;
        }
        if ("offsetPt" == string) {
            this.tempDipole.offsetPt = (P3)object;
            if (this.currentDipole != null) {
                this.currentDipole.setOffsetPt(this.tempDipole.offsetPt);
            }
            return;
        }
        if ("offsetPercent" == string) {
            int n = this.tempDipole.offsetPercent = ((Integer)object).intValue();
            if (this.tempDipole.dipoleValue != 0.0f) {
                this.tempDipole.offsetAngstroms = (float)n / 100.0f * this.tempDipole.dipoleValue;
            }
            if (this.currentDipole == null) {
                this.setPropertyTok(269484210, this.isBond, 0, (float)n / 100.0f);
            }
            return;
        }
        if ("offsetSide" == string) {
            float f = ((Float)object).floatValue();
            this.setPropertyTok(3145754, this.isBond, 0, f);
            return;
        }
        if ("cross" == string) {
            this.setPropertyTok(135267329, this.isBond, (Boolean)object != false ? 1 : 0, 0.0f);
            return;
        }
        if ("color" == string) {
            this.colix = C.getColixO((Object)object);
            if (this.isBond) {
                this.setColixDipole(this.colix, 1023, bS);
            } else if (object != null) {
                this.setPropertyTok(1766856708, false, 0, 0.0f);
            }
            return;
        }
        if ("translucency" == string) {
            this.setPropertyTok(603979967, this.isBond, object.equals("translucent") ? 1 : 0, 0.0f);
            return;
        }
        if ("clear" == string) {
            this.currentDipole = null;
            this.clear(false);
        }
        if ("clearBonds" == string) {
            this.clear(true);
        }
        if ("startSet" == string) {
            BS bS3 = (BS)object;
            this.endCoord = null;
            this.startCoord = this.ms.getAtomSetCenter(bS3);
            this.tempDipole.set2Value(this.startCoord, P3.new3((float)0.0f, (float)0.0f, (float)0.0f), this.dipoleValue);
            if (BSUtil.cardinalityOf((BS)bS3) == 1) {
                this.atomIndex1 = bS3.nextSetBit(0);
            }
            return;
        }
        if ("atomBitset" == string) {
            bS2 = (BS)object;
            if (bS2.cardinality() > 2) {
                this.getMolecular(bS2);
                return;
            }
            this.atomIndex1 = bS2.nextSetBit(0);
            this.startCoord = this.ms.at[this.atomIndex1];
            bS2.clear(this.atomIndex1);
            string = "endSet";
        }
        if ("endSet" == string) {
            this.iHaveTwoEnds = true;
            bS2 = (BS)object;
            if (this.atomIndex1 >= 0 && BSUtil.cardinalityOf((BS)bS2) == 1) {
                this.atomIndex2 = bS2.nextSetBit(0);
                this.tempDipole.set2AtomValue(this.ms.at[this.atomIndex1], this.ms.at[this.atomIndex2], 1.0f);
                this.currentDipole = this.findDipoleFor(this.tempDipole.thisID, this.tempDipole.dipoleInfo);
                this.tempDipole.thisID = this.currentDipole.thisID;
                if (this.isSameAtoms(this.currentDipole, this.tempDipole.dipoleInfo)) {
                    this.tempDipole = this.currentDipole;
                    if (this.dipoleValue > 0.0f) {
                        this.tempDipole.dipoleValue = this.dipoleValue;
                    }
                }
            } else {
                this.tempDipole.set2Value(this.startCoord, this.ms.getAtomSetCenter(bS2), this.dipoleValue);
            }
            return;
        }
        if ("startCoord" == string) {
            this.startCoord.setT((T3)((P3)object));
            this.tempDipole.set2Value(this.startCoord, P3.new3((float)0.0f, (float)0.0f, (float)0.0f), this.dipoleValue);
            return;
        }
        if ("endCoord" == string) {
            this.iHaveTwoEnds = true;
            this.endCoord.setT((T3)((P3)object));
            this.tempDipole.set2Value(this.startCoord, this.endCoord, this.dipoleValue);
            this.dumpDipoles("endCoord");
            return;
        }
        if ("value" == string) {
            this.dipoleValue = ((Float)object).floatValue();
            this.isUserValue = true;
            this.tempDipole.setValue(this.dipoleValue);
            if (this.tempDipole.offsetPercent != 0) {
                this.tempDipole.offsetAngstroms = (float)this.tempDipole.offsetPercent / 100.0f * this.tempDipole.dipoleValue;
            }
            return;
        }
        if ("set" == string) {
            if (this.isBond || !this.iHaveTwoEnds && this.tempDipole.bsMolecule == null) {
                return;
            }
            this.setDipole();
            this.setModelIndex();
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = this.dipoleCount;
            while (--n2 >= 0) {
                if (this.dipoles[n2].modelIndex > n) {
                    --this.dipoles[n2].modelIndex;
                    continue;
                }
                if (this.dipoles[n2].modelIndex != n) continue;
                if (this.dipoles[n2] == this.currentDipole) {
                    this.currentDipole = null;
                }
                this.dipoles = (Dipole[])AU.deleteElements((Object)this.dipoles, (int)n2, (int)1);
                --this.dipoleCount;
            }
            this.currentDipole = null;
            return;
        }
    }

    private void getMolecular(BS bS) {
        V3 v3;
        V3 v32 = v3 = bS == null ? this.calculatedDipole : null;
        if (v3 == null && bS == null) {
            v3 = this.vwr.getModelDipole();
            Logger.info((String)("file molecular dipole = " + v3 + " " + (v3 != null ? "" + v3.length() : "")));
        }
        if (v3 == null) {
            this.calculatedDipole = v3 = this.vwr.calculateMolecularDipole(bS);
        }
        if (v3 == null) {
            Logger.warn((String)"No molecular dipole found for this model; setting to {0 0 0}");
            v3 = new V3();
        }
        this.tempDipole.bsMolecule = bS;
        this.tempDipole.setPtVector(P3.new3((float)0.0f, (float)0.0f, (float)0.0f), V3.new3((float)(-v3.x), (float)(-v3.y), (float)(-v3.z)));
        if (this.tempDipole.lstDipoles != null) {
            this.getAllMolecularDipoles(bS);
        }
        this.tempDipole.type = (short)4;
        if (this.currentDipole.thisID == null || bS == null) {
            this.tempDipole.thisID = "molecular";
        }
        this.setDipole();
    }

    private void getAllMolecularDipoles(BS bS) {
        JmolMolecule[] jmolMoleculeArray = this.ms.getMolecules();
        int n = jmolMoleculeArray.length;
        while (--n >= 0) {
            V3 v3;
            JmolMolecule jmolMolecule = jmolMoleculeArray[n];
            if (!jmolMolecule.atomList.intersects(bS) || (v3 = this.ms.calculateMolecularDipole(0, jmolMolecule.atomList)) == null) continue;
            P3 p3 = this.ms.getAtomSetCenter(jmolMolecule.atomList);
            this.tempDipole.lstDipoles.addLast((Object)new Object[]{v3, p3, jmolMolecule.atomList});
        }
    }

    private void setPropertyTok(int n, boolean bl, int n2, float f) {
        if (this.currentDipole != null) {
            this.setPropertyFor(n, this.currentDipole, n2, f);
        } else {
            int n3 = this.dipoleCount;
            while (--n3 >= 0) {
                if (bl && !this.isBondDipole(n3) || this.wildID != null && !PT.isMatch((String)this.dipoles[n3].thisID.toUpperCase(), (String)this.wildID, (boolean)true, (boolean)true)) continue;
                this.setPropertyFor(n, this.dipoles[n3], n2, f);
            }
        }
    }

    private void setPropertyFor(int n, Dipole dipole, int n2, float f) {
        switch (n) {
            case 0x10000D: {
                dipole.visible = true;
                return;
            }
            case 0x10000C: {
                dipole.visible = false;
                return;
            }
            case 12291: {
                this.deleteDipole(dipole);
                return;
            }
            case 659488: {
                dipole.mad = this.tempDipole.mad = (short)n2;
                return;
            }
            case 1611272194: {
                dipole.offsetAngstroms = f;
                return;
            }
            case 269484210: {
                dipole.offsetAngstroms = f * dipole.dipoleValue;
                return;
            }
            case 3145754: {
                dipole.offsetSide = f;
                return;
            }
            case 135267329: {
                dipole.noCross = n2 == 0;
                return;
            }
            case 1766856708: {
                dipole.colix = this.colix;
                return;
            }
            case 603979967: {
                dipole.setTranslucent(n2 == 1, this.translucentLevel);
                return;
            }
        }
        Logger.error((String)("Unkown dipole property! " + T.nameOf((int)n)));
    }

    public boolean getPropertyData(String string, Object[] objectArray) {
        if (string == "getNames") {
            // empty if block
        }
        if (string == "checkID") {
            String string2 = ((String)objectArray[0]).toUpperCase();
            boolean bl = PT.isWild((String)string2);
            int n = this.dipoleCount;
            while (--n >= 0) {
                String string3 = this.dipoles[n].thisID;
                if (!string3.equalsIgnoreCase(string2) && (!bl || !PT.isMatch((String)string3.toUpperCase(), (String)string2, (boolean)true, (boolean)true))) continue;
                objectArray[1] = string3;
                return true;
            }
            return false;
        }
        return false;
    }

    public Object getProperty(String string, int n) {
        if (string.equals("list")) {
            return this.getShapeState();
        }
        return null;
    }

    private void getBondDipoles() {
        float[] fArray = this.ms.getPartialCharges();
        if (fArray == null) {
            return;
        }
        this.clear(true);
        Bond[] bondArray = this.ms.bo;
        int n = this.ms.bondCount;
        while (--n >= 0) {
            float f;
            float f2;
            Bond bond = bondArray[n];
            if (!bond.isCovalent() || (f2 = fArray[bond.atom1.i]) == (f = fArray[bond.atom2.i])) continue;
            this.setDipoleAtoms(bond.atom1, bond.atom2, f2, f);
        }
    }

    private boolean isBondDipole(int n) {
        if (n >= this.dipoles.length || this.dipoles[n] == null) {
            return false;
        }
        return this.dipoles[n].isBondType();
    }

    private void setColixDipole(short s, int n, BS bS) {
        if (s == 2) {
            return;
        }
        BondIterator bondIterator = this.ms.getBondIteratorForType(n, bS);
        while (bondIterator.hasNext()) {
            Dipole dipole = this.findBondDipole(bondIterator.next());
            if (dipole == null) continue;
            dipole.colix = s;
        }
    }

    private void setDipole() {
        if (this.currentDipole == null) {
            this.currentDipole = this.allocDipole("", "");
        }
        this.currentDipole.set(this.tempDipole);
        this.currentDipole.isUserValue = this.isUserValue;
        this.currentDipole.modelIndex = this.vwr.am.cmi;
    }

    private void setDipoleAtoms(Atom atom, Atom atom2, float f, float f2) {
        Dipole dipole = this.findAtomDipole(atom, atom2, true);
        float f3 = (f - f2) / 2.0f * atom.distance((T3)atom2) / 0.208194f;
        if (f3 < 0.0f) {
            dipole.set2AtomValue(atom2, atom, -f3);
        } else {
            dipole.set2AtomValue(atom, atom2, f3);
        }
        dipole.type = (short)3;
        dipole.modelIndex = atom.mi;
    }

    private int getDipoleIndexFor(String string, String string2) {
        if (string != null && string.length() > 0) {
            int n = this.dipoleCount;
            while (--n >= 0) {
                if (!this.isSameAtoms(this.dipoles[n], string)) continue;
                return n;
            }
        }
        return this.getIndexFromName(string2);
    }

    private boolean isSameAtoms(Dipole dipole, String string) {
        return dipole != null && dipole.isBondType() && (dipole.dipoleInfo + dipole.dipoleInfo).indexOf(string) >= 0;
    }

    private int getDipoleIndex(int n, int n2) {
        int n3 = this.dipoleCount;
        while (--n3 >= 0) {
            if (this.dipoles[n3] == null || this.dipoles[n3].atoms[0] == null || this.dipoles[n3].atoms[1] == null || (this.dipoles[n3].atoms[0].i != n || this.dipoles[n3].atoms[1].i != n2) && (this.dipoles[n3].atoms[1].i != n || this.dipoles[n3].atoms[0].i != n2)) continue;
            return n3;
        }
        return -1;
    }

    private void deleteDipole(Dipole dipole) {
        if (dipole == null) {
            return;
        }
        if (this.currentDipole == dipole) {
            this.currentDipole = null;
        }
        int n = this.dipoleCount;
        while (this.dipoles[--n] != dipole) {
        }
        if (n < 0) {
            return;
        }
        for (int i = n + 1; i < this.dipoleCount; ++i) {
            this.dipoles[i - 1] = this.dipoles[i];
        }
        this.dipoles[--this.dipoleCount] = null;
    }

    private Dipole findDipole(String string) {
        int n = this.getIndexFromName(string);
        if (n >= 0) {
            return this.dipoles[n];
        }
        return null;
    }

    private Dipole findAtomDipole(Atom atom, Atom atom2, boolean bl) {
        int n = this.getDipoleIndex(atom.i, atom2.i);
        if (n >= 0) {
            return this.dipoles[n];
        }
        return bl ? this.allocDipole("", "") : null;
    }

    private Dipole findBondDipole(Bond bond) {
        Dipole dipole = this.findAtomDipole(bond.atom1, bond.atom2, false);
        return dipole == null || dipole.atoms[0] == null ? null : dipole;
    }

    private Dipole findDipoleFor(String string, String string2) {
        int n = this.getDipoleIndexFor(string2, string);
        if (n >= 0) {
            if (string.length() > 0) {
                this.dipoles[n].thisID = string;
            }
            return this.dipoles[n];
        }
        return this.allocDipole(string, string2);
    }

    private Dipole allocDipole(String string, String string2) {
        this.dipoles = (Dipole[])AU.ensureLength((Object)this.dipoles, (int)(this.dipoleCount + 1));
        if (string == null || string.length() == 0) {
            string = "dipole" + (this.dipoleCount + 1);
        }
        Dipole dipole = new Dipole().init(this.vwr.am.cmi, string, string2, this.colix, (short)5, true);
        this.dipoles[this.dipoleCount++] = dipole;
        Dipole dipole2 = dipole;
        return dipole2;
    }

    private void dumpDipoles(String string) {
        int n = this.dipoleCount;
        while (--n >= 0) {
            Dipole dipole = this.dipoles[n];
            Logger.info((String)("\n\n" + string + " dump dipole " + n + " " + dipole + " " + dipole.thisID + " " + dipole.dipoleInfo + " " + dipole.visibilityFlags + " mad=" + dipole.mad + " vis=" + dipole.visible + "\n orig" + dipole.origin + " " + " vect" + dipole.vector + " val=" + dipole.dipoleValue));
        }
        if (this.currentDipole != null) {
            Logger.info((String)(" current = " + this.currentDipole + this.currentDipole.origin));
        }
        if (this.tempDipole != null) {
            Logger.info((String)(" temp = " + this.tempDipole + " " + this.tempDipole.origin));
        }
    }

    private void clear(boolean bl) {
        if (bl) {
            int n = this.dipoleCount;
            while (--n >= 0) {
                if (!this.isBondDipole(n)) continue;
                this.deleteDipole(this.dipoles[n]);
            }
            return;
        }
        int n = this.dipoleCount;
        while (--n >= 0) {
            if (this.isBond && !this.isBondDipole(n)) continue;
            this.deleteDipole(this.dipoles[n]);
        }
    }

    public int getIndexFromName(String string) {
        if (string == null) {
            return -1;
        }
        int n = this.dipoleCount;
        while (--n >= 0) {
            if (this.dipoles[n] == null || !string.equals(this.dipoles[n].thisID)) continue;
            return n;
        }
        return -1;
    }

    public Lst<Map<String, Object>> getShapeDetail() {
        Lst lst = new Lst();
        P3 p3 = new P3();
        for (int i = 0; i < this.dipoleCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Dipole dipole = this.dipoles[i];
            hashtable.put("ID", dipole.thisID);
            hashtable.put("vector", dipole.vector);
            hashtable.put("origin", dipole.origin);
            if (dipole.bsMolecule != null) {
                hashtable.put("bsMolecule", dipole.bsMolecule);
            } else if (dipole.atoms[0] != null) {
                Hashtable hashtable2 = new Hashtable();
                this.ms.getAtomIdentityInfo(dipole.atoms[0].i, hashtable2, p3);
                Lst lst2 = new Lst();
                lst2.addLast(hashtable2);
                hashtable2 = new Hashtable();
                this.ms.getAtomIdentityInfo(dipole.atoms[1].i, hashtable2, p3);
                lst2.addLast(hashtable2);
                hashtable.put("atoms", lst2);
                hashtable.put("magnitude", Float.valueOf(dipole.vector.length()));
            }
            lst.addLast(hashtable);
        }
        return lst;
    }

    private void setModelIndex() {
        if (this.currentDipole == null) {
            return;
        }
        this.currentDipole.visible = true;
        this.currentDipole.modelIndex = this.vwr.am.cmi;
    }

    public void setModelVisibilityFlags(BS bS) {
        int n = this.dipoleCount;
        while (--n >= 0) {
            Dipole dipole = this.dipoles[n];
            dipole.visibilityFlags = (dipole.modelIndex < 0 || bS.get(dipole.modelIndex)) && dipole.mad != 0 && dipole.visible && dipole.origin != null && dipole.vector != null && dipole.vector.length() != 0.0f && dipole.dipoleValue != 0.0f ? this.vf : 0;
        }
    }

    public String getShapeState() {
        if (this.dipoleCount == 0) {
            return "";
        }
        SB sB = new SB();
        int n = -1;
        int n2 = this.vwr.ms.mc;
        for (int i = 0; i < this.dipoleCount; ++i) {
            Dipole dipole = this.dipoles[i];
            if (!dipole.isValid) continue;
            if (n2 > 1 && dipole.modelIndex != n) {
                n = dipole.modelIndex;
                Dipoles.appendCmd((SB)sB, (String)("frame " + this.vwr.getModelNumberDotted(n)));
            }
            sB.append(dipole.getShapeState());
            Dipoles.appendCmd((SB)sB, (String)Dipoles.getColorCommandUnk((String)"dipole", (short)dipole.colix, (boolean)this.translucentAllowed));
        }
        return sB.toString();
    }
}

