/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P4;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.PhosphorusPolymer;

public class NucleicPolymer
extends PhosphorusPolymer {
    public boolean isDssrSet;
    public static Map<String, String> htGroup1;

    NucleicPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 2;
        this.hasWingPoints = true;
    }

    Atom getNucleicPhosphorusAtom(int n) {
        return this.monomers[n].getLeadAtom();
    }

    @Override
    protected boolean calcEtaThetaAngles() {
        float f = Float.NaN;
        for (int i = 0; i < this.monomerCount - 2; ++i) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[i];
            NucleicMonomer nucleicMonomer2 = (NucleicMonomer)this.monomers[i + 1];
            Atom atom = nucleicMonomer.getP();
            Atom atom2 = nucleicMonomer.getC4P();
            Atom atom3 = nucleicMonomer2.getP();
            Atom atom4 = nucleicMonomer2.getC4P();
            if (i > 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)this.monomers[i - 1];
                Atom atom5 = nucleicMonomer3.getC4P();
                f = Measure.computeTorsion(atom5, atom, atom2, atom3, true);
            }
            float f2 = Measure.computeTorsion(atom, atom2, atom3, atom4, true);
            if (f < 0.0f) {
                f += 360.0f;
            }
            if (f2 < 0.0f) {
                f2 += 360.0f;
            }
            nucleicMonomer.setGroupParameter(1112539141, f);
            nucleicMonomer.setGroupParameter(1112539152, f2);
        }
        return true;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BS bS, BS bS2, Lst<Bond> lst, int n, int[][][] nArray, boolean bl, boolean bl2) {
        NucleicPolymer nucleicPolymer = (NucleicPolymer)bioPolymer;
        V3 v3 = new V3();
        V3 v32 = new V3();
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[n2];
            if (!nucleicMonomer.isPurine()) continue;
            Atom atom = nucleicMonomer.getN3();
            boolean bl3 = bS.get(atom.i);
            if (!bl3 && !bS2.get(atom.i)) continue;
            Atom atom2 = nucleicMonomer.getN1();
            Atom atom3 = nucleicMonomer.getN0();
            P4 p4 = Measure.getPlaneThroughPoints(atom, atom2, atom3, v3, v32, new P4());
            Atom atom4 = null;
            float f = 25.0f;
            NucleicMonomer nucleicMonomer2 = null;
            int n3 = nucleicPolymer.monomerCount;
            while (--n3 >= 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)nucleicPolymer.monomers[n3];
                if (!nucleicMonomer3.isPyrimidine()) continue;
                Atom atom5 = nucleicMonomer3.getN3();
                if (bl3 ? !bS2.get(atom5.i) : !bS.get(atom5.i)) continue;
                Atom atom6 = nucleicMonomer3.getN0();
                float f2 = atom2.distanceSquared(atom5);
                if (!(f2 < f) || !(atom3.distanceSquared(atom6) > 50.0f) || !(Math.abs(Measure.distanceToPlane(p4, atom5)) < 1.0f)) continue;
                nucleicMonomer2 = nucleicMonomer3;
                atom4 = atom5;
                f = f2;
            }
            n3 = 0;
            if (atom4 == null || (n3 += NucleicPolymer.addHydrogenBond(lst, atom2, atom4)) >= n) continue;
            if (nucleicMonomer.isGuanine()) {
                if ((n3 += NucleicPolymer.addHydrogenBond(lst, nucleicMonomer.getN2(), nucleicMonomer2.getO2())) >= n || (n3 += NucleicPolymer.addHydrogenBond(lst, nucleicMonomer.getO6(), nucleicMonomer2.getN4())) < n) continue;
                continue;
            }
            n3 += NucleicPolymer.addHydrogenBond(lst, nucleicMonomer.getN6(), nucleicMonomer2.getO4());
        }
    }

    protected static int addHydrogenBond(Lst<Bond> lst, Atom atom, Atom atom2) {
        if (atom == null || atom2 == null) {
            return 0;
        }
        lst.addLast(new HBond(atom, atom2, 18432, 1, 0, 0.0f));
        return 1;
    }
}

