/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialog;

public class NBOService {
    public static final int MODEL = 1;
    public static final int RUN = 2;
    public static final int VIEW = 3;
    public static final int RAW = 4;
    private transient Viewer vwr;
    public NBODialog nboDialog;
    private Process nboServer;
    private Thread nboListener;
    private InputStream stdout;
    public Scanner nboScanner;
    public BufferedReader nboReader;
    private int nboMode;
    private PrintWriter stdinWriter;
    private SB sbRet;
    private String nboAction;
    private boolean inData;
    public String serverPath;
    public String workingPath;
    private boolean nboSync;
    private String nboModel;

    public NBOService(Viewer viewer) {
        this.vwr = viewer;
        this.sbRet = new SB();
        Properties properties = JmolPanel.historyFile.getProperties();
        this.setServerPath(properties.getProperty("nboServerPath", System.getProperty("user.home") + "/NBOServe"));
    }

    private void setServerPath(String string) {
        this.serverPath = string;
        this.workingPath = string.substring(0, string.lastIndexOf(File.separator));
    }

    public boolean processRequest(Map<String, Object> map) {
        String string;
        boolean bl = false;
        boolean bl2 = map.get("sync") == Boolean.TRUE;
        boolean bl3 = false;
        if (this.nboServer != null) {
            try {
                this.nboServer.exitValue();
                bl3 = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl2 || this.nboSync || this.nboServer == null || bl3) {
            this.closeProcess();
            this.startProcess(bl2);
        }
        this.nboMode = (Integer)map.get("mode");
        if (this.stdinWriter == null) {
            this.closeProcess();
            this.sbRet.append("ERROR: Could not connect to NBOServe -- Use Tools...NBO... to set up NBOServe");
            this.nboMode = 0;
        }
        this.nboAction = (String)map.get("action");
        switch (this.nboMode) {
            case 1: {
                string = (String)map.get("value");
                if (this.nboAction.equals("load")) {
                    string = "sh " + string;
                    break;
                }
                if (this.nboAction.equals("run")) break;
                string = null;
                break;
            }
            case 3: {
                string = (String)map.get("value");
                break;
            }
            case 4: {
                string = (String)map.get("value");
                break;
            }
            default: {
                this.nboReport("unknown mode");
                string = null;
            }
        }
        if (string != null) {
            this.sendToNBO(this.nboMode, string);
            if (bl2) {
                try {
                    this.nboServer.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            bl = true;
        }
        if (bl2) {
            map.put("ret", this.sbRet.toString());
            this.sbRet.setLength(0);
        }
        return bl;
    }

    private void sendToNBO(int n, String string) {
        string = n == 4 ? string : n + "\n" + string + "\nexit" + (this.nboSync ? "\nexit" : "");
        this.sendCmd(string);
    }

    private void sendCmd(String string) {
        this.vwr.log("sending:\n>>>\n" + string + "\n<<<");
        this.stdinWriter.println(string);
        this.stdinWriter.flush();
    }

    public void nboReport(String string) {
        this.vwr.log(this.inData + " " + this.nboSync + " " + this.sbRet.length() + " " + "receiving: " + string);
        if (string.startsWith("DATA ")) {
            if (string.startsWith("DATA \"model")) {
                this.nboModel = PT.getQuotedStringAt(string, 0);
                string = string + " NBO " + this.nboModel;
            }
            boolean bl = this.inData = string.indexOf("exit") < 0;
            if (this.inData) {
                this.sbRet.append(string + "\n");
            }
            return;
        }
        if (this.inData) {
            this.sbRet.append(string + "\n");
            if (string.indexOf("END") >= 0) {
                this.inData = false;
                String string2 = "\"" + this.nboModel + "\"";
                this.nboModel = "\u0000";
                if (!this.nboSync && string.indexOf(string2) >= 0) {
                    String string3 = this.sbRet.toString();
                    this.sbRet.setLength(0);
                    this.vwr.log("running Jmol script:\n" + string3);
                    this.vwr.script(string3);
                }
                return;
            }
        }
        if (this.nboDialog != null) {
            this.nboDialog.nboReport(string);
        }
    }

    public String startProcess(boolean bl) {
        try {
            this.nboSync = bl;
            File file = new File(this.serverPath);
            ProcessBuilder processBuilder = new ProcessBuilder(this.serverPath);
            processBuilder.directory(new File(file.getParent()));
            processBuilder.redirectErrorStream(true);
            this.nboServer = processBuilder.start();
            this.stdout = this.nboServer.getInputStream();
            this.nboReader = new BufferedReader(new InputStreamReader(this.stdout));
            this.nboListener = null;
            this.nboListener = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string;
                        while ((string = NBOService.this.nboReader.readLine()) != null) {
                            NBOService.this.nboReport(string);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            });
            this.nboListener.start();
            this.stdinWriter = new PrintWriter(this.nboServer.getOutputStream());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            return iOException.getMessage();
        }
        return null;
    }

    public void closeProcess() {
        this.stdout = null;
        try {
            this.stdinWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stdinWriter = null;
        try {
            this.nboScanner.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboScanner = null;
        try {
            this.nboReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboReader = null;
        try {
            this.nboListener.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboListener = null;
        try {
            this.nboServer.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nboServer = null;
    }

    public void saveHistory() {
        Properties properties = new Properties();
        properties.setProperty("nboServerPath", this.serverPath);
        JmolPanel.historyFile.addProperties(properties);
    }
}

