/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.nbo.NBOService;

public class NBODialog
extends JDialog
implements ChangeListener {
    protected Viewer vwr;
    protected JButton nboPathButton;
    protected JTextField Field;
    protected JTextField dataPathLabel;
    protected JTextField serverPathLabel;
    private JTextPane nboOutput;
    protected JScrollPane editPane2;
    private JTextField nboInput;
    private NBOService nboService;
    private boolean haveService;

    public NBODialog(JFrame jFrame, Viewer viewer, NBOService nBOService) {
        super(jFrame, GT._("NBO Server Interface"), false);
        this.vwr = viewer;
        this.nboService = nBOService;
        nBOService.nboDialog = this;
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(700, 500));
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.buildRightPanel();
        JPanel jPanel3 = this.buildFilePanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel4, "North");
        jPanel.add((Component)jPanel2, "Center");
        this.getContentPane().add(jPanel);
        this.pack();
        this.centerDialog();
        this.setVisible(true);
        if (this.haveService) {
            this.connectPressed();
        }
    }

    private JPanel buildFilePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder("Location of the NBO-Server Executable"));
        Box box = Box.createHorizontalBox();
        this.serverPathLabel = new JTextField("");
        this.serverPathLabel.setEditable(false);
        this.serverPathLabel.setBorder(null);
        this.serverPathLabel.setText(this.nboService.serverPath);
        this.haveService = this.serverPathLabel.getText().length() > 0;
        box.add(this.serverPathLabel);
        box.add(new JLabel("  "));
        this.nboPathButton = new JButton("Browse...");
        this.nboPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.showNBOPathDialog();
            }
        });
        box.add(this.nboPathButton);
        jPanel.add((Component)box, "West");
        box = Box.createHorizontalBox();
        JButton jButton = new JButton("Connect");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.connectPressed();
            }
        });
        box.add(jButton);
        jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.clearPressed();
            }
        });
        box.add(jButton);
        jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.closePressed();
            }
        });
        box.add(jButton);
        jPanel.add((Component)box, "East");
        return jPanel;
    }

    private JPanel buildRightPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("NBO Output");
        jPanel.setBorder(titledBorder);
        this.nboOutput = new JTextPane();
        this.nboOutput.setContentType("text/plain");
        this.nboOutput.setFont(new Font("Monospaced", 0, 12));
        this.editPane2 = new JScrollPane();
        this.editPane2.getViewport().add(this.nboOutput);
        jPanel.add((Component)this.editPane2, "Center");
        jPanel.add(this.getRawPanel(), "South");
        return jPanel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private Component getRawPanel() {
        this.nboInput = new JTextField("");
        this.nboInput.setPreferredSize(new Dimension(100, 10));
        this.nboInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.rawCmd();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("NBO Input:"));
        box2.add(this.nboInput);
        box.add(box2);
        box.add(Box.createVerticalGlue());
        jPanel.add((Component)box, "North");
        return jPanel;
    }

    protected void rawCmd() {
        String string = this.nboInput.getText();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("mode", 4);
        hashtable.put("sync", Boolean.FALSE);
        hashtable.put("action", "cmd");
        this.nboInput.setText("");
        hashtable.put("value", string);
        this.nboReport(">> " + string);
        if (!this.nboService.processRequest(hashtable)) {
            this.nboReport(null);
            this.nboReport("not implemented");
        }
    }

    protected void connectPressed() {
        this.nboService.closeProcess();
        this.nboReport(null);
        String string = this.nboService.startProcess(false);
        if (string == null) {
            this.nboReport("listening...");
        } else {
            this.nboReport(string);
        }
    }

    protected void clearPressed() {
        this.nboReport(null);
    }

    void closePressed() {
        this.nboService.closeProcess();
        this.nboService.saveHistory();
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.haveService) {
            this.nboInput.requestFocus();
        } else {
            this.nboPathButton.requestFocus();
        }
    }

    void showNBOPathDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.serverPathLabel.getText();
        jFileChooser.setSelectedFile(new File(string));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string2 = file.toString();
            if (string2.indexOf("NBO") < 0) {
                return;
            }
            this.serverPathLabel.setText(string2);
            this.nboService.serverPath = string2;
            this.nboService.saveHistory();
            this.pack();
        }
    }

    protected void centerDialog() {
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    public synchronized void nboReport(String string) {
        try {
            this.nboOutput.setText(string == null ? "" : this.nboOutput.getText() + string + "\n");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NBODialog.this.pack();
                    NBODialog.this.editPane2.getVerticalScrollBar().setValue(NBODialog.this.editPane2.getVerticalScrollBar().getMaximum());
                }
            });
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

