/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.java.BS;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesGenerator;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BNode;
import org.jmol.util.BSUtil;
import org.jmol.util.Node;
import org.jmol.util.Point3fi;

public class SmilesMatcher
implements SmilesMatcherInterface {
    private static final int SMILES_MODE_BITSET = 4096;
    private static final int SMILES_MODE_ARRAY = 8192;
    private static final int SMILES_MODE_MAP = 12288;
    private static final int SMILES_MODE_MASK = 61440;

    private boolean checkFlag(int n, int n2) {
        return (n & n2) == n2;
    }

    @Override
    public String getLastException() {
        return InvalidSmilesException.getLastError();
    }

    @Override
    public String getMolecularFormula(String string, boolean bl) throws Exception {
        InvalidSmilesException.clear();
        SmilesSearch smilesSearch = SmilesParser.getMolecule(string, bl);
        smilesSearch.createTopoMap(null);
        smilesSearch.nodes = smilesSearch.jmolAtoms;
        return smilesSearch.getMolecularFormula(!bl, null, false);
    }

    @Override
    public String getSmiles(Node[] nodeArray, int n, BS bS, String string, int n2) throws Exception {
        InvalidSmilesException.clear();
        if (this.checkFlag(n2, 256)) {
            boolean bl = this.checkFlag(n2, 257);
            boolean bl2 = this.checkFlag(n2, 258);
            return new SmilesGenerator().getBioSmiles((BNode[])nodeArray, n, bS, bl, bl2, string);
        }
        boolean bl = this.checkFlag(n2, 1);
        boolean bl3 = this.checkFlag(n2, 2);
        boolean bl4 = !this.checkFlag(n2, 4);
        return new SmilesGenerator().getSmiles(nodeArray, n, bS, bl, bl3, bl4);
    }

    @Override
    public int areEqual(String string, String string2) throws Exception {
        InvalidSmilesException.clear();
        BS[] bSArray = (BS[])this.findPriv(string, SmilesParser.getMolecule(string2, false), (string.indexOf("*") >= 0 ? 131072 : 0x110000) | 0x400000 | 0x2000);
        return bSArray == null ? -1 : bSArray.length;
    }

    public boolean areEqualTest(String string, SmilesSearch smilesSearch) throws Exception {
        BS[] bSArray = (BS[])this.findPriv(string, smilesSearch, 5316608);
        return bSArray != null && bSArray.length == 1;
    }

    @Override
    public int[][] find(String string, String string2, boolean bl, boolean bl2) throws Exception {
        InvalidSmilesException.clear();
        string2 = SmilesParser.cleanPattern(string2);
        string = SmilesParser.cleanPattern(string);
        SmilesSearch smilesSearch = SmilesParser.getMolecule(string2, false);
        return (int[][])this.findPriv(string, smilesSearch, (bl ? 131072 : 0x110000) | (bl2 ? 0x400000 : 0) | 0x3000);
    }

    @Override
    public String getRelationship(String string, String string2) throws Exception {
        int n;
        boolean bl;
        String string3;
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return "";
        }
        String string4 = this.getMolecularFormula(string, false);
        if (!string4.equals(string3 = this.getMolecularFormula(string2, false))) {
            return "none";
        }
        int n2 = SmilesMatcher.countStereo(string);
        boolean bl2 = bl = n2 == (n = SmilesMatcher.countStereo(string2)) && this.areEqual(string2, string) > 0;
        if (!bl) {
            String string5 = string + string2;
            if (string5.indexOf("/") >= 0 || string5.indexOf("\\") >= 0 || string5.indexOf("@") >= 0) {
                if (n2 == n && n2 > 0) {
                    boolean bl3 = bl = this.areEqual(string = this.reverseChirality(string), string2) > 0;
                    if (bl) {
                        return "enantiomers";
                    }
                }
                boolean bl4 = bl = this.areEqual("/nostereo/" + string2, string) > 0;
                if (bl) {
                    return n2 == n ? "diastereomers" : "ambiguous stereochemistry!";
                }
            }
            return "constitutional isomers";
        }
        return "identical";
    }

    @Override
    public String reverseChirality(String string) {
        string = PT.rep(string, "@@", "!@");
        string = PT.rep(string, "@", "@@");
        string = PT.rep(string, "!@@", "@");
        string = PT.rep(string, "@@SP", "@SP");
        string = PT.rep(string, "@@OH", "@OH");
        string = PT.rep(string, "@@TB", "@TB");
        return string;
    }

    @Override
    public BS getSubstructureSet(String string, Node[] nodeArray, int n, BS bS, int n2) throws Exception {
        return (BS)this.matchPriv(string, nodeArray, n, bS, null, n2 | 0x200000 | 0x1000);
    }

    @Override
    public void getSubstructureSets(String[] stringArray, Node[] nodeArray, int n, int n2, BS bS, Lst<BS> lst, Lst<BS>[] lstArray) throws Exception {
        InvalidSmilesException.clear();
        SmilesParser smilesParser = new SmilesParser(true);
        SmilesSearch smilesSearch = null;
        smilesSearch = smilesParser.parse("");
        smilesSearch.firstMatchOnly = false;
        smilesSearch.matchAllAtoms = false;
        smilesSearch.jmolAtoms = nodeArray;
        smilesSearch.jmolAtomCount = Math.abs(n);
        smilesSearch.setSelected(bS);
        smilesSearch.getRingData(true, n2, lstArray);
        smilesSearch.asVector = false;
        smilesSearch.subSearches = new SmilesSearch[1];
        smilesSearch.getSelections();
        BS bS2 = new BS();
        for (int i = 0; i < stringArray.length; ++i) {
            SmilesSearch smilesSearch2;
            if (stringArray[i] == null || stringArray[i].length() == 0 || stringArray[i].startsWith("#")) {
                lst.addLast(null);
                continue;
            }
            smilesSearch.clear();
            smilesSearch.subSearches[0] = smilesSearch2 = smilesParser.getSearch(smilesSearch, SmilesParser.cleanPattern(stringArray[i]), n2);
            BS bS3 = BSUtil.copy((BS)smilesSearch.search(false));
            lst.addLast(bS3);
            bS2.or(bS3);
            if (bS2.cardinality() != n) continue;
            return;
        }
    }

    @Override
    public BS[] getSubstructureSetArray(String string, Node[] nodeArray, int n, BS bS, BS bS2, int n2) throws Exception {
        return (BS[])this.matchPriv(string, nodeArray, n, bS, bS2, n2 | 0x200000 | 0x2000);
    }

    @Override
    public String polyhedronToSmiles(int[][] nArray, int n, P3[] p3Array) throws Exception {
        int n2;
        Node[] nodeArray = new SmilesAtom[n];
        for (n2 = 0; n2 < n; ++n2) {
            nodeArray[n2] = new SmilesAtom();
            P3 p3 = p3Array == null ? null : p3Array[n2];
            nodeArray[n2].elementNumber = p3 == null ? -2 : (p3 instanceof Node ? ((Node)((Object)p3)).getElementNumber() : (p3 instanceof Point3fi ? (int)((Point3fi)p3).sD : -2));
            nodeArray[n2].index = n2;
        }
        n2 = 0;
        int n3 = nArray.length;
        while (--n3 >= 0) {
            int n4;
            int[] nArray2 = nArray[n3];
            int n5 = n4 = nArray2.length;
            while (--n5 >= 0) {
                int n6 = nArray2[n5];
                if (n6 < 0 || n6 >= n) continue;
                int n7 = nArray2[(n5 + 1) % n4];
                if (n7 < 0 || n7 >= n) {
                    n7 = nArray2[(n5 + 2) % n4];
                }
                if (n7 < 0 || n7 >= n || ((SmilesAtom)nodeArray[n6]).getBondTo((SmilesAtom)nodeArray[n7]) != null) continue;
                SmilesBond smilesBond = new SmilesBond((SmilesAtom)nodeArray[n6], (SmilesAtom)nodeArray[n7], 1, false);
                smilesBond.index = n2++;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            int n8 = nodeArray[n3].bondCount;
            if (n8 != 0 && n8 == nodeArray[n3].bonds.length) continue;
            nodeArray[n3].bonds = (SmilesBond[])AU.arrayCopyObject(nodeArray[n3].bonds, n8);
        }
        return this.getSmiles(nodeArray, n, BSUtil.newBitSet2(0, n), null, 4 | (p3Array == null ? 2 : 65536));
    }

    @Override
    public int[][] getCorrelationMaps(String string, Node[] nodeArray, int n, BS bS, int n2) throws Exception {
        return (int[][])this.matchPriv(string, nodeArray, n, bS, null, n2 | 0x200000 | 0x3000);
    }

    private Object findPriv(String string, SmilesSearch smilesSearch, int n) throws Exception {
        BS bS = new BS();
        smilesSearch.createTopoMap(bS);
        return this.matchPriv(string, smilesSearch.jmolAtoms, -smilesSearch.jmolAtoms.length, null, bS, n);
    }

    private Object matchPriv(String string, Node[] nodeArray, int n, BS bS, BS bS2, int n2) throws Exception {
        InvalidSmilesException.clear();
        try {
            SmilesSearch smilesSearch = SmilesParser.getMolecule(string, this.checkFlag(n2, 131072));
            smilesSearch.jmolAtoms = nodeArray;
            if (nodeArray instanceof BNode[]) {
                smilesSearch.bioAtoms = (BNode[])nodeArray;
            }
            smilesSearch.jmolAtomCount = Math.abs(n);
            if (n < 0) {
                smilesSearch.isSmilesFind = true;
            }
            smilesSearch.setSelected(bS);
            smilesSearch.getSelections();
            smilesSearch.bsRequired = null;
            smilesSearch.setRingData(bS2);
            smilesSearch.firstMatchOnly = this.checkFlag(n2, 0x400000);
            smilesSearch.matchAllAtoms = this.checkFlag(n2, 0x100000);
            switch (n2 & 0xF000) {
                case 4096: {
                    smilesSearch.asVector = false;
                    return smilesSearch.search(false);
                }
                case 8192: {
                    smilesSearch.asVector = true;
                    Lst lst = (Lst)smilesSearch.search(false);
                    return lst.toArray(new BS[lst.size()]);
                }
                case 12288: {
                    smilesSearch.getMaps = true;
                    Lst lst = (Lst)smilesSearch.search(false);
                    return lst.toArray((T[])AU.newInt2(lst.size()));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (InvalidSmilesException.getLastError() == null) {
                InvalidSmilesException.clear();
            }
            throw new InvalidSmilesException(InvalidSmilesException.getLastError());
        }
        return null;
    }

    private static int countStereo(String string) {
        string = PT.rep(string, "@@", "@");
        int n = string.lastIndexOf(64) + 1;
        int n2 = 0;
        while (--n >= 0) {
            if (string.charAt(n) != '@') continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public String cleanSmiles(String string) {
        return SmilesParser.cleanPattern(string);
    }
}

