/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.DF;
import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class DmolReader
extends AtomSetCollectionReader {
    private float[] unitCellData;
    private Double totE;
    private boolean geomOpt;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("** GEOMETRY OPTIMIZATION IN DELOCALIZED COORDINATES **")) {
            this.geomOpt = true;
        } else if (this.line.contains("INCOOR, atomic coordinates")) {
            this.geomOpt = false;
        } else if (!this.geomOpt ? this.line.contains("$cell vectors") : this.line.contains("Lattice:")) {
            this.readCellParam();
        } else if (!this.geomOpt ? this.line.contains("$coordinates") : this.line.contains("Input Coordinates")) {
            this.readCoord();
        } else if (this.line.contains(" Total Energy")) {
            this.readEnergy();
        } else if (this.line.contains("Frequencies (cm-1)")) {
            this.readFreq();
        }
        return true;
    }

    private void readCellParam() throws Exception {
        this.unitCellData = new float[9];
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            String[] stringArray = PT.getTokens(this.rd());
            this.unitCellData[n++] = this.parseFloatStr(!this.geomOpt ? stringArray[0] : stringArray[4]) * 0.5291772f;
            this.unitCellData[n++] = this.parseFloatStr(!this.geomOpt ? stringArray[1] : stringArray[5]) * 0.5291772f;
            this.unitCellData[n++] = this.parseFloatStr(!this.geomOpt ? stringArray[2] : stringArray[6]) * 0.5291772f;
        }
    }

    private void newAtomSet() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.asc.newAtomSet();
        if (this.totE != null) {
            this.setEnergy();
        }
        this.doApplySymmetry = true;
        if (this.unitCellData != null) {
            this.addPrimitiveLatticeVector(0, this.unitCellData, 0);
            this.addPrimitiveLatticeVector(1, this.unitCellData, 3);
            this.addPrimitiveLatticeVector(2, this.unitCellData, 6);
            this.setSpaceGroupName("P1");
        }
        this.setFractionalCoordinates(false);
    }

    private void readCoord() throws Exception {
        this.newAtomSet();
        if (this.geomOpt) {
            this.readLines(2);
        }
        while (this.rd() != null && !this.geomOpt ? !this.line.contains("$end") : !this.line.contains("-----")) {
            String[] stringArray = this.getTokens();
            Atom atom = this.asc.addNewAtom();
            atom.atomName = !this.geomOpt ? stringArray[0] : stringArray[1];
            float f = (float)(!this.geomOpt ? 0.529177188873291 : 1.0);
            float f2 = this.parseFloatStr(!this.geomOpt ? stringArray[1] : stringArray[2]) * f;
            float f3 = this.parseFloatStr(!this.geomOpt ? stringArray[2] : stringArray[3]) * f;
            float f4 = this.parseFloatStr(!this.geomOpt ? stringArray[3] : stringArray[4]) * f;
            atom.set(f2, f3, f4);
            this.setAtomCoord(atom);
        }
    }

    private void readEnergy() throws Exception {
        this.rd();
        if (this.line.contains("Ef")) {
            this.totE = Double.parseDouble(PT.getTokens(this.line.substring(this.line.indexOf("Ef") + 1, this.line.indexOf("Ha")))[1]);
        }
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.totE, this.totE.floatValue());
        this.asc.setInfo("Energy", this.totE);
        this.asc.setAtomSetName("E = " + this.totE + " Hartree");
    }

    private void readFreq() throws Exception {
        int n = 0;
        int n2 = this.asc.getLastAtomSetAtomCount();
        while (this.rd() != null && this.line.charAt(1) == ' ') {
            String[] stringArray = this.getTokens();
            int n3 = stringArray.length / 2;
            float[] fArray = new float[n3];
            int n4 = 1;
            int n5 = 0;
            while (n4 < stringArray.length) {
                fArray[n5] = this.parseFloatStr(stringArray[n4]);
                if (Logger.debugging) {
                    Logger.debug(this.vibrationNumber + n5 + " frequency=" + fArray[n5]);
                }
                n4 += 2;
                ++n5;
            }
            boolean[] blArray = new boolean[n3];
            n5 = 0;
            for (int i = 0; i < n3; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.applySymmetryAndSetTrajectory();
                n = this.cloneLastAtomSet(n2, null);
                if (i == 0) {
                    n5 = this.asc.getLastAtomSetAtomIndex();
                }
                this.asc.setAtomSetFrequency(null, null, String.valueOf(fArray[i]), null);
                this.asc.setAtomSetName(DF.formatDecimal(fArray[i], 2) + " cm-1");
            }
            this.rd();
            this.fillFrequencyData(n5, n2, n, blArray, false, 5, 13, null, 0);
            this.readLines(2);
        }
    }
}

