/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.Lst;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;

public class ScaleData {
    private static final int[] NTICKS = new int[]{2, 5, 10, 10};
    private static final double[] LOGTICKS = new double[]{Math.log10(2.0), Math.log10(5.0), 0.0, 1.0};
    private double initMinYOnScale;
    private double initMaxYOnScale;
    private double initMinY;
    private double initMaxY;
    int startDataPointIndex;
    int endDataPointIndex;
    int pointCount;
    double minX;
    double maxX;
    double firstX = Double.NaN;
    public double minXOnScale;
    public double maxXOnScale;
    double specShift;
    public int[] precision = new int[2];
    public int[] exportPrecision = new int[2];
    public double[] steps = new double[2];
    int[] minorTickCounts = new int[2];
    public double minYOnScale;
    public double maxYOnScale;
    double minY;
    double maxY;
    boolean isShiftZoomedY;
    double spectrumScaleFactor = 1.0;
    double spectrumYRef = 0.0;
    double userYFactor = 1.0;
    double firstY;
    double minY2D;
    double maxY2D;
    private double xFactorForScale;
    private double yFactorForScale;

    ScaleData() {
    }

    ScaleData(int n, int n2) {
        this.startDataPointIndex = n;
        this.endDataPointIndex = n2;
        this.pointCount = this.endDataPointIndex - this.startDataPointIndex + 1;
    }

    public ScaleData(Coordinate[] coordinateArray, int n, int n2, boolean bl, boolean bl2) {
        this.minX = Coordinate.getMinX(coordinateArray, n, n2);
        this.maxX = Coordinate.getMaxX(coordinateArray, n, n2);
        this.minY = Coordinate.getMinY(coordinateArray, n, n2);
        if (this.minY > 0.0 && !bl) {
            this.minY = 0.0;
        }
        this.maxY = Coordinate.getMaxY(coordinateArray, n, n2);
        this.setScale(bl, bl2);
    }

    void setScale(boolean bl, boolean bl2) {
        this.setXScale();
        if (!bl) {
            this.maxXOnScale += this.steps[0] / 2.0;
        }
        this.setYScale(this.minY, this.maxY, true, bl2);
    }

    private void setXScale() {
        double d = this.setScaleParams(this.minX, this.maxX, 0);
        this.firstX = Math.floor(this.minX / d) * d;
        if (Math.abs((this.minX - this.firstX) / d) > 1.0E-4) {
            this.firstX += d;
        }
        this.minXOnScale = this.minX;
        this.maxXOnScale = this.maxX;
    }

    boolean isYZeroOnScale() {
        return this.minYOnScale < this.spectrumYRef && this.maxYOnScale > this.spectrumYRef;
    }

    void setYScale(double d, double d2, boolean bl, boolean bl2) {
        double d3;
        if (d == 0.0 && d2 == 0.0) {
            d2 = 1.0;
        }
        if (this.isShiftZoomedY) {
            d = this.minYOnScale;
            d2 = this.maxYOnScale;
        }
        double d4 = this.setScaleParams(d, d2, 1);
        double d5 = bl2 ? d4 / 2.0 : d4 / 4.0;
        double d6 = d3 = bl2 ? d4 / 4.0 : d4 / 2.0;
        if (!this.isShiftZoomedY) {
            this.minYOnScale = d == 0.0 ? 0.0 : (bl ? d5 * Math.floor(d / d5) : d);
            this.maxYOnScale = bl ? d3 * Math.ceil(d2 * 1.05 / d3) : d2;
        }
        double d7 = this.firstY = d == 0.0 ? 0.0 : Math.floor(d / d5) * d5;
        if (this.minYOnScale < 0.0 && this.maxYOnScale > 0.0) {
            this.firstY = 0.0;
            while (this.firstY - d4 > this.minYOnScale) {
                this.firstY -= d4;
            }
        } else if (this.minYOnScale != 0.0 && Math.abs((d - this.firstY) / d5) > 1.0E-4) {
            this.firstY += d5;
        }
        if (bl) {
            this.initMinYOnScale = this.minYOnScale;
            this.initMaxYOnScale = this.maxYOnScale;
            this.initMinY = d;
            this.initMaxY = d2;
        }
    }

    void scale2D(double d) {
        double d2 = this.maxY - this.minY;
        if (d == 1.0) {
            this.maxY = this.initMaxY;
            this.minY = this.initMinY;
            return;
        }
        this.maxY = this.minY + d2 / d;
    }

    void setXRange(double d, double d2) {
        this.minX = d;
        this.maxX = d2;
        this.setXScale();
    }

    private static int getXRange(int n, Coordinate[] coordinateArray, double d, double d2, int n2, int n3, int[] nArray, int[] nArray2) {
        double d3;
        int n4 = 0;
        int n5 = 0;
        for (n4 = n2; n4 <= n3; ++n4) {
            d3 = coordinateArray[n4].getXVal();
            if (!(d3 >= d)) continue;
            nArray[n] = n4;
            break;
        }
        while (n4 <= n3) {
            d3 = coordinateArray[n4].getXVal();
            ++n5;
            if (d3 >= d2) break;
            ++n4;
        }
        nArray2[n] = n4 - 1;
        return n5;
    }

    private double setScaleParams(double d, double d2, int n) {
        int n2;
        double d3 = d2 == d ? 1.0 : Math.abs(d2 - d) / 14.0;
        double d4 = Math.log10(Math.abs(d3));
        this.exportPrecision[n] = n2 = (int)Math.floor(d4);
        this.precision[n] = n2 <= 0 ? Math.min(8, 1 - n2) : (n2 > 3 ? -2 : 0);
        int n3 = 0;
        double d5 = Math.pow(10.0, d4 - (double)n2);
        while (d5 > (double)NTICKS[n3]) {
            ++n3;
        }
        this.steps[n] = Math.pow(10.0, n2) * (double)NTICKS[n3];
        d4 = Math.log10(Math.abs(this.steps[n] * 100010.0));
        double d6 = d4 - Math.floor(d4);
        int n4 = 0;
        for (n3 = 0; n3 < NTICKS.length; ++n3) {
            if (!(Math.abs(d6 - LOGTICKS[n3]) < 0.001)) continue;
            n4 = NTICKS[n3];
            break;
        }
        this.minorTickCounts[n] = n4;
        return this.steps[n];
    }

    boolean isInRangeX(double d) {
        return d >= this.minX && d <= this.maxX;
    }

    void addSpecShift(double d) {
        this.specShift += d;
        this.minX += d;
        this.maxX += d;
        this.minXOnScale += d;
        this.maxXOnScale += d;
        this.firstX += d;
    }

    Map<String, Object> getInfo(Map<String, Object> map) {
        map.put("specShift", this.specShift);
        map.put("minX", this.minX);
        map.put("maxX", this.maxX);
        map.put("minXOnScale", this.minXOnScale);
        map.put("maxXOnScale", this.maxXOnScale);
        map.put("minY", this.minY);
        map.put("maxY", this.maxY);
        map.put("minYOnScale", this.minYOnScale);
        map.put("maxYOnScale", this.maxYOnScale);
        map.put("minorTickCountX", this.minorTickCounts[0]);
        map.put("xStep", this.steps[0]);
        return map;
    }

    void setMinMax(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d2;
        this.minY = d3;
        this.maxY = d4;
    }

    double toX(int n, int n2, boolean bl) {
        return this.toXScaled(n, n2, bl, this.xFactorForScale);
    }

    double toX0(int n, int n2, int n3, boolean bl) {
        return this.toXScaled(n, n3, bl, (this.maxXOnScale - this.minXOnScale) / (double)(n3 - n2));
    }

    private double toXScaled(int n, int n2, boolean bl, double d) {
        return bl ? this.maxXOnScale - (double)(n2 - n) * d : this.minXOnScale + (double)(n2 - n) * d;
    }

    int toPixelX(double d, int n, int n2, boolean bl) {
        return this.toPixelXScaled(d, n, n2, bl, this.xFactorForScale);
    }

    int toPixelX0(double d, int n, int n2, boolean bl) {
        return this.toPixelXScaled(d, n, n2, bl, (this.maxXOnScale - this.minXOnScale) / (double)(n2 - n));
    }

    private int toPixelXScaled(double d, int n, int n2, boolean bl, double d2) {
        int n3 = (int)((d - this.minXOnScale) / d2);
        return bl ? n + n3 : n2 - n3;
    }

    double toY(int n, int n2) {
        return this.maxYOnScale + (double)(n2 - n) * this.yFactorForScale;
    }

    double toY0(int n, int n2, int n3) {
        double d = (this.maxYOnScale - this.minYOnScale) / (double)(n3 - n2);
        double d2 = this.maxYOnScale + (double)(n2 - n) * d;
        return Math.max(this.minYOnScale, Math.min(d2, this.maxYOnScale));
    }

    int toPixelY(double d, int n) {
        return Double.isNaN(d) ? Integer.MIN_VALUE : n - (int)(((d - this.spectrumYRef) * this.userYFactor + this.spectrumYRef - this.minYOnScale) / this.yFactorForScale);
    }

    int toPixelY0(double d, int n, int n2) {
        double d2 = (this.maxYOnScale - this.minYOnScale) / (double)(n2 - n);
        return (int)((double)n + (this.maxYOnScale - d) / d2);
    }

    void setXYScale(int n, int n2, boolean bl) {
        double d;
        double d2 = this.spectrumYRef;
        double d3 = this.spectrumScaleFactor;
        boolean bl2 = d3 != 1.0 || this.isShiftZoomedY;
        double d4 = bl2 ? this.initMinYOnScale : this.minY;
        double d5 = d = bl2 ? this.initMaxYOnScale : this.maxY;
        if (bl2 && d2 < d4) {
            d2 = d4;
        }
        if (bl2 && d2 > d) {
            d2 = d;
        }
        this.setYScale((d4 - d2) / d3 + d2, (d - d2) / d3 + d2, d3 == 1.0, bl);
        this.xFactorForScale = (this.maxXOnScale - this.minXOnScale) / (double)(n - 1);
        this.yFactorForScale = (this.maxYOnScale - this.minYOnScale) / (double)(n2 - 1);
    }

    static void copyScaleFactors(ScaleData[] scaleDataArray, ScaleData[] scaleDataArray2) {
        for (int i = 0; i < scaleDataArray.length; ++i) {
            scaleDataArray2[i].spectrumScaleFactor = scaleDataArray[i].spectrumScaleFactor;
            scaleDataArray2[i].spectrumYRef = scaleDataArray[i].spectrumYRef;
            scaleDataArray2[i].userYFactor = scaleDataArray[i].userYFactor;
            scaleDataArray2[i].specShift = scaleDataArray[i].specShift;
            scaleDataArray2[i].isShiftZoomedY = scaleDataArray[i].isShiftZoomedY;
        }
    }

    static void copyYScales(ScaleData[] scaleDataArray, ScaleData[] scaleDataArray2) {
        for (int i = 0; i < scaleDataArray.length; ++i) {
            scaleDataArray2[i].initMinYOnScale = scaleDataArray[i].initMinYOnScale;
            scaleDataArray2[i].initMaxYOnScale = scaleDataArray[i].initMaxYOnScale;
            scaleDataArray2[i].minY = scaleDataArray[i].minY;
            scaleDataArray2[i].maxY = scaleDataArray[i].maxY;
            if (!scaleDataArray[i].isShiftZoomedY) continue;
            scaleDataArray2[i].isShiftZoomedY = true;
            scaleDataArray2[i].minYOnScale = scaleDataArray[i].minYOnScale;
            scaleDataArray2[i].maxYOnScale = scaleDataArray[i].maxYOnScale;
        }
    }

    static boolean setDataPointIndices(Lst<Spectrum> lst, double d, double d2, int n, int[] nArray, int[] nArray2) {
        int n2 = 0;
        int n3 = lst.size();
        for (int i = 0; i < n3; ++i) {
            Coordinate[] coordinateArray = ((Spectrum)lst.get(i)).getXYCoords();
            if (ScaleData.getXRange(i, coordinateArray, d, d2, 0, coordinateArray.length - 1, nArray, nArray2) < n) continue;
            ++n2;
        }
        return n2 == n3;
    }

    /*
     * Unable to fully structure code
     */
    static void fixScale(Map<Double, String> var0) {
        if (var0.isEmpty()) {
            return;
        }
        while (true) {
            for (Map.Entry<Double, String> var2_2 : var0.entrySet()) {
                var3_3 = var2_2.getValue();
                var4_4 = var3_3.indexOf("E");
                if (var4_4 >= 0) {
                    var3_3 = var3_3.substring(0, var4_4);
                }
                if (var3_3.indexOf(".") < 0) {
                    return;
                }
                if (var3_3.endsWith("0") || var3_3.endsWith(".")) continue;
                return;
            }
            var1_1 = var0.entrySet().iterator();
            while (true) {
                if (!var1_1.hasNext()) ** continue;
                var2_2 = var1_1.next();
                var3_3 = var2_2.getValue();
                var4_4 = var3_3.indexOf("E");
                if (var4_4 >= 0) {
                    var2_2.setValue(var3_3.substring(0, var4_4 - 1) + var3_3.substring(var4_4));
                    continue;
                }
                var2_2.setValue(var3_3.substring(0, var3_3.length() - 1));
            }
            break;
        }
    }

    void scaleBy(double d) {
        if (this.isShiftZoomedY) {
            double d2 = this.isYZeroOnScale() ? this.spectrumYRef : (this.minYOnScale + this.maxYOnScale) / 2.0;
            this.minYOnScale = d2 - (d2 - this.minYOnScale) / d;
            this.maxYOnScale = d2 - (d2 - this.maxYOnScale) / d;
        } else {
            this.spectrumScaleFactor *= d;
        }
    }
}

